/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.RedundantLetInspectionKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H$R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLetInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionText", "isApplicable", "", "bodyExpression", "Lcom/intellij/psi/PsiElement;", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "parameterName", "idea"})
public abstract class RedundantLetInspection
extends AbstractApplicabilityBasedInspection<KtCallExpression> {
    @NotNull
    private final String defaultFixText = KotlinBundle.message("remove.let.call", new Object[0]);

    @Override
    @NotNull
    public String inspectionText(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return KotlinBundle.message("redundant.let.call.could.be.removed", new Object[0]);
    }

    @Override
    @Nullable
    public final TextRange inspectionHighlightRangeInElement(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getCalleeExpression();
        return ktExpression != null ? ExpressionExtKt.textRangeIn((PsiElement)ktExpression, (PsiElement)element3) : null;
    }

    @Override
    @NotNull
    public final String getDefaultFixText() {
        return this.defaultFixText;
    }

    @Override
    public final boolean isApplicable(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!RedundantLetInspectionKt.access$isLetMethodCall(element3)) {
            return false;
        }
        List<KtLambdaArgument> list2 = element3.getLambdaArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.lambdaArguments");
        KtElement ktElement = (KtLambdaArgument)CollectionsKt.firstOrNull(list2);
        if (ktElement == null || (ktElement = ((KtLambdaArgument)ktElement).getLambdaExpression()) == null) {
            return false;
        }
        KtElement lambdaExpression2 = ktElement;
        String string = RedundantLetInspectionKt.access$getParameterName((KtLambdaExpression)lambdaExpression2);
        if (string == null) {
            return false;
        }
        String parameterName2 = string;
        PsiElement psiElement2 = ((KtLambdaExpression)lambdaExpression2).getBodyExpression();
        if (psiElement2 == null || (psiElement2 = psiElement2.getChildren()) == null || (psiElement2 = (PsiElement)ArraysKt.singleOrNull((Object[])psiElement2)) == null) {
            return false;
        }
        return this.isApplicable(element3, psiElement2, (KtLambdaExpression)lambdaExpression2, parameterName2);
    }

    protected abstract boolean isApplicable(@NotNull KtCallExpression var1, @NotNull PsiElement var2, @NotNull KtLambdaExpression var3, @NotNull String var4);

    @Override
    public final void applyTo(@NotNull KtCallExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        block3: {
            PsiElement bodyExpression;
            block5: {
                KtElement lambdaExpression2;
                block4: {
                    block2: {
                        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                        List<KtLambdaArgument> list2 = element3.getLambdaArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.lambdaArguments");
                        KtElement ktElement = (KtLambdaArgument)CollectionsKt.firstOrNull(list2);
                        if (ktElement == null || (ktElement = ((KtLambdaArgument)ktElement).getLambdaExpression()) == null) {
                            return;
                        }
                        lambdaExpression2 = ktElement;
                        PsiElement psiElement2 = ((KtLambdaExpression)lambdaExpression2).getBodyExpression();
                        if (psiElement2 == null || (psiElement2 = psiElement2.getChildren()) == null || (psiElement2 = (PsiElement)ArraysKt.singleOrNull((Object[])psiElement2)) == null) {
                            return;
                        }
                        bodyExpression = psiElement2;
                        if (!(bodyExpression instanceof KtDotQualifiedExpression)) break block2;
                        RedundantLetInspectionKt.access$applyTo((KtDotQualifiedExpression)bodyExpression, element3);
                        break block3;
                    }
                    if (!(bodyExpression instanceof KtBinaryExpression)) break block4;
                    RedundantLetInspectionKt.access$applyTo((KtBinaryExpression)bodyExpression, element3);
                    break block3;
                }
                if (!(bodyExpression instanceof KtCallExpression)) break block5;
                KtCallExpression ktCallExpression = (KtCallExpression)bodyExpression;
                KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)lambdaExpression2).getFunctionLiteral();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
                RedundantLetInspectionKt.access$applyTo(ktCallExpression, element3, ktFunctionLiteral, editor2);
                break block3;
            }
            if (!(bodyExpression instanceof KtSimpleNameExpression)) break block3;
            RedundantLetInspectionKt.access$deleteCall(element3);
        }
    }

    public RedundantLetInspection() {
        super(KtCallExpression.class);
    }
}

