/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.SuspiciousCollectionReassignmentInspectionKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiUnifierKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0002J!\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0005H\u0082\u0010J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithOperatorAssignmentInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "buildOperatorAssignment", "buildOperatorAssignmentText", "variableExpression", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "expression", "tail", "checkExpressionRepeat", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "fixText", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "inspectionText", "isApplicable", "isArithmeticOperation", "operationToken", "Lcom/intellij/psi/tree/IElementType;", "isCommutative", "idea"})
public final class ReplaceWithOperatorAssignmentInspection
extends AbstractApplicabilityBasedInspection<KtBinaryExpression> {
    @NotNull
    private final String defaultFixText = KotlinBundle.message("replace.with.operator.assignment", new Object[0]);

    @Override
    public boolean isApplicable(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (Intrinsics.areEqual((Object)element3.getOperationToken(), (Object)((Object)KtTokens.EQ)) ^ true) {
            return false;
        }
        KtExpression ktExpression = element3.getLeft();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        if (ktNameReferenceExpression == null) {
            return false;
        }
        KtNameReferenceExpression left = ktNameReferenceExpression;
        KtExpression ktExpression2 = element3.getRight();
        if (!(ktExpression2 instanceof KtBinaryExpression)) {
            ktExpression2 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression2;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression right2 = ktBinaryExpression;
        if (right2.getLeft() == null || right2.getRight() == null) {
            return false;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)right2, (BodyResolveMode)BodyResolveMode.PARTIAL_WITH_CFA);
        if (!this.checkExpressionRepeat(left, right2, bindingContext2)) {
            return false;
        }
        KtBinaryExpression opAssign = this.buildOperatorAssignment(element3);
        KtFile ktFile = opAssign.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"opAssign.containingKtFile");
        KtPsiFactoryKt.setDoNotAnalyze(ktFile, null);
        BindingContext newBindingContext = AnalyzerUtilKt.analyzeAsReplacement$default((KtExpression)opAssign, (KtExpression)element3, (BindingContext)bindingContext2, null, null, null, (int)28, null);
        Diagnostics diagnostics2 = newBindingContext.getDiagnostics();
        KtOperationReferenceExpression ktOperationReferenceExpression = opAssign.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"opAssign.operationReference");
        return diagnostics2.forElement((PsiElement)ktOperationReferenceExpression).isEmpty();
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return KotlinBundle.message("replaceable.with.operator.assignment", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return this.defaultFixText;
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtBinaryExpression element3) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Object[] objectArray = new Object[1];
        StringBuilder stringBuilder2 = new StringBuilder();
        KtExpression ktExpression = element3.getRight();
        if (!(ktExpression instanceof KtBinaryExpression)) {
            ktExpression = null;
        }
        objectArray[0] = stringBuilder2.append(String.valueOf((object = (KtBinaryExpression)ktExpression) != null && (object = ((KtBinaryExpression)object).getOperationReference()) != null && (object = ((KtOperationReferenceExpression)object).getOperationSignTokenType()) != null ? ((KtSingleValueToken)((Object)object)).getValue() : null)).append('=').toString();
        return KotlinBundle.message("replace.with.0", objectArray);
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtBinaryExpression element3) {
        KtNameReferenceExpression left;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getLeft();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        if ((left = (KtNameReferenceExpression)ktExpression) != null) {
            KotlinType leftType;
            BindingContext context2 = ResolutionUtils.analyze((KtElement)left, (BodyResolveMode)BodyResolveMode.PARTIAL);
            KotlinType kotlinType = leftType = CallUtilKt.getType(left, context2);
            if (kotlinType != null) {
                if (SuspiciousCollectionReassignmentInspectionKt.isReadOnlyCollectionOrMap(kotlinType, PlatformKt.getBuiltIns(element3))) {
                    return ProblemHighlightType.INFORMATION;
                }
            }
        }
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    private final boolean checkExpressionRepeat(KtNameReferenceExpression variableExpression, KtBinaryExpression expression2, BindingContext bindingContext2) {
        boolean bl;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        DeclarationDescriptor descriptor2 = declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null;
        boolean isPrimitiveOperation = descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isPrimitiveType(((ClassDescriptor)descriptor2).getDefaultType());
        IElementType iElementType = expression2.getOperationToken();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"expression.operationToken");
        IElementType operationToken = iElementType;
        KtExpression expressionLeft = expression2.getLeft();
        KtExpression expressionRight = expression2.getRight();
        if (KotlinPsiUnifierKt.matches((PsiElement)((PsiElement)variableExpression), (PsiElement)((PsiElement)expressionLeft))) {
            bl = this.isArithmeticOperation(operationToken);
        } else if (KotlinPsiUnifierKt.matches((PsiElement)((PsiElement)variableExpression), (PsiElement)((PsiElement)expressionRight))) {
            bl = isPrimitiveOperation && this.isCommutative(operationToken);
        } else if (expressionLeft instanceof KtBinaryExpression) {
            boolean sameCommutativeOperation;
            boolean bl2 = sameCommutativeOperation = Intrinsics.areEqual((Object)((KtBinaryExpression)expressionLeft).getOperationToken(), (Object)operationToken) && this.isCommutative(operationToken);
            bl = isPrimitiveOperation && sameCommutativeOperation && this.checkExpressionRepeat(variableExpression, (KtBinaryExpression)expressionLeft, bindingContext2);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isCommutative(IElementType operationToken) {
        return Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.PLUS)) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.MUL));
    }

    private final boolean isArithmeticOperation(IElementType operationToken) {
        return Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.PLUS)) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.MINUS)) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.MUL)) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.DIV)) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.PERC));
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        element3.replace((PsiElement)this.buildOperatorAssignment(element3));
    }

    private final KtBinaryExpression buildOperatorAssignment(KtBinaryExpression element3) {
        KtExpression ktExpression = element3.getLeft();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        }
        KtExpression ktExpression2 = element3.getRight();
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        String replacement2 = this.buildOperatorAssignmentText((KtNameReferenceExpression)ktExpression, (KtBinaryExpression)ktExpression2, "");
        KtExpression ktExpression3 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null).createExpression(replacement2);
        if (ktExpression3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        return (KtBinaryExpression)ktExpression3;
    }

    private final String buildOperatorAssignmentText(KtNameReferenceExpression variableExpression, KtBinaryExpression expression2, String tail) {
        String string;
        block7: {
            while (true) {
                KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
                String operationText = ktOperationReferenceExpression.getText();
                String variableName = variableExpression.getText();
                Function1<String, String> $fun$appendTail$1 = new Function1<String, String>(tail){
                    final /* synthetic */ String $tail;

                    @NotNull
                    public final String invoke(@NotNull String $this$appendTail) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$appendTail, (String)"$this$appendTail");
                        CharSequence charSequence = this.$tail;
                        boolean bl = false;
                        return charSequence.length() == 0 ? $this$appendTail : $this$appendTail + ' ' + this.$tail;
                    }
                    {
                        this.$tail = string;
                        super(1);
                    }
                };
                if (KotlinPsiUnifierKt.matches((PsiElement)((PsiElement)variableExpression), (PsiElement)((PsiElement)expression2.getLeft()))) {
                    StringBuilder stringBuilder2 = new StringBuilder().append(variableName).append(' ').append(operationText).append("= ");
                    KtExpression ktExpression = expression2.getRight();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.right!!");
                    string = $fun$appendTail$1.invoke(stringBuilder2.append(ktExpression.getText()).toString());
                    break block7;
                }
                if (KotlinPsiUnifierKt.matches((PsiElement)((PsiElement)variableExpression), (PsiElement)((PsiElement)expression2.getRight()))) {
                    StringBuilder stringBuilder3 = new StringBuilder().append(variableName).append(' ').append(operationText).append("= ");
                    KtExpression ktExpression = expression2.getLeft();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
                    string = $fun$appendTail$1.invoke(stringBuilder3.append(ktExpression.getText()).toString());
                    break block7;
                }
                if (!(expression2.getLeft() instanceof KtBinaryExpression)) break;
                KtExpression ktExpression = expression2.getLeft();
                if (ktExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                }
                KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression;
                StringBuilder stringBuilder4 = new StringBuilder().append(operationText).append(' ');
                KtExpression ktExpression2 = expression2.getRight();
                if (ktExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
                tail = $fun$appendTail$1.invoke(stringBuilder4.append(ktExpression2.getText()).toString());
                expression2 = ktBinaryExpression;
            }
            string = tail;
        }
        return string;
    }

    public ReplaceWithOperatorAssignmentInspection() {
        super(KtBinaryExpression.class);
    }
}

