/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SimplifyAssertNotNullInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "extractMessage", "Lorg/jetbrains/kotlin/psi/KtExpression;", "findVariableDeclaration", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "fixText", "inspectionText", "isApplicable", "", "idea"})
public final class SimplifyAssertNotNullInspection
extends AbstractApplicabilityBasedInspection<KtCallExpression> {
    @NotNull
    private final String defaultFixText = KotlinBundle.message("replace.assert.with.operator", new Object[0]);

    @Override
    public boolean isApplicable(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getCalleeExpression();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        if (Intrinsics.areEqual((Object)(ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null), (Object)"assert") ^ true) {
            return false;
        }
        List<KtValueArgument> list2 = element3.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.valueArguments");
        List<KtValueArgument> arguments2 = list2;
        if (arguments2.size() != 1 && arguments2.size() != 2) {
            return false;
        }
        KtExpression ktExpression2 = ((KtValueArgument)CollectionsKt.first(arguments2)).getArgumentExpression();
        if (!(ktExpression2 instanceof KtBinaryExpression)) {
            ktExpression2 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression2;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression condition2 = ktBinaryExpression;
        if (Intrinsics.areEqual((Object)condition2.getOperationToken(), (Object)((Object)KtTokens.EXCLEQ)) ^ true) {
            return false;
        }
        KtExpression ktExpression3 = IfThenUtilsKt.expressionComparedToNull(condition2);
        if (!(ktExpression3 instanceof KtNameReferenceExpression)) {
            ktExpression3 = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression2 = (KtNameReferenceExpression)ktExpression3;
        if (ktNameReferenceExpression2 == null) {
            return false;
        }
        KtNameReferenceExpression value2 = ktNameReferenceExpression2;
        KtVariableDeclaration ktVariableDeclaration = this.findVariableDeclaration(element3);
        if (ktVariableDeclaration == null) {
            return false;
        }
        KtVariableDeclaration prevDeclaration = ktVariableDeclaration;
        if (Intrinsics.areEqual((Object)value2.getReferencedNameAsName(), (Object)prevDeclaration.getNameAsName()) ^ true) {
            return false;
        }
        if (prevDeclaration.getInitializer() == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)element3, null, (int)1, null);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        if (!ArgumentMappingKt.isReallySuccess(resolvedCall3)) {
            return false;
        }
        Object d = resolvedCall3.getResultingDescriptor();
        if (!(d instanceof FunctionDescriptor)) {
            d = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)d;
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor function2 = functionDescriptor2;
        FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)function2);
        if (Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)"kotlin.assert") ^ true) {
            return false;
        }
        return arguments2.size() == 1 || this.extractMessage(element3) != null;
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return KotlinBundle.message("assert.should.be.replaced.with.operator", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return this.defaultFixText;
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return element3.getValueArguments().size() == 1 ? KotlinBundle.message("replace.with.0.operator", "!!") : KotlinBundle.message("replace.with.error", new Object[0]);
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        KtExpression newInitializer;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        KtVariableDeclaration ktVariableDeclaration = this.findVariableDeclaration(element3);
        if (ktVariableDeclaration == null) {
            return;
        }
        KtVariableDeclaration declaration2 = ktVariableDeclaration;
        KtExpression ktExpression = declaration2.getInitializer();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"declaration.initializer ?: return");
        KtExpression initializer2 = ktExpression;
        KtExpression message2 = this.extractMessage(element3);
        CommentSaver commentSaver = new CommentSaver((PsiElement)element3, false, 2, null);
        if (message2 == null) {
            newInitializer = CreateByPatternKt.createExpressionByPattern$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null), "$0!!", new Object[]{initializer2}, false, 4, null);
            initializer2.replace((PsiElement)newInitializer);
        } else {
            PsiElement result2;
            newInitializer = CreateByPatternKt.createExpressionByPattern$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null), "$0 ?: kotlin.error($1)", new Object[]{initializer2, message2}, false, 4, null);
            PsiElement psiElement2 = result2 = initializer2.replace((PsiElement)newInitializer);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            }
            KtExpression ktExpression2 = ((KtBinaryExpression)psiElement2).getRight();
            if (ktExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
            }
            KtDotQualifiedExpression qualifiedExpression = (KtDotQualifiedExpression)ktExpression2;
            KtFile ktFile = element3.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"element.containingKtFile");
            int n = PsiUtilsKt.getStartOffset((PsiElement)qualifiedExpression);
            KtExpression ktExpression3 = qualifiedExpression.getSelectorExpression();
            if (ktExpression3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            KtExpression ktExpression4 = ((KtCallExpression)ktExpression3).getCalleeExpression();
            if (ktExpression4 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"(qualifiedExpression.sel\u2026ssion).calleeExpression!!");
            ShortenReferences.process$default(ShortenReferences.DEFAULT, ktFile, n, PsiUtilsKt.getEndOffset((PsiElement)ktExpression4), null, 8, null);
        }
        element3.delete();
        CommentSaver.restore$default(commentSaver, declaration2, false, 2, null);
        if (editor2 != null) {
            int n;
            PsiElement psiElement3 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)declaration2);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"CodeInsightUtilCore.forc\u2026storeElement(declaration)");
            KtExpression ktExpression5 = ((KtVariableDeclaration)psiElement3).getInitializer();
            if (ktExpression5 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"CodeInsightUtilCore.forc\u2026eclaration).initializer!!");
            newInitializer = ktExpression5;
            if (message2 == null) {
                n = PsiUtilsKt.getEndOffset((PsiElement)newInitializer);
            } else {
                KtExpression ktExpression6 = newInitializer;
                if (ktExpression6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                }
                KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)ktExpression6).getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"(newInitializer as KtBin\u2026ssion).operationReference");
                n = PsiUtilsKt.getStartOffset((PsiElement)ktOperationReferenceExpression);
            }
            int offset2 = n;
            GenerateUtilKt.moveCaret$default(editor2, offset2, null, 2, null);
        }
    }

    private final KtVariableDeclaration findVariableDeclaration(KtCallExpression element3) {
        Object v1;
        Object v0;
        block3: {
            if (!(element3.getParent() instanceof KtBlockExpression)) {
                return null;
            }
            Sequence<PsiElement> $this$firstIsInstanceOrNull$iv = PsiUtilsKt.siblings((PsiElement)element3, false, false);
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof KtExpression)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof KtVariableDeclaration)) {
            v1 = null;
        }
        return v1;
    }

    private final KtExpression extractMessage(KtCallExpression element3) {
        Object object;
        List<KtValueArgument> list2 = element3.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.valueArguments");
        List<KtValueArgument> arguments2 = list2;
        if (arguments2.size() != 2) {
            return null;
        }
        KtExpression ktExpression = arguments2.get(1).getArgumentExpression();
        if (!(ktExpression instanceof KtLambdaExpression)) {
            ktExpression = null;
        }
        return (object = (KtLambdaExpression)ktExpression) != null && (object = ((KtLambdaExpression)object).getBodyExpression()) != null && (object = ((KtBlockExpression)object).getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : null;
    }

    public SimplifyAssertNotNullInspection() {
        super(KtCallExpression.class);
    }
}

