/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.Data;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0004"}, d2={"extractData", "Lorg/jetbrains/kotlin/idea/intentions/Data;", "element", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "idea"})
public final class ObjectLiteralToLambdaIntentionKt {
    private static final Data extractData(KtObjectLiteralExpression element3) {
        KtObjectDeclaration ktObjectDeclaration = element3.getObjectDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktObjectDeclaration, (String)"element.objectDeclaration");
        KtObjectDeclaration objectDeclaration = ktObjectDeclaration;
        Object object = CollectionsKt.singleOrNull(objectDeclaration.getDeclarations());
        if (!(object instanceof KtNamedFunction)) {
            object = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)object;
        if (ktNamedFunction == null) {
            return null;
        }
        KtNamedFunction singleFunction = ktNamedFunction;
        if (!singleFunction.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return null;
        }
        KtSuperTypeListEntry ktSuperTypeListEntry = (KtSuperTypeListEntry)CollectionsKt.singleOrNull(objectDeclaration.getSuperTypeListEntries());
        if (ktSuperTypeListEntry == null) {
            return null;
        }
        KtSuperTypeListEntry delegationSpecifier = ktSuperTypeListEntry;
        KtTypeReference ktTypeReference = delegationSpecifier.getTypeReference();
        if (ktTypeReference == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"delegationSpecifier.typeReference ?: return null");
        KtTypeReference typeRef = ktTypeReference;
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)typeRef, (BodyResolveMode)BodyResolveMode.PARTIAL);
        KotlinType kotlinType = (KotlinType)bindingContext2.get(BindingContext.TYPE, typeRef);
        if (kotlinType == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"bindingContext[BindingCo\u2026, typeRef] ?: return null");
        KotlinType baseType = kotlinType;
        return new Data(typeRef, baseType, singleFunction);
    }

    public static final /* synthetic */ Data access$extractData(KtObjectLiteralExpression element3) {
        return ObjectLiteralToLambdaIntentionKt.extractData(element3);
    }
}

