/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameProcessor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RenameClassToContainingFileNameIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startInWriteAction", "", "idea"})
public final class RenameClassToContainingFileNameIntention
extends SelfTargetingRangeIntention<KtClassOrObject> {
    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClassOrObject element3) {
        String fileName;
        block10: {
            block9: {
                boolean bl;
                block8: {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    if (!element3.isTopLevel()) {
                        return null;
                    }
                    KtFile ktFile = element3.getContainingKtFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"element.containingKtFile");
                    String string = FileUtil.getNameWithoutExtension((String)ktFile.getName());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.getNameWithoutE\u2026nt.containingKtFile.name)");
                    fileName = string;
                    if (Intrinsics.areEqual((Object)fileName, (Object)element3.getName())) break block9;
                    CharSequence charSequence = fileName;
                    boolean bl2 = false;
                    if (charSequence.length() == 0) break block9;
                    char c = fileName.charAt(0);
                    bl2 = false;
                    if (Character.isLowerCase(c) || !Name.isValidIdentifier(fileName)) break block9;
                    Name name2 = Name.identifier(fileName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(fileName)");
                    if (Intrinsics.areEqual((Object)RenderingUtilsKt.render(name2), (Object)fileName) ^ true) break block9;
                    KtFile ktFile2 = element3.getContainingKtFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"element.containingKtFile");
                    Iterable $this$any$iv = ktFile2.getDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDeclaration it = (KtDeclaration)element$iv;
                            boolean bl3 = false;
                            if (!(it instanceof KtClassOrObject && Intrinsics.areEqual((Object)((KtClassOrObject)it).getName(), (Object)fileName))) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block10;
            }
            return null;
        }
        this.setText(KotlinBundle.message("rename.class.to.0", fileName));
        PsiElement psiElement2 = element3.getNameIdentifier();
        return psiElement2 != null ? psiElement2.getTextRange() : null;
    }

    @Override
    public void applyTo(@NotNull KtClassOrObject element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"element.containingKtFile");
        KtFile file2 = ktFile;
        KtFile ktFile2 = element3.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"element.containingKtFile");
        String string = FileUtil.getNameWithoutExtension((String)ktFile2.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.getNameWithoutE\u2026nt.containingKtFile.name)");
        String fileName = string;
        new RenameProcessor(file2.getProject(), (PsiElement)element3, fileName, false, false).run();
    }

    public RenameClassToContainingFileNameIntention() {
        super(KtClassOrObject.class, KotlinBundle.message("rename.class.to.containing.file.name", new Object[0]), null, 4, null);
    }
}

