/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.AddPropertyToSupertypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFix;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0019\u001aB\u001d\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J#\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0094\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddPropertyToSupertypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "element", "properties", "", "Lorg/jetbrains/kotlin/idea/quickfix/AddPropertyToSupertypeFix$PropertyData;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Ljava/util/List;)V", "actionName", "", "propertyData", "addProperty", "", "project", "Lcom/intellij/openapi/project/Project;", "createPropertyPopup", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "getFamilyName", "getText", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "PropertyData", "idea"})
public final class AddPropertyToSupertypeFix
extends KotlinQuickFixAction<KtProperty>
implements LowPriorityAction {
    private final List<PropertyData> properties;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        PropertyData single = (PropertyData)CollectionsKt.singleOrNull(this.properties);
        return single != null ? this.actionName(single) : KotlinBundle.message("fix.add.property.to.supertype.text.generic", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.add.property.to.supertype.family", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(this, editor2, project2){
            final /* synthetic */ AddPropertyToSupertypeFix this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Project $project;

            /*
             * Enabled aggressive block sorting
             */
            public final void run() {
                if (AddPropertyToSupertypeFix.access$getProperties$p(this.this$0).size() != 1 && this.$editor != null) {
                    JComponent jComponent = this.$editor.getComponent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"editor.component");
                    if (jComponent.isShowing()) {
                        JBPopupFactory.getInstance().createListPopup(AddPropertyToSupertypeFix.access$createPropertyPopup(this.this$0, this.$project)).showInBestPositionFor(this.$editor);
                        return;
                    }
                }
                AddPropertyToSupertypeFix.access$addProperty(this.this$0, (PropertyData)CollectionsKt.first((List)AddPropertyToSupertypeFix.access$getProperties$p(this.this$0)), this.$project);
            }
            {
                this.this$0 = addPropertyToSupertypeFix;
                this.$editor = editor2;
                this.$project = project2;
            }
        });
    }

    private final void addProperty(PropertyData propertyData, Project project2) {
        ApplicationUtilsKt.executeWriteCommand(project2, KotlinBundle.message("fix.add.property.to.supertype.progress", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>(propertyData, project2){
            final /* synthetic */ PropertyData $propertyData;
            final /* synthetic */ Project $project;

            public final void invoke() {
                IElementType iElementType;
                KtClassBody classBody = KtClassOrObjectKt.getOrCreateBody(this.$propertyData.getTargetClass());
                KtProperty propertyElement = new KtPsiFactory(this.$project, false, 2, null).createProperty(this.$propertyData.getSourceCode());
                PsiElement psiElement2 = classBody.addBefore(propertyElement, classBody.getRBrace());
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                }
                KtProperty insertedPropertyElement = (KtProperty)psiElement2;
                ShortenReferences.process$default(ShortenReferences.DEFAULT, insertedPropertyElement, null, 2, null);
                PsiElement psiElement3 = KtPsiUtilKt.modalityModifier(insertedPropertyElement);
                if (!((psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : (iElementType = null)) instanceof KtModifierKeywordToken)) {
                    iElementType = null;
                }
                KtModifierKeywordToken ktModifierKeywordToken = (KtModifierKeywordToken)iElementType;
                if (ktModifierKeywordToken == null) {
                    return;
                }
                KtModifierKeywordToken modifierToken = ktModifierKeywordToken;
                if (Intrinsics.areEqual((Object)((Object)PsiModificationUtilsKt.implicitModality(insertedPropertyElement)), (Object)((Object)modifierToken))) {
                    new RemoveModifierFix(insertedPropertyElement, modifierToken, true).invoke();
                }
            }
            {
                this.$propertyData = propertyData;
                this.$project = project2;
                super(0);
            }
        }));
    }

    private final ListPopupStep<?> createPropertyPopup(Project project2) {
        return (ListPopupStep)new BaseListPopupStep<PropertyData>(this, project2, KotlinBundle.message("fix.add.property.to.supertype.choose.type", new Object[0]), this.properties){
            final /* synthetic */ AddPropertyToSupertypeFix this$0;
            final /* synthetic */ Project $project;

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            @Nullable
            public PopupStep<?> onChosen(@NotNull PropertyData selectedValue, boolean finalChoice) {
                Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"selectedValue");
                if (finalChoice) {
                    AddPropertyToSupertypeFix.access$addProperty(this.this$0, selectedValue, this.$project);
                }
                return PopupStep.FINAL_CHOICE;
            }

            public Icon getIconFor(@NotNull PropertyData value2) {
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                return PlatformIcons.PROPERTY_ICON;
            }

            @NotNull
            public String getTextFor(@NotNull PropertyData value2) {
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                return AddPropertyToSupertypeFix.access$actionName(this.this$0, value2);
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
    }

    private final String actionName(PropertyData propertyData) {
        return KotlinBundle.message("fix.add.property.to.supertype.text", propertyData.getSignaturePreview(), String.valueOf(propertyData.getTargetClass().getName()));
    }

    private AddPropertyToSupertypeFix(KtProperty element3, List<PropertyData> properties2) {
        super((PsiElement)element3);
        this.properties = properties2;
    }

    public static final /* synthetic */ List access$getProperties$p(AddPropertyToSupertypeFix $this) {
        return $this.properties;
    }

    public static final /* synthetic */ void access$addProperty(AddPropertyToSupertypeFix $this, PropertyData propertyData, Project project2) {
        $this.addProperty(propertyData, project2);
    }

    public static final /* synthetic */ ListPopupStep access$createPropertyPopup(AddPropertyToSupertypeFix $this, Project project2) {
        return $this.createPropertyPopup(project2);
    }

    public static final /* synthetic */ String access$actionName(AddPropertyToSupertypeFix $this, PropertyData propertyData) {
        return $this.actionName(propertyData);
    }

    public /* synthetic */ AddPropertyToSupertypeFix(KtProperty element3, List properties2, DefaultConstructorMarker $constructor_marker) {
        this(element3, properties2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddPropertyToSupertypeFix$PropertyData;", "", "signaturePreview", "", "sourceCode", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtClass;)V", "getSignaturePreview", "()Ljava/lang/String;", "getSourceCode", "getTargetClass", "()Lorg/jetbrains/kotlin/psi/KtClass;", "idea"})
    private static final class PropertyData {
        @NotNull
        private final String signaturePreview;
        @NotNull
        private final String sourceCode;
        @NotNull
        private final KtClass targetClass;

        @NotNull
        public final String getSignaturePreview() {
            return this.signaturePreview;
        }

        @NotNull
        public final String getSourceCode() {
            return this.sourceCode;
        }

        @NotNull
        public final KtClass getTargetClass() {
            return this.targetClass;
        }

        public PropertyData(@NotNull String signaturePreview, @NotNull String sourceCode, @NotNull KtClass targetClass) {
            Intrinsics.checkParameterIsNotNull((Object)signaturePreview, (String)"signaturePreview");
            Intrinsics.checkParameterIsNotNull((Object)sourceCode, (String)"sourceCode");
            Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
            this.signaturePreview = signaturePreview;
            this.sourceCode = sourceCode;
            this.targetClass = targetClass;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010*\b\u0012\u0004\u0012\u00020\u00190\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddPropertyToSupertypeFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "createPropertyData", "Lorg/jetbrains/kotlin/idea/quickfix/AddPropertyToSupertypeFix$PropertyData;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "initializer", "Lorg/jetbrains/kotlin/psi/KtExpression;", "project", "Lcom/intellij/openapi/project/Project;", "generatePropertiesToAdd", "", "propertyElement", "Lorg/jetbrains/kotlin/psi/KtProperty;", "generatePropertySignatureForType", "typeDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getSuperClasses", "classDescriptor", "sortSubtypesFirst", "Lorg/jetbrains/kotlin/types/KotlinType;", "", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtProperty)) {
                psiElement2 = null;
            }
            KtProperty ktProperty = (KtProperty)psiElement2;
            if (ktProperty == null) {
                return null;
            }
            KtProperty property2 = ktProperty;
            List<PropertyDescriptor> descriptors2 = this.generatePropertiesToAdd(property2);
            if (descriptors2.isEmpty()) {
                return null;
            }
            PsiFile psiFile2 = diagnostic.getPsiFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"diagnostic.psiFile");
            Project project2 = psiFile2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"diagnostic.psiFile.project");
            Project project3 = project2;
            Iterable $this$mapNotNull$iv = descriptors2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PropertyData propertyData;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                PropertyDescriptor it = (PropertyDescriptor)element$iv$iv;
                boolean bl2 = false;
                if (Companion.createPropertyData(it, property2.getInitializer(), project3) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                PropertyData it$iv$iv = propertyData;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List propertyData = (List)destination$iv$iv;
            if (propertyData.isEmpty()) {
                return null;
            }
            return new AddPropertyToSupertypeFix(property2, propertyData, null);
        }

        private final PropertyData createPropertyData(PropertyDescriptor propertyDescriptor, KtExpression initializer2, Project project2) {
            PsiElement psiElement2;
            DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
            String signaturePreview = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.render(propertyDescriptor);
            if (classDescriptor2.getKind() == ClassKind.INTERFACE) {
                String string = signaturePreview;
                int n = "abstract ".length();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                signaturePreview = string3;
            }
            String sourceCode = IdeDescriptorRenderers.SOURCE_CODE.render(propertyDescriptor);
            if (classDescriptor2.getKind() == ClassKind.CLASS && classDescriptor2.getModality() == Modality.OPEN && initializer2 != null) {
                sourceCode = sourceCode + " = " + initializer2.getText();
            }
            if (!((psiElement2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, classDescriptor2)) instanceof KtClass)) {
                psiElement2 = null;
            }
            KtClass ktClass2 = (KtClass)psiElement2;
            if (ktClass2 == null) {
                return null;
            }
            KtClass targetClass = ktClass2;
            return new PropertyData(signaturePreview, sourceCode, targetClass);
        }

        private final List<PropertyDescriptor> generatePropertiesToAdd(KtProperty propertyElement) {
            VariableDescriptor variableDescriptor = ResolutionUtils.resolveToDescriptorIfAny((KtProperty)propertyElement, (BodyResolveMode)BodyResolveMode.FULL);
            if (!(variableDescriptor instanceof PropertyDescriptor)) {
                variableDescriptor = null;
            }
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
            if (propertyDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            DeclarationDescriptor declarationDescriptor = propertyDescriptor2.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
            if (classDescriptor2 == null) {
                return CollectionsKt.emptyList();
            }
            ClassDescriptor classDescriptor3 = classDescriptor2;
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)this.getSuperClasses(classDescriptor3)), (Function1)generatePropertiesToAdd.1.INSTANCE), (Function1)((Function1)new Function1<ClassDescriptor, PropertyDescriptor>(propertyDescriptor2){
                final /* synthetic */ PropertyDescriptor $propertyDescriptor;

                @NotNull
                public final PropertyDescriptor invoke(@NotNull ClassDescriptor it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return org.jetbrains.kotlin.idea.quickfix.AddPropertyToSupertypeFix$Companion.access$generatePropertySignatureForType(AddPropertyToSupertypeFix.Companion, this.$propertyDescriptor, it);
                }
                {
                    this.$propertyDescriptor = propertyDescriptor;
                    super(1);
                }
            })));
        }

        /*
         * WARNING - void declaration
         */
        private final List<ClassDescriptor> getSuperClasses(ClassDescriptor classDescriptor2) {
            void $this$mapNotNullTo$iv$iv;
            SimpleType simpleType2 = classDescriptor2.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"classDescriptor.defaultType");
            List<KotlinType> supertypes2 = this.sortSubtypesFirst(CollectionsKt.toMutableList(TypeUtilsKt.supertypes(simpleType2)));
            Iterable $this$mapNotNull$iv = supertypes2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ClassDescriptor classDescriptor3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KotlinType it = (KotlinType)element$iv$iv;
                boolean bl2 = false;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                if ((ClassDescriptor)classifierDescriptor == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                ClassDescriptor it$iv$iv = classDescriptor3;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<KotlinType> sortSubtypesFirst(@NotNull List<KotlinType> $this$sortSubtypesFirst) {
            KotlinTypeChecker typeChecker = KotlinTypeChecker.DEFAULT;
            int n = 1;
            int n2 = $this$sortSubtypesFirst.size();
            while (n < n2) {
                void i2;
                KotlinType currentType = $this$sortSubtypesFirst.get((int)i2);
                boolean bl = false;
                void var7_7 = i2;
                while (bl < var7_7) {
                    void j;
                    if (typeChecker.isSubtypeOf(currentType, $this$sortSubtypesFirst.get((int)j))) {
                        $this$sortSubtypesFirst.remove((int)i2);
                        $this$sortSubtypesFirst.add((int)j, currentType);
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
            return $this$sortSubtypesFirst;
        }

        private final PropertyDescriptor generatePropertySignatureForType(PropertyDescriptor propertyDescriptor, ClassDescriptor typeDescriptor) {
            Modality modality2;
            Modality modality3 = typeDescriptor.getModality();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality3), (String)"typeDescriptor.modality");
            Modality containerModality = modality3;
            if (containerModality == Modality.SEALED || containerModality == Modality.ABSTRACT) {
                modality2 = Modality.ABSTRACT;
            } else {
                Modality modality4 = propertyDescriptor.getModality();
                modality2 = modality4;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality4), (String)"propertyDescriptor.modality");
            }
            Modality modality5 = modality2;
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor.newCopyBuilder().setOwner(typeDescriptor).setModality(modality5).setVisibility(propertyDescriptor.getVisibility()).setKind(CallableMemberDescriptor.Kind.DECLARATION).setCopyOverrides(false).build();
            if (propertyDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            return propertyDescriptor2;
        }

        private Companion() {
        }

        public static final /* synthetic */ PropertyDescriptor access$generatePropertySignatureForType(Companion $this, PropertyDescriptor propertyDescriptor, ClassDescriptor typeDescriptor) {
            return $this.generatePropertySignatureForType(propertyDescriptor, typeDescriptor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

