/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.overrideImplement.ImplementMembersHandler;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideImplementMembersHandler;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObject;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ConflictingJvmDeclarationsData;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0094\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakePrivateAndOverrideMemberFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "propertyOrParameter", "memberToOverride", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/OverrideMemberChooserObject;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/idea/core/overrideImplement/OverrideMemberChooserObject;)V", "makePrivate", "", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "AccidentalOverrideFactory", "idea"})
public final class MakePrivateAndOverrideMemberFix
extends KotlinQuickFixAction<KtDeclaration> {
    private final boolean makePrivate;
    private final OverrideMemberChooserObject memberToOverride;

    @NotNull
    public String getText() {
        CallableMemberDescriptor descriptor2 = this.memberToOverride.getDescriptor();
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        boolean implement = (classDescriptor2 != null ? classDescriptor2.getKind() : null) == ClassKind.INTERFACE;
        String string = descriptor2.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.name.asString()");
        String name2 = string;
        return this.makePrivate ? KotlinBundle.message("make.private.and.0.1", implement ? KotlinBundle.message("text.implements", new Object[0]) : KotlinBundle.message("text.overrides", new Object[0]), name2) : (implement ? KotlinBundle.message("highlighter.text.implements", new Object[0]) : KotlinBundle.message("highlighter.text.overrides", new Object[0])) + " '" + name2 + '\'';
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (editor2 == null) {
            return;
        }
        KtDeclaration ktDeclaration = (KtDeclaration)this.getElement();
        if (ktDeclaration == null) {
            return;
        }
        KtDeclaration element3 = ktDeclaration;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(element3);
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject containingClassOrObject = ktClassOrObject;
        if (this.makePrivate) {
            element3.addModifier(KtTokens.PRIVATE_KEYWORD);
        }
        OverrideImplementMembersHandler.Companion.generateMembers(editor2, containingClassOrObject, CollectionsKt.listOf((Object)this.memberToOverride), false);
    }

    public MakePrivateAndOverrideMemberFix(@NotNull KtDeclaration propertyOrParameter, @NotNull OverrideMemberChooserObject memberToOverride) {
        Intrinsics.checkParameterIsNotNull((Object)propertyOrParameter, (String)"propertyOrParameter");
        Intrinsics.checkParameterIsNotNull((Object)memberToOverride, (String)"memberToOverride");
        super((PsiElement)propertyOrParameter);
        this.memberToOverride = memberToOverride;
        this.makePrivate = !propertyOrParameter.hasModifier(KtTokens.PRIVATE_KEYWORD);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakePrivateAndOverrideMemberFix$AccidentalOverrideFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "implementMembersHandler", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/ImplementMembersHandler;", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class AccidentalOverrideFactory
    extends KotlinSingleIntentionActionFactory {
        private static final ImplementMembersHandler implementMembersHandler;
        public static final AccidentalOverrideFactory INSTANCE;

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtModifierListOwner> createAction(@NotNull Diagnostic diagnostic) {
            Object v9;
            KtDeclaration element3;
            block12: {
                Annotated annotated;
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                Object d = ErrorsJvm.ACCIDENTAL_OVERRIDE.cast(diagnostic);
                Intrinsics.checkExpressionValueIsNotNull(d, (String)"ErrorsJvm.ACCIDENTAL_OVERRIDE.cast(diagnostic)");
                DiagnosticWithParameters1 casted = (DiagnosticWithParameters1)d;
                Object e = casted.getPsiElement();
                if (!(e instanceof KtDeclaration)) {
                    e = null;
                }
                KtDeclaration ktDeclaration = (KtDeclaration)e;
                if (ktDeclaration == null) {
                    return null;
                }
                element3 = ktDeclaration;
                if (!(element3 instanceof KtProperty) && !(element3 instanceof KtParameter)) {
                    return null;
                }
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(element3);
                if (ktClassOrObject == null) {
                    return null;
                }
                KtClassOrObject containingClassOrObject = ktClassOrObject;
                String memberNameToOverride = ((ConflictingJvmDeclarationsData)casted.getA()).getSignature().getName();
                DeclarationDescriptor declarationDescriptor = UtilsKt.getDescriptor(element3);
                if (!(declarationDescriptor instanceof CallableDescriptor)) {
                    declarationDescriptor = null;
                }
                if ((annotated = (CallableDescriptor)declarationDescriptor) == null || (annotated = annotated.getReturnType()) == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)annotated, (String)"(element.descriptor as? \u2026returnType ?: return null");
                Annotated returnType2 = annotated;
                boolean isGetter = JvmAbi.isGetterName(memberNameToOverride);
                boolean isSetter = JvmAbi.isSetterName(memberNameToOverride);
                Iterable $this$firstOrNull$iv = implementMembersHandler.collectMembersToGenerate(containingClassOrObject);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    OverrideMemberChooserObject it = (OverrideMemberChooserObject)element$iv;
                    boolean bl2 = false;
                    CallableMemberDescriptor descriptor2 = it.getDescriptor();
                    if (Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)memberNameToOverride) ^ true) {
                        bl = false;
                    } else {
                        KotlinType kotlinType = descriptor2.getReturnType();
                        if (kotlinType == null || (kotlinType = TypeUtilsKt.makeNotNullable(kotlinType)) == null) {
                            bl = false;
                        } else {
                            Annotated annotated2;
                            List<ValueParameterDescriptor> params2;
                            KotlinType accessorReturnType = kotlinType;
                            Intrinsics.checkExpressionValueIsNotNull(descriptor2.getValueParameters(), (String)"descriptor.valueParameters");
                            bl = isGetter && params2.isEmpty() && Intrinsics.areEqual((Object)accessorReturnType, (Object)returnType2) || isSetter && Intrinsics.areEqual((Object)((annotated2 = (ValueParameterDescriptor)CollectionsKt.singleOrNull(params2)) != null && (annotated2 = annotated2.getType()) != null ? TypeUtilsKt.makeNotNullable((KotlinType)annotated2) : null), (Object)returnType2) && TypeUtilsKt.isUnit(accessorReturnType);
                        }
                    }
                    if (!bl) continue;
                    v9 = element$iv;
                    break block12;
                }
                v9 = null;
            }
            OverrideMemberChooserObject overrideMemberChooserObject = v9;
            if (overrideMemberChooserObject == null) {
                return null;
            }
            OverrideMemberChooserObject memberToOverride = overrideMemberChooserObject;
            return new MakePrivateAndOverrideMemberFix(element3, memberToOverride);
        }

        private AccidentalOverrideFactory() {
        }

        static {
            AccidentalOverrideFactory accidentalOverrideFactory;
            INSTANCE = accidentalOverrideFactory = new AccidentalOverrideFactory();
            implementMembersHandler = new ImplementMembersHandler();
        }
    }
}

