/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveUnusedValueFix;
import org.jetbrains.kotlin.idea.quickfix.RemoveUnusedValueFix$WhenMappings;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J#\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0094\u0002J(\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)V", "doRemove", "", "mode", "Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$RemoveMode;", "element", "rhs", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getFamilyName", "", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "showDialog", "variable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Companion", "RemoveMode", "idea"})
public final class RemoveUnusedValueFix
extends KotlinQuickFixAction<KtBinaryExpression> {
    public static final Companion Companion = new Companion(null);

    private final void showDialog(KtProperty variable2, Project project2, KtBinaryExpression element3, KtExpression rhs) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            this.doRemove(RemoveMode.KEEP_INITIALIZE, element3, rhs);
            return;
        }
        String message2 = "<html><body>" + KotlinBundle.message("there.are.possible.side.effects.found.in.expressions.assigned.to.the.variable.0", String.valueOf(variable2.getName())) + "</body></html>";
        ApplicationManager.getApplication().invokeLater(new Runnable(this, variable2, message2, project2, element3, rhs){
            final /* synthetic */ RemoveUnusedValueFix this$0;
            final /* synthetic */ KtProperty $variable;
            final /* synthetic */ String $message;
            final /* synthetic */ Project $project;
            final /* synthetic */ KtBinaryExpression $element;
            final /* synthetic */ KtExpression $rhs;

            public final void run() {
                int exitCode = Messages.showYesNoCancelDialog((Project)this.$variable.getProject(), (String)this.$message, (String)QuickFixBundle.message((String)"side.effects.warning.dialog.title", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.remove", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.transform", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.cancel", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
                WriteCommandAction.runWriteCommandAction((Project)this.$project, (Runnable)new Runnable(this, exitCode){
                    final /* synthetic */ showDialog.1 this$0;
                    final /* synthetic */ int $exitCode;

                    public final void run() {
                        RemoveUnusedValueFix.access$doRemove(this.this$0.this$0, RemoveMode.values()[this.$exitCode], this.this$0.$element, this.this$0.$rhs);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$exitCode = n;
                    }
                });
            }
            {
                this.this$0 = removeUnusedValueFix;
                this.$variable = ktProperty;
                this.$message = string;
                this.$project = project2;
                this.$element = ktBinaryExpression;
                this.$rhs = ktExpression;
            }
        });
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("remove.redundant.assignment", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    private final void doRemove(RemoveMode mode, KtBinaryExpression element3, KtExpression rhs) {
        switch (RemoveUnusedValueFix$WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                element3.delete();
                break;
            }
            case 2: {
                element3.replace((PsiElement)rhs);
                break;
            }
        }
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        boolean isSideEffectFree;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)this.getElement();
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression element3 = ktBinaryExpression;
        KtExpression ktExpression = element3.getLeft();
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression lhs = ktSimpleNameExpression;
        KtExpression ktExpression2 = element3.getRight();
        if (ktExpression2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"element.right ?: return");
        KtExpression rhs = ktExpression2;
        PsiElement psiElement2 = ReferenceUtilKt.getMainReference(lhs).resolve();
        if (!(psiElement2 instanceof KtProperty)) {
            psiElement2 = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement2;
        if (ktProperty == null) {
            return;
        }
        KtProperty variable2 = ktProperty;
        Pseudocode pseudocode2 = PseudocodeUtilsKt.getContainingPseudocode(rhs, ResolutionUtils.analyze((KtElement)element3, (BodyResolveMode)BodyResolveMode.PARTIAL));
        Object object = pseudocode2;
        boolean bl = object != null && (object = object.getElementValue(rhs)) != null && (object = object.getCreatedAt()) != null ? PseudocodeUtilsKt.getSideEffectFree((Instruction)object) : (isSideEffectFree = false);
        if (!isSideEffectFree) {
            this.showDialog(variable2, project2, element3, rhs);
        } else {
            this.doRemove(RemoveMode.REMOVE_ALL, element3, rhs);
        }
    }

    public RemoveUnusedValueFix(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        super((PsiElement)expression2);
    }

    public static final /* synthetic */ void access$doRemove(RemoveUnusedValueFix $this, RemoveMode mode, KtBinaryExpression element3, KtExpression rhs) {
        $this.doRemove(mode, element3, rhs);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$RemoveMode;", "", "(Ljava/lang/String;I)V", "REMOVE_ALL", "KEEP_INITIALIZE", "CANCEL", "idea"})
    public static final class RemoveMode
    extends Enum<RemoveMode> {
        public static final /* enum */ RemoveMode REMOVE_ALL;
        public static final /* enum */ RemoveMode KEEP_INITIALIZE;
        public static final /* enum */ RemoveMode CANCEL;
        private static final /* synthetic */ RemoveMode[] $VALUES;

        static {
            RemoveMode[] removeModeArray = new RemoveMode[3];
            RemoveMode[] removeModeArray2 = removeModeArray;
            removeModeArray[0] = REMOVE_ALL = new RemoveMode();
            removeModeArray[1] = KEEP_INITIALIZE = new RemoveMode();
            removeModeArray[2] = CANCEL = new RemoveMode();
            $VALUES = removeModeArray;
        }

        public static RemoveMode[] values() {
            return (RemoveMode[])$VALUES.clone();
        }

        public static RemoveMode valueOf(String string) {
            return Enum.valueOf(RemoveMode.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.UNUSED_VALUE.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.UNUSED_VALUE.cast(diagnostic)");
            Object e = ((DiagnosticWithParameters2)d).getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"Errors.UNUSED_VALUE.cast(diagnostic).psiElement");
            KtBinaryExpression expression2 = (KtBinaryExpression)e;
            if (!KtPsiUtil.isAssignment((PsiElement)expression2)) {
                return null;
            }
            if (!(expression2.getLeft() instanceof KtSimpleNameExpression)) {
                return null;
            }
            return new RemoveUnusedValueFix(expression2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

