/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RestrictedRetentionForExpressionAnnotationFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "sourceRetention", "", "sourceRetentionAnnotation", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "findExpressionTargetArgument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "targetAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotation", "Lorg/jetbrains/kotlin/psi/KtClass;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "AddSourceRetentionFix", "ChangeRetentionToSourceFix", "RemoveExpressionTargetFix", "idea"})
public final class RestrictedRetentionForExpressionAnnotationFactory
extends KotlinIntentionActionsFactory {
    private static final String sourceRetention;
    private static final String sourceRetentionAnnotation;
    public static final RestrictedRetentionForExpressionAnnotationFactory INSTANCE;

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement2 = diagnostic.getPsiElement();
        if (!(psiElement2 instanceof KtAnnotationEntry)) {
            psiElement2 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)psiElement2;
        if (ktAnnotationEntry == null) {
            return CollectionsKt.emptyList();
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        KtClass ktClass2 = KtPsiUtilKt.containingClass(annotationEntry2);
        if (ktClass2 == null) {
            return CollectionsKt.emptyList();
        }
        KtClass containingClass2 = ktClass2;
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.retention;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.retention");
        KtAnnotationEntry retentionAnnotation = this.annotation(containingClass2, fqName2);
        FqName fqName3 = KotlinBuiltIns.FQ_NAMES.target;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"KotlinBuiltIns.FQ_NAMES.target");
        KtAnnotationEntry targetAnnotation = this.annotation(containingClass2, fqName3);
        KtValueArgument expressionTargetArgument = targetAnnotation != null ? this.findExpressionTargetArgument(targetAnnotation) : null;
        return CollectionsKt.listOfNotNull((Object[])new KotlinQuickFixAction[]{expressionTargetArgument != null ? new RemoveExpressionTargetFix(expressionTargetArgument) : null, retentionAnnotation == null ? (KotlinQuickFixAction)new AddSourceRetentionFix(containingClass2) : (KotlinQuickFixAction)new ChangeRetentionToSourceFix(retentionAnnotation)});
    }

    /*
     * Unable to fully structure code
     */
    private final KtAnnotationEntry annotation(@NotNull KtClass $this$annotation, FqName fqName) {
        block3: {
            v0 = $this$annotation.getAnnotationEntries();
            Intrinsics.checkExpressionValueIsNotNull(v0, (String)"annotationEntries");
            $this$firstOrNull$iv = v0;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (KtAnnotationEntry)element$iv;
                $i$a$-firstOrNull-RestrictedRetentionForExpressionAnnotationFactory$annotation$1 = false;
                v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                v2 = v1.getTypeReference();
                if (v2 == null || (v2 = v2.getText()) == null) ** GOTO lbl-1000
                v3 = fqName.shortName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"fqName.shortName().asString()");
                if (!StringsKt.endsWith$default((String)v2, (String)v3, (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v4 = (KotlinType)ResolutionUtils.analyze$default((KtElement)$this$annotation, null, (int)1, null).get(BindingContext.TYPE, it.getTypeReference());
                if (Intrinsics.areEqual(v4 != null && (v4 = v4.getConstructor()) != null && (v4 = v4.getDeclarationDescriptor()) != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)v4) : null, (Object)fqName)) {
                    v5 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v5 = false;
                }
                if (!v5) continue;
                v6 = element$iv;
                break block3;
            }
            v6 = null;
        }
        return v6;
    }

    private final KtValueArgument findExpressionTargetArgument(KtAnnotationEntry targetAnnotation) {
        KtValueArgumentList ktValueArgumentList = targetAnnotation.getValueArgumentList();
        if (ktValueArgumentList == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktValueArgumentList, (String)"targetAnnotation.valueArgumentList ?: return null");
        KtValueArgumentList valueArgumentList2 = ktValueArgumentList;
        List<KtLambdaArgument> list2 = targetAnnotation.getLambdaArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"targetAnnotation.lambdaArguments");
        Collection collection = list2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return null;
        }
        for (KtValueArgument valueArgument : valueArgumentList2.getArguments()) {
            KtExpression argumentExpression2;
            if (valueArgument.getArgumentExpression() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)argumentExpression2, (String)"valueArgument.getArgumentExpression() ?: continue");
            String string = argumentExpression2.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"argumentExpression.text");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)KotlinTarget.EXPRESSION.toString(), (boolean)false, (int)2, null)) continue;
            return valueArgument;
        }
        return null;
    }

    private RestrictedRetentionForExpressionAnnotationFactory() {
    }

    static {
        RestrictedRetentionForExpressionAnnotationFactory restrictedRetentionForExpressionAnnotationFactory;
        INSTANCE = restrictedRetentionForExpressionAnnotationFactory = new RestrictedRetentionForExpressionAnnotationFactory();
        sourceRetention = KotlinBuiltIns.FQ_NAMES.annotationRetention.asString() + '.' + AnnotationRetention.SOURCE.name();
        sourceRetentionAnnotation = '@' + KotlinBuiltIns.FQ_NAMES.retention.asString() + '(' + sourceRetention + ')';
    }

    public static final /* synthetic */ String access$getSourceRetentionAnnotation$p(RestrictedRetentionForExpressionAnnotationFactory $this) {
        RestrictedRetentionForExpressionAnnotationFactory restrictedRetentionForExpressionAnnotationFactory = $this;
        return sourceRetentionAnnotation;
    }

    public static final /* synthetic */ String access$getSourceRetention$p(RestrictedRetentionForExpressionAnnotationFactory $this) {
        RestrictedRetentionForExpressionAnnotationFactory restrictedRetentionForExpressionAnnotationFactory = $this;
        return sourceRetention;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RestrictedRetentionForExpressionAnnotationFactory$AddSourceRetentionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtClass;", "element", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
    private static final class AddSourceRetentionFix
    extends KotlinQuickFixAction<KtClass> {
        @NotNull
        public String getText() {
            return KotlinBundle.message("add.source.retention", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtClass ktClass2 = (KtClass)this.getElement();
            if (ktClass2 == null) {
                return;
            }
            KtClass element3 = ktClass2;
            KtAnnotationEntry ktAnnotationEntry = element3.addAnnotationEntry(KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null).createAnnotationEntry(RestrictedRetentionForExpressionAnnotationFactory.access$getSourceRetentionAnnotation$p(INSTANCE)));
            Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"element.addAnnotationEnt\u2026urceRetentionAnnotation))");
            KtAnnotationEntry added = ktAnnotationEntry;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, added, null, 2, null);
        }

        public AddSourceRetentionFix(@NotNull KtClass element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            super((PsiElement)element3);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RestrictedRetentionForExpressionAnnotationFactory$ChangeRetentionToSourceFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "retentionAnnotation", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
    private static final class ChangeRetentionToSourceFix
    extends KotlinQuickFixAction<KtAnnotationEntry> {
        @NotNull
        public String getText() {
            return KotlinBundle.message("change.existent.retention.to.source", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
            KtElementImplStub added;
            KtElementImplStub ktElementImplStub;
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry retentionAnnotation = ktAnnotationEntry;
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)retentionAnnotation, false, 2, null);
            if (retentionAnnotation.getValueArgumentList() == null) {
                PsiElement psiElement2 = retentionAnnotation.add((PsiElement)psiFactory.createCallArguments('(' + RestrictedRetentionForExpressionAnnotationFactory.access$getSourceRetention$p(INSTANCE) + ')'));
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValueArgumentList");
                }
                ktElementImplStub = (KtValueArgumentList)psiElement2;
            } else {
                List<? extends ValueArgument> list2 = retentionAnnotation.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"retentionAnnotation.valueArguments");
                Collection collection = list2;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    KtValueArgumentList ktValueArgumentList = retentionAnnotation.getValueArgumentList();
                    if (ktValueArgumentList != null) {
                        ktValueArgumentList.removeArgument(0);
                    }
                }
                KtValueArgumentList ktValueArgumentList = retentionAnnotation.getValueArgumentList();
                ktElementImplStub = added = (KtElementImplStub)(ktValueArgumentList != null ? ktValueArgumentList.addArgument(psiFactory.createArgument(RestrictedRetentionForExpressionAnnotationFactory.access$getSourceRetention$p(INSTANCE))) : null);
            }
            if (added != null) {
                ShortenReferences.process$default(ShortenReferences.DEFAULT, added, null, 2, null);
            }
        }

        public ChangeRetentionToSourceFix(@NotNull KtAnnotationEntry retentionAnnotation) {
            Intrinsics.checkParameterIsNotNull((Object)retentionAnnotation, (String)"retentionAnnotation");
            super((PsiElement)retentionAnnotation);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RestrictedRetentionForExpressionAnnotationFactory$RemoveExpressionTargetFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "expressionTargetArgument", "(Lorg/jetbrains/kotlin/psi/KtValueArgument;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
    private static final class RemoveExpressionTargetFix
    extends KotlinQuickFixAction<KtValueArgument> {
        @NotNull
        public String getText() {
            return KotlinBundle.message("remove.expression.target", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtValueArgument ktValueArgument = (KtValueArgument)this.getElement();
            if (ktValueArgument == null) {
                return;
            }
            KtValueArgument expressionTargetArgument = ktValueArgument;
            PsiElement psiElement2 = expressionTargetArgument.getParent();
            if (!(psiElement2 instanceof KtValueArgumentList)) {
                psiElement2 = null;
            }
            KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement2;
            if (ktValueArgumentList == null) {
                return;
            }
            KtValueArgumentList argumentList2 = ktValueArgumentList;
            if (argumentList2.getArguments().size() == 1) {
                PsiElement psiElement3 = argumentList2.getParent();
                if (!(psiElement3 instanceof KtAnnotationEntry)) {
                    psiElement3 = null;
                }
                KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)psiElement3;
                if (ktAnnotationEntry == null) {
                    return;
                }
                KtAnnotationEntry annotation2 = ktAnnotationEntry;
                annotation2.delete();
            } else {
                argumentList2.removeArgument(expressionTargetArgument);
            }
        }

        public RemoveExpressionTargetFix(@NotNull KtValueArgument expressionTargetArgument) {
            Intrinsics.checkParameterIsNotNull((Object)expressionTargetArgument, (String)"expressionTargetArgument");
            super((PsiElement)expressionTargetArgument);
        }
    }
}

