/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.createFromUsage.createCallable;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableInfoKt;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.FunctionInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.ParameterInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.TypeInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.createCallable.CreateCallableMemberFromUsageFactory;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/createCallable/CreateBinaryOperationActionFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/createCallable/CreateCallableMemberFromUsageFactory;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "createCallableInfo", "Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/callableBuilder/CallableInfo;", "element", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getElementOfInterest", "idea"})
public final class CreateBinaryOperationActionFactory
extends CreateCallableMemberFromUsageFactory<KtBinaryExpression> {
    public static final CreateBinaryOperationActionFactory INSTANCE;

    @Override
    @Nullable
    public KtBinaryExpression getElementOfInterest(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement2 = diagnostic.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
        PsiElement psiElement3 = psiElement2.getParent();
        if (!(psiElement3 instanceof KtBinaryExpression)) {
            psiElement3 = null;
        }
        return (KtBinaryExpression)psiElement3;
    }

    @Override
    @Nullable
    protected CallableInfo createCallableInfo(@NotNull KtBinaryExpression element3, @NotNull Diagnostic diagnostic) {
        TypeInfo typeInfo;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        IElementType iElementType = element3.getOperationToken();
        if (iElementType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtToken");
        }
        KtToken token = (KtToken)iElementType;
        KtToken ktToken = token;
        if (Intrinsics.areEqual((Object)((Object)ktToken), (Object)((Object)KtTokens.IDENTIFIER))) {
            string = element3.getOperationReference().getReferencedName();
        } else {
            Name name2 = OperatorConventions.getNameForOperationSymbol(token, false, true);
            string = name2 != null ? name2.asString() : null;
        }
        if (string == null) {
            return null;
        }
        String operationName = string;
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.IN_OPERATIONS;
        Intrinsics.checkExpressionValueIsNotNull(immutableSet, (String)"OperatorConventions.IN_OPERATIONS");
        boolean inOperation = CollectionsKt.contains((Iterable)((Iterable)immutableSet), (Object)((Object)token));
        ImmutableSet<KtSingleValueToken> immutableSet2 = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkExpressionValueIsNotNull(immutableSet2, (String)"OperatorConventions.COMPARISON_OPERATIONS");
        boolean comparisonOperation = CollectionsKt.contains((Iterable)((Iterable)immutableSet2), (Object)((Object)token));
        KtExpression ktExpression = element3.getLeft();
        if (ktExpression == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.left ?: return null");
        KtExpression leftExpr = ktExpression;
        KtExpression ktExpression2 = element3.getRight();
        if (ktExpression2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"element.right ?: return null");
        KtExpression rightExpr = ktExpression2;
        KtExpression receiverExpr = inOperation ? rightExpr : leftExpr;
        KtExpression argumentExpr = inOperation ? leftExpr : rightExpr;
        KotlinBuiltIns builtIns = PlatformKt.getBuiltIns(element3);
        TypeInfo receiverType2 = CallableInfoKt.TypeInfo(receiverExpr, Variance.IN_VARIANCE);
        if (inOperation) {
            SimpleType simpleType2 = builtIns.getBooleanType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.booleanType");
            typeInfo = CallableInfoKt.noSubstitutions(new TypeInfo.ByType(simpleType2, Variance.INVARIANT));
        } else if (comparisonOperation) {
            SimpleType simpleType3 = builtIns.getIntType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"builtIns.intType");
            typeInfo = CallableInfoKt.noSubstitutions(new TypeInfo.ByType(simpleType3, Variance.INVARIANT));
        } else {
            typeInfo = CallableInfoKt.TypeInfo(element3, Variance.OUT_VARIANCE);
        }
        TypeInfo returnType2 = typeInfo;
        List<ParameterInfo> parameters2 = Collections.singletonList(new ParameterInfo(CallableInfoKt.TypeInfo(argumentExpr, Variance.IN_VARIANCE), null, 2, null));
        boolean isOperator = Intrinsics.areEqual((Object)((Object)token), (Object)((Object)KtTokens.IDENTIFIER)) ^ true;
        List<ParameterInfo> list2 = parameters2;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parameters");
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        KtModifierKeywordToken ktModifierKeywordToken = isOperator ? KtTokens.OPERATOR_KEYWORD : KtTokens.INFIX_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"if (isOperator) KtTokens\u2026se KtTokens.INFIX_KEYWORD");
        return new FunctionInfo(operationName, receiverType2, returnType2, null, list2, null, false, ktPsiFactory.createModifierList(ktModifierKeywordToken), false, 360, null);
    }

    private CreateBinaryOperationActionFactory() {
        super(false, 1, null);
    }

    static {
        CreateBinaryOperationActionFactory createBinaryOperationActionFactory;
        INSTANCE = createBinaryOperationActionFactory = new CreateBinaryOperationActionFactory();
    }
}

