/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureHandler;", "Lcom/intellij/refactoring/changeSignature/ChangeSignatureHandler;", "()V", "findTargetMember", "Lcom/intellij/psi/PsiElement;", "element", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getTargetNotFoundMessage", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "Companion", "idea"})
public final class KotlinChangeSignatureHandler
implements ChangeSignatureHandler {
    public static final Companion Companion = new Companion(null);

    @Nullable
    public PsiElement findTargetMember(@NotNull PsiFile file2, @NotNull Editor editor2) {
        PsiElement psiElement2;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        PsiElement psiElement3 = file2.findElementAt(caretModel.getOffset());
        if (psiElement3 != null) {
            PsiElement psiElement4 = psiElement3;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement it = psiElement4;
            boolean bl3 = false;
            PsiElement psiElement5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"it");
            psiElement2 = this.findTargetMember(psiElement5);
        } else {
            psiElement2 = null;
        }
        return psiElement2;
    }

    @Nullable
    public PsiElement findTargetMember(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return Companion.findTargetForRefactoring(element3);
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement psiElement2 = this.findTargetMember(file2, editor2);
        if (psiElement2 == null) {
            psiElement2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        if (psiElement2 == null) {
            return;
        }
        PsiElement element3 = psiElement2;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        PsiElement psiElement3 = file2.findElementAt(caretModel.getOffset());
        if (psiElement3 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"file.findElementAt(edito\u2026etModel.offset) ?: return");
        PsiElement elementAtCaret = psiElement3;
        if (!(element3 instanceof KtElement)) {
            throw (Throwable)((Object)new AssertionError((Object)("This handler must be invoked for Kotlin elements only: " + element3.getText())));
        }
        Companion.invokeChangeSignature((KtElement)element3, elementAtCaret, project2, editor2);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        Editor editor2;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)elements2, (String)"elements");
        PsiElement psiElement2 = (PsiElement)ArraysKt.singleOrNull((Object[])elements2);
        if (psiElement2 == null || (psiElement2 = LightClassUtilsKt.getUnwrapped(psiElement2)) == null) {
            return;
        }
        PsiElement element3 = psiElement2;
        if (!(element3 instanceof KtElement)) {
            throw (Throwable)((Object)new AssertionError((Object)("This handler must be invoked for Kotlin elements only: " + element3.getText())));
        }
        DataContext dataContext2 = dataContext;
        if (dataContext2 != null) {
            DataContext dataContext3 = dataContext2;
            boolean bl = false;
            boolean bl2 = false;
            DataContext it = dataContext3;
            boolean bl3 = false;
            editor2 = (Editor)CommonDataKeys.EDITOR.getData(it);
        } else {
            editor2 = null;
        }
        Editor editor3 = editor2;
        Companion.invokeChangeSignature((KtElement)element3, element3, project2, editor3);
    }

    @NotNull
    public String getTargetNotFoundMessage() {
        return KotlinBundle.message("error.wrong.caret.position.function.or.constructor.name", new Object[0]);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureHandler$Companion;", "", "()V", "findDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findTargetForRefactoring", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "invokeChangeSignature", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "context", "idea"})
    public static final class Companion {
        @Nullable
        public final PsiElement findTargetForRefactoring(@NotNull PsiElement element3) {
            KtElement calleeExpr;
            block14: {
                KtElement ktElement;
                block13: {
                    KtExpression ktExpression;
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    PsiElement elementParent = element3.getParent();
                    if ((elementParent instanceof KtNamedFunction || elementParent instanceof KtClass || elementParent instanceof KtProperty) && ((KtNamedDeclaration)elementParent).getNameIdentifier() == element3) {
                        return elementParent;
                    }
                    if (elementParent instanceof KtParameter) {
                        KtPrimaryConstructor primaryConstructor2 = (KtPrimaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)elementParent, KtPrimaryConstructor.class);
                        if (((KtParameter)elementParent).hasValOrVar() && (((KtParameter)elementParent).getNameIdentifier() == element3 || ((KtParameter)elementParent).getValOrVarKeyword() == element3) && primaryConstructor2 != null && primaryConstructor2.getValueParameterList() == ((KtParameter)elementParent).getParent()) {
                            return elementParent;
                        }
                    }
                    if (elementParent instanceof KtSecondaryConstructor && ((KtSecondaryConstructor)elementParent).getConstructorKeyword() == element3) {
                        return elementParent;
                    }
                    Object $this$getStrictParentOfType$iv = element3;
                    boolean $i$f$getStrictParentOfType = false;
                    KtParameterList ktParameterList = (KtParameterList)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtParameterList.class, (boolean)true);
                    if (ktParameterList != null) {
                        $this$getStrictParentOfType$iv = ktParameterList;
                        $i$f$getStrictParentOfType = false;
                        boolean bl = false;
                        Object parameterList2 = $this$getStrictParentOfType$iv;
                        boolean bl2 = false;
                        return PsiTreeUtil.getParentOfType((PsiElement)parameterList2, (Class[])new Class[]{KtFunction.class, KtProperty.class, KtClass.class});
                    }
                    $this$getStrictParentOfType$iv = element3;
                    $i$f$getStrictParentOfType = false;
                    KtTypeParameterList ktTypeParameterList = (KtTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeParameterList.class, (boolean)true);
                    if (ktTypeParameterList != null) {
                        $this$getStrictParentOfType$iv = ktTypeParameterList;
                        $i$f$getStrictParentOfType = false;
                        boolean bl = false;
                        Object typeParameterList = $this$getStrictParentOfType$iv;
                        boolean bl3 = false;
                        return PsiTreeUtil.getParentOfType((PsiElement)typeParameterList, (Class[])new Class[]{KtFunction.class, KtProperty.class, KtClass.class});
                    }
                    KtCallElement call2 = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)element3, (Class[])new Class[]{KtCallExpression.class, KtSuperTypeCallEntry.class, KtConstructorDelegationCall.class});
                    ktElement = call2;
                    if (ktElement == null) break block13;
                    KtCallElement ktCallElement = ktElement;
                    boolean typeParameterList = false;
                    boolean bl3 = false;
                    KtCallElement it = ktCallElement;
                    boolean bl = false;
                    KtExpression callee2 = it.getCalleeExpression();
                    KtExpression ktExpression2 = callee2;
                    if (!(ktExpression2 instanceof KtConstructorCalleeExpression)) {
                        ktExpression2 = null;
                    }
                    KtExpression ktExpression3 = (ktExpression = (KtConstructorCalleeExpression)ktExpression2) != null && (ktExpression = ktExpression.getConstructorReferenceExpression()) != null ? (KtExpression)ktExpression : callee2;
                    ktElement = ktExpression3;
                    if (ktExpression3 != null) break block14;
                }
                PsiElement $this$getStrictParentOfType$iv = element3;
                boolean $i$f$getStrictParentOfType = false;
                ktElement = calleeExpr = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtSimpleNameExpression.class, (boolean)true);
            }
            if (calleeExpr instanceof KtSimpleNameExpression || calleeExpr instanceof KtConstructorDelegationReferenceExpression) {
                PsiElement $this$getStrictParentOfType$iv = element3;
                boolean $i$f$getStrictParentOfType = false;
                KtElement ktElement = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtElement.class, (boolean)true);
                if (ktElement == null) {
                    return null;
                }
                KtElement jetElement = ktElement;
                BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)jetElement, (BodyResolveMode)BodyResolveMode.FULL);
                DeclarationDescriptor descriptor2 = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, (KtReferenceExpression)calleeExpr);
                if (descriptor2 instanceof ClassDescriptor || descriptor2 instanceof CallableDescriptor) {
                    return (PsiElement)calleeExpr;
                }
            }
            return null;
        }

        public final void invokeChangeSignature(@NotNull KtElement element3, @NotNull PsiElement context2, @NotNull Project project2, @Nullable Editor editor2) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)element3, (BodyResolveMode)BodyResolveMode.FULL);
            CallableDescriptor callableDescriptor = this.findDescriptor((PsiElement)element3, project2, editor2, bindingContext2);
            if (callableDescriptor == null) {
                return;
            }
            CallableDescriptor callableDescriptor2 = callableDescriptor;
            if (callableDescriptor2 instanceof JavaCallableMemberDescriptor) {
                PsiElement declaration2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, callableDescriptor2);
                if (declaration2 instanceof PsiClass) {
                    String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name"));
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)ChangeSignatureHandler.REFACTORING_NAME, (String)"refactoring.changeSignature");
                    return;
                }
                boolean bl = declaration2 instanceof PsiMethod;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "PsiMethod expected: " + callableDescriptor2;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                PsiElement psiElement2 = declaration2;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                }
                ChangeSignatureUtil.invokeChangeSignatureOn((PsiMethod)((PsiMethod)psiElement2), (Project)project2);
                return;
            }
            if (DynamicCallsKt.isDynamic(callableDescriptor2)) {
                if (editor2 != null) {
                    CodeInsightUtils.showErrorHint(project2, editor2, KotlinBundle.message("message.change.signature.is.not.applicable.to.dynamically.invoked.functions", new Object[0]), RefactoringBundle.message((String)"changeSignature.refactoring.name"), null);
                }
                return;
            }
            KotlinChangeSignatureKt.runChangeSignature(project2, callableDescriptor2, KotlinChangeSignatureConfiguration.Empty.INSTANCE, context2, null);
        }

        private final DeclarationDescriptor getDescriptor(BindingContext bindingContext2, PsiElement element3) {
            PsiElement psiElement2 = element3;
            DeclarationDescriptor descriptor2 = psiElement2 instanceof KtReferenceExpression ? (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, element3) : bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element3);
            return descriptor2 instanceof ClassDescriptor ? (DeclarationDescriptor)((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() : descriptor2;
        }

        @Nullable
        public final CallableDescriptor findDescriptor(@NotNull PsiElement element3, @NotNull Project project2, @Nullable Editor editor2, @NotNull BindingContext bindingContext2) {
            CallableDescriptor callableDescriptor;
            DeclarationDescriptor declarationDescriptor;
            DeclarationDescriptor declarationDescriptor2;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)element3)) {
                return null;
            }
            DeclarationDescriptor descriptor2 = this.getDescriptor(bindingContext2, element3);
            if (descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isActual() && (declarationDescriptor2 = ExpectActualUtilKt.expectedDescriptor((MemberDescriptor)descriptor2)) == null) {
                declarationDescriptor2 = descriptor2 = descriptor2;
            }
            if ((declarationDescriptor = descriptor2) instanceof FunctionDescriptor) {
                String message2;
                boolean bl;
                block12: {
                    List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)descriptor2).getValueParameters();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                            boolean bl2 = false;
                            if (!(it.getVarargElementType() != null)) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    message2 = KotlinBundle.message("error.cant.refactor.vararg.functions", new Object[0]);
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)ChangeSignatureHandler.REFACTORING_NAME, (String)"refactoring.changeSignature");
                    return null;
                }
                if (((FunctionDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
                    Object[] objectArray = new Object[1];
                    Name name2 = ((FunctionDescriptor)descriptor2).getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"descriptor.name");
                    objectArray[0] = name2;
                    message2 = KotlinBundle.message("cannot.refactor.synthesized.function", objectArray);
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)ChangeSignatureHandler.REFACTORING_NAME, (String)"refactoring.changeSignature");
                    return null;
                }
                callableDescriptor = (CallableDescriptor)descriptor2;
            } else if (declarationDescriptor instanceof PropertyDescriptor || declarationDescriptor instanceof ValueParameterDescriptor) {
                DeclarationDescriptor declarationDescriptor3 = descriptor2;
                if (declarationDescriptor3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
                }
                callableDescriptor = (CallableDescriptor)declarationDescriptor3;
            } else {
                String message3 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message("error.wrong.caret.position.function.or.constructor.name", new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message3, (String)ChangeSignatureHandler.REFACTORING_NAME, (String)"refactoring.changeSignature");
                callableDescriptor = null;
            }
            return callableDescriptor;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

