/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVar;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinCallableParameterTableModel;

public class KotlinPrimaryConstructorParameterTableModel
extends KotlinCallableParameterTableModel {
    public KotlinPrimaryConstructorParameterTableModel(KotlinMethodDescriptor methodDescriptor, PsiElement typeContext, PsiElement defaultValueContext) {
        super(methodDescriptor, typeContext, defaultValueContext, new ColumnInfo[]{new ValVarColumn(), new ParameterTableModelBase.NameColumn(typeContext.getProject()), new ParameterTableModelBase.TypeColumn(typeContext.getProject(), (FileType)KotlinFileType.INSTANCE), new ParameterTableModelBase.DefaultValueColumn(typeContext.getProject(), (FileType)KotlinFileType.INSTANCE)});
    }

    public static boolean isValVarColumn(ColumnInfo column) {
        return column instanceof ValVarColumn;
    }

    protected static class ValVarColumn
    extends ParameterTableModelBase.ColumnInfoBase<KotlinParameterInfo, ParameterTableModelItemBase<KotlinParameterInfo>, KotlinValVar> {
        public ValVarColumn() {
            super(KotlinBundle.message("column.name.val.var", new Object[0]));
        }

        public boolean isCellEditable(ParameterTableModelItemBase<KotlinParameterInfo> item) {
            return !item.isEllipsisType() && ((KotlinParameterInfo)item.parameter).isNewParameter();
        }

        public KotlinValVar valueOf(ParameterTableModelItemBase<KotlinParameterInfo> item) {
            return ((KotlinParameterInfo)item.parameter).getValOrVar();
        }

        public void setValue(ParameterTableModelItemBase<KotlinParameterInfo> item, KotlinValVar value2) {
            ((KotlinParameterInfo)item.parameter).setValOrVar(value2);
        }

        public TableCellRenderer doCreateRenderer(ParameterTableModelItemBase<KotlinParameterInfo> item) {
            return new ComboBoxTableRenderer((Object[])KotlinValVar.values());
        }

        public TableCellEditor doCreateEditor(ParameterTableModelItemBase<KotlinParameterInfo> item) {
            return new DefaultCellEditor(new JComboBox());
        }

        public int getWidth(JTable table) {
            return table.getFontMetrics(table.getFont()).stringWidth(this.getName()) + 8;
        }
    }
}

