/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.util.IncorrectOperationException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinAwareMoveFilesOrDirectoriesProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.KotlinAwareMoveFilesOrDirectoriesModel;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u0002H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u000bH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/KotlinAwareMoveFilesOrDirectoriesModel;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/Model;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/KotlinAwareMoveFilesOrDirectoriesProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "elementsToMove", "", "Lcom/intellij/psi/PsiElement;", "targetDirectoryName", "", "updatePackageDirective", "", "searchReferences", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;ZZLcom/intellij/refactoring/move/MoveCallback;)V", "getElementsToMove", "()Ljava/util/List;", "getMoveCallback", "()Lcom/intellij/refactoring/move/MoveCallback;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSearchReferences", "()Z", "getTargetDirectoryName", "()Ljava/lang/String;", "getUpdatePackageDirective", "checkModel", "", "checkedGetElementsToMove", "selectedDirectory", "Lcom/intellij/psi/PsiDirectory;", "checkedGetTargetDirectory", "computeModelResult", "throwOnConflicts", "idea"})
public final class KotlinAwareMoveFilesOrDirectoriesModel
implements Model<KotlinAwareMoveFilesOrDirectoriesProcessor> {
    @NotNull
    private final Project project;
    @NotNull
    private final List<PsiElement> elementsToMove;
    @NotNull
    private final String targetDirectoryName;
    private final boolean updatePackageDirective;
    private final boolean searchReferences;
    @Nullable
    private final MoveCallback moveCallback;

    /*
     * WARNING - void declaration
     */
    private final List<PsiElement> checkedGetElementsToMove(PsiDirectory selectedDirectory) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.elementsToMove;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (it instanceof PsiFile && Intrinsics.areEqual((Object)((PsiFile)it).getContainingDirectory(), (Object)selectedDirectory)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List preparedElementsToMove2 = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)checkedGetElementsToMove.preparedElementsToMove.2.INSTANCE);
        try {
            Iterable $this$forEach$iv = preparedElementsToMove2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                MoveFilesOrDirectoriesUtil.checkMove((PsiElement)it, (PsiElement)((PsiElement)selectedDirectory));
                if (!(it instanceof KtFile) || !KotlinRefactoringUtilKt.isInKotlinAwareSourceRoot(it)) continue;
                MoveUtilsKt.setUpdatePackageDirective((KtFile)it, this.updatePackageDirective);
            }
        }
        catch (IncorrectOperationException e) {
            throw (Throwable)new ConfigurationException(e.getMessage());
        }
        return preparedElementsToMove2;
    }

    private final PsiDirectory checkedGetTargetDirectory() {
        try {
            return MoveUtilsKt.getOrCreateDirectory(this.targetDirectoryName, this.project);
        }
        catch (IncorrectOperationException e) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.cannot.create.target.directory.0", this.targetDirectoryName));
        }
    }

    @Override
    @NotNull
    public KotlinAwareMoveFilesOrDirectoriesProcessor computeModelResult() throws ConfigurationException {
        return this.computeModelResult(false);
    }

    private final void checkModel() {
        Object v0;
        Iterable $this$firstOrNull$iv;
        block6: {
            $this$firstOrNull$iv = this.elementsToMove;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!(it instanceof PsiFile) && !(it instanceof PsiDirectory))) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        PsiElement psiElement2 = v0;
        if (psiElement2 != null) {
            $this$firstOrNull$iv = psiElement2;
            boolean bl = false;
            boolean bl2 = false;
            Iterable it = $this$firstOrNull$iv;
            boolean bl3 = false;
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.unexpected.element.type.0", it));
        }
        if (this.elementsToMove.isEmpty()) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.no.files.to.move", new Object[0]));
        }
        try {
            Paths.get(this.targetDirectoryName, new String[0]);
        }
        catch (InvalidPathException e) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.invalid.target.path.0", this.targetDirectoryName));
        }
        if (DumbService.isDumb((Project)this.project)) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.move.refactoring.not.available.during.indexing", new Object[0]));
        }
    }

    @Override
    @NotNull
    public KotlinAwareMoveFilesOrDirectoriesProcessor computeModelResult(boolean throwOnConflicts) throws ConfigurationException {
        this.checkModel();
        PsiDirectory selectedDir = this.checkedGetTargetDirectory();
        return new KotlinAwareMoveFilesOrDirectoriesProcessor(this.project, this.checkedGetElementsToMove(selectedDir), selectedDir, this.searchReferences, false, false, this.moveCallback, null, false, 384, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<PsiElement> getElementsToMove() {
        return this.elementsToMove;
    }

    @NotNull
    public final String getTargetDirectoryName() {
        return this.targetDirectoryName;
    }

    public final boolean getUpdatePackageDirective() {
        return this.updatePackageDirective;
    }

    public final boolean getSearchReferences() {
        return this.searchReferences;
    }

    @Nullable
    public final MoveCallback getMoveCallback() {
        return this.moveCallback;
    }

    public KotlinAwareMoveFilesOrDirectoriesModel(@NotNull Project project2, @NotNull List<? extends PsiElement> elementsToMove, @NotNull String targetDirectoryName, boolean updatePackageDirective, boolean searchReferences2, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(elementsToMove, (String)"elementsToMove");
        Intrinsics.checkParameterIsNotNull((Object)targetDirectoryName, (String)"targetDirectoryName");
        this.project = project2;
        this.elementsToMove = elementsToMove;
        this.targetDirectoryName = targetDirectoryName;
        this.updatePackageDirective = updatePackageDirective;
        this.searchReferences = searchReferences2;
        this.moveCallback = moveCallback;
    }
}

