/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.DirectoryChooser;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionPanel;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionTable;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinTopLevelDeclarationsModel;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinDestinationFolderComboBox;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinFileChooserDialog;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class MoveKotlinTopLevelDeclarationsDialog
extends RefactoringDialog {
    private static final String RECENTS_KEY = "MoveKotlinTopLevelDeclarationsDialog.RECENTS_KEY";
    private final MoveCallback moveCallback;
    private final PsiDirectory initialTargetDirectory;
    private JCheckBox cbSearchInComments;
    private JCheckBox cbSearchTextOccurrences;
    private JPanel mainPanel;
    private ReferenceEditorComboWithBrowseButton classPackageChooser;
    private ComboboxWithBrowseButton destinationFolderCB;
    private JPanel targetPanel;
    private JRadioButton rbMoveToPackage;
    private JRadioButton rbMoveToFile;
    private TextFieldWithBrowseButton fileChooser;
    private JPanel memberInfoPanel;
    private JTextField tfFileNameInPackage;
    private JCheckBox cbSpecifyFileNameInPackage;
    private JCheckBox cbUpdatePackageDirective;
    private JCheckBox cbDeleteEmptySourceFiles;
    private JCheckBox cbSearchReferences;
    private KotlinMemberSelectionTable memberTable;

    public MoveKotlinTopLevelDeclarationsDialog(@NotNull Project project2, @NotNull Set<KtNamedDeclaration> elementsToMove, @Nullable String targetPackageName, @Nullable PsiDirectory targetDirectory2, @Nullable KtFile targetFile2, boolean moveToPackage, boolean searchInComments, boolean searchForTextOccurrences, boolean deleteEmptySourceFiles, @Nullable MoveCallback moveCallback) {
        if (project2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(0);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(1);
        }
        if (project2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(0);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(1);
        }
        if (project2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(0);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(1);
        }
        if (project2 == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(0);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(1);
        }
        super(project2, true);
        this.$$$setupUI$$$();
        List<KtFile> sourceFiles = MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(elementsToMove);
        this.moveCallback = moveCallback;
        this.initialTargetDirectory = targetDirectory2;
        this.init();
        this.setTitle("Move");
        this.initSearchOptions(searchInComments, searchForTextOccurrences, deleteEmptySourceFiles);
        this.initPackageChooser(targetPackageName, targetDirectory2, sourceFiles);
        this.initFileChooser(targetFile2, elementsToMove, sourceFiles);
        this.initMoveToButtons(moveToPackage);
        this.initMemberInfo(elementsToMove, sourceFiles);
        this.updateControls();
    }

    private static List<KtFile> getSourceFiles(@NotNull Collection<KtNamedDeclaration> elementsToMove) {
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(2);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(2);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(2);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(2);
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.map(elementsToMove, KtPureElement::getContainingKtFile));
    }

    private static List<KtNamedDeclaration> getAllDeclarations(Collection<KtFile> sourceFiles) {
        return CollectionsKt.filterIsInstance((Iterable)CollectionsKt.flatMap(sourceFiles, KtPsiUtilKt::getFileOrScriptDeclarations), KtNamedDeclaration.class);
    }

    private static boolean arePackagesAndDirectoryMatched(List<KtFile> sourceFiles) {
        for (KtFile sourceFile : sourceFiles) {
            if (PackageUtilsKt.packageMatchesDirectoryOrImplicit(sourceFile)) continue;
            return false;
        }
        return true;
    }

    private void initMemberInfo(@NotNull Set<KtNamedDeclaration> elementsToMove, @NotNull List<KtFile> sourceFiles) {
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(3);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(4);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(3);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(4);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(3);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(4);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(3);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(4);
        }
        List memberInfos = CollectionsKt.map(MoveKotlinTopLevelDeclarationsDialog.getAllDeclarations(sourceFiles), declaration2 -> {
            KotlinMemberInfo memberInfo = new KotlinMemberInfo((KtNamedDeclaration)declaration2, false);
            memberInfo.setChecked(elementsToMove.contains(declaration2));
            return memberInfo;
        });
        KotlinMemberSelectionPanel selectionPanel = new KotlinMemberSelectionPanel(this.getTitle(), memberInfos, null);
        this.memberTable = selectionPanel.getTable();
        MemberInfoModelImpl memberInfoModel = new MemberInfoModelImpl();
        memberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)memberInfos));
        selectionPanel.getTable().setMemberInfoModel((MemberInfoModel)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener(new MemberSelectionerInfoChangeListener(memberInfos));
        this.memberInfoPanel.add((Component)((Object)selectionPanel), "Center");
    }

    private void updateSuggestedFileName() {
        this.tfFileNameInPackage.setText(MoveUtilsKt.guessNewFileName(this.getSelectedElementsToMove()));
    }

    private void updateFileNameInPackageField() {
        boolean movingSingleFileToPackage = this.rbMoveToPackage.isSelected() && MoveKotlinTopLevelDeclarationsDialog.getSourceFiles(this.getSelectedElementsToMove()).size() == 1;
        this.cbSpecifyFileNameInPackage.setEnabled(movingSingleFileToPackage);
        this.tfFileNameInPackage.setEnabled(movingSingleFileToPackage && this.cbSpecifyFileNameInPackage.isSelected());
    }

    private void initPackageChooser(String targetPackageName, PsiDirectory targetDirectory2, List<KtFile> sourceFiles) {
        if (targetPackageName != null) {
            this.classPackageChooser.prependItem(targetPackageName);
        }
        ((KotlinDestinationFolderComboBox)this.destinationFolderCB).setData(this.myProject, targetDirectory2, new Pass<String>(){

            public void pass(String s) {
                MoveKotlinTopLevelDeclarationsDialog.this.setErrorText(s);
            }
        }, (EditorComboBox)this.classPackageChooser.getChildComponent());
        this.cbSpecifyFileNameInPackage.addActionListener(e -> this.updateFileNameInPackageField());
        this.cbUpdatePackageDirective.setSelected(MoveKotlinTopLevelDeclarationsDialog.arePackagesAndDirectoryMatched(sourceFiles));
    }

    private void initSearchOptions(boolean searchInComments, boolean searchForTextOccurences, boolean deleteEmptySourceFiles) {
        this.cbSearchInComments.setSelected(searchInComments);
        this.cbSearchTextOccurrences.setSelected(searchForTextOccurences);
        this.cbDeleteEmptySourceFiles.setSelected(deleteEmptySourceFiles);
    }

    private void initMoveToButtons(boolean moveToPackage) {
        if (moveToPackage) {
            this.rbMoveToPackage.setSelected(true);
        } else {
            this.rbMoveToFile.setSelected(true);
        }
        this.rbMoveToPackage.addActionListener(e -> {
            this.classPackageChooser.requestFocus();
            this.updateControls();
        });
        this.rbMoveToFile.addActionListener(e -> {
            this.fileChooser.requestFocus();
            this.updateControls();
        });
    }

    private void initFileChooser(@Nullable KtFile targetFile2, @NotNull Set<KtNamedDeclaration> elementsToMove, @NotNull List<KtFile> sourceFiles) {
        PsiDirectory sourceDir;
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(5);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$3(6);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(5);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$2(6);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(5);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$1(6);
        }
        if (elementsToMove == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(5);
        }
        if (sourceFiles == null) {
            MoveKotlinTopLevelDeclarationsDialog.$$$reportNull$$$0(6);
        }
        if ((sourceDir = sourceFiles.get(0).getParent()) == null) {
            throw new AssertionError((Object)"File chooser initialization failed");
        }
        this.fileChooser.addActionListener(e -> {
            KtFile selectedFile;
            KotlinFileChooserDialog dialog2 = new KotlinFileChooserDialog(KotlinBundle.message("text.choose.containing.file", new Object[0]), this.myProject);
            File targetFile1 = new File(this.fileChooser.getText());
            PsiFile targetPsiFile = PhysicalFileSystemUtilsKt.toPsiFile(targetFile1, this.myProject);
            if (targetPsiFile instanceof KtFile) {
                dialog2.select((KtFile)targetPsiFile);
            } else {
                PsiDirectory targetDir = PhysicalFileSystemUtilsKt.toPsiDirectory(targetFile1.getParentFile(), this.myProject);
                if (targetDir == null) {
                    targetDir = sourceDir;
                }
                dialog2.selectDirectory(targetDir);
            }
            dialog2.showDialog();
            KtFile ktFile = selectedFile = dialog2.isOK() ? (KtFile)dialog2.getSelected() : null;
            if (selectedFile != null) {
                this.fileChooser.setText(selectedFile.getVirtualFile().getPath());
            }
        });
        String initialTargetPath = targetFile2 != null ? targetFile2.getVirtualFile().getPath() : sourceFiles.get(0).getVirtualFile().getParent().getPath() + "/" + MoveUtilsKt.guessNewFileName(elementsToMove);
        this.fileChooser.setText(initialTargetPath);
    }

    private void createUIComponents() {
        this.classPackageChooser = this.createPackageChooser();
        this.destinationFolderCB = new KotlinDestinationFolderComboBox(){

            @Override
            public String getTargetPackage() {
                return MoveKotlinTopLevelDeclarationsDialog.this.getTargetPackage();
            }
        };
    }

    private ReferenceEditorComboWithBrowseButton createPackageChooser() {
        return new PackageNameReferenceEditorCombo("", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
    }

    private void updateControls() {
        boolean moveToPackage = this.rbMoveToPackage.isSelected();
        this.classPackageChooser.setEnabled(moveToPackage);
        this.updateFileNameInPackageField();
        this.fileChooser.setEnabled(!moveToPackage);
        this.updatePackageDirectiveCheckBox();
        UIUtil.setEnabled((Component)this.targetPanel, (moveToPackage && this.hasAnySourceRoots() ? 1 : 0) != 0, (boolean)true);
        this.updateSuggestedFileName();
        this.myHelpAction.setEnabled(false);
    }

    private boolean isFullFileMove() {
        Map fileToElements = CollectionsKt.groupBy(this.getSelectedElementsToMove(), KtPureElement::getContainingKtFile);
        for (Map.Entry entry : fileToElements.entrySet()) {
            if (KtPsiUtilKt.getFileOrScriptDeclarations((KtFile)entry.getKey()).size() == ((List)entry.getValue()).size()) continue;
            return false;
        }
        return true;
    }

    private void updatePackageDirectiveCheckBox() {
        this.cbUpdatePackageDirective.setEnabled(this.rbMoveToPackage.isSelected() && this.isFullFileMove());
    }

    private boolean hasAnySourceRoots() {
        return !ProjectRootUtilsKt.getSuitableDestinationSourceRoots(this.myProject).isEmpty();
    }

    private void saveRefactoringSettings() {
        KotlinRefactoringSettings refactoringSettings = KotlinRefactoringSettings.getInstance();
        refactoringSettings.MOVE_SEARCH_IN_COMMENTS = this.cbSearchInComments.isSelected();
        refactoringSettings.MOVE_SEARCH_FOR_TEXT = this.cbSearchTextOccurrences.isSelected();
        refactoringSettings.MOVE_DELETE_EMPTY_SOURCE_FILES = this.cbDeleteEmptySourceFiles.isSelected();
        refactoringSettings.MOVE_PREVIEW_USAGES = this.isPreviewUsages();
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, this.getTargetPackage());
    }

    private List<KtNamedDeclaration> getSelectedElementsToMove() {
        return CollectionsKt.map((Iterable)this.memberTable.getSelectedMemberInfos(), MemberInfoBase::getMember);
    }

    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    protected String getDimensionServiceKey() {
        return "#" + ((Object)((Object)this)).getClass().getName();
    }

    private String getTargetPackage() {
        return this.classPackageChooser.getText().trim();
    }

    private List<KtNamedDeclaration> getSelectedElementsToMoveChecked() throws ConfigurationException {
        List<KtNamedDeclaration> elementsToMove = this.getSelectedElementsToMove();
        if (elementsToMove.isEmpty()) {
            throw new ConfigurationException(KotlinBundle.message("text.no.elements.to.move.are.selected", new Object[0]));
        }
        return elementsToMove;
    }

    private Model<BaseRefactoringProcessor> getModel() throws ConfigurationException {
        DirectoryChooser.ItemWrapper selectedItem = (DirectoryChooser.ItemWrapper)this.destinationFolderCB.getComboBox().getSelectedItem();
        PsiDirectory selectedPsiDirectory = selectedItem != null ? selectedItem.getDirectory() : this.initialTargetDirectory;
        return new MoveKotlinTopLevelDeclarationsModel(this.myProject, this.getSelectedElementsToMoveChecked(), this.getTargetPackage(), selectedPsiDirectory, this.tfFileNameInPackage.getText(), this.fileChooser.getText(), this.rbMoveToPackage.isSelected(), this.cbSearchReferences.isSelected(), this.cbSearchInComments.isSelected(), this.cbSearchTextOccurrences.isSelected(), this.cbDeleteEmptySourceFiles.isSelected(), this.cbUpdatePackageDirective.isSelected(), this.isFullFileMove(), this.moveCallback);
    }

    protected void doAction() {
        BaseRefactoringProcessor processor2;
        try {
            processor2 = this.getModel().computeModelResult();
        }
        catch (ConfigurationException e) {
            this.setErrorText(e.getMessage());
            return;
        }
        this.saveRefactoringSettings();
        try {
            this.invokeRefactoring(processor2);
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)this.myProject);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classPackageChooser.getChildComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initMemberInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "initFileChooser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initMemberInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "initFileChooser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$2(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initMemberInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "initFileChooser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$3(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initMemberInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "initFileChooser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        JCheckBox jCheckBox4;
        JTextField jTextField;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.mainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, "Center");
        this.memberInfoPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, "South");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(7, 0, 7, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.classPackageChooser;
        jPanel7.add((Component)referenceEditorComboWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.rbMoveToPackage = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("label.text.to.package"));
        jPanel7.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.fileChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.rbMoveToFile = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("label.text.to.file"));
        jPanel7.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tfFileNameInPackage = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel7.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.cbSpecifyFileNameInPackage = jCheckBox4 = new JCheckBox();
        jCheckBox4.setHorizontalAlignment(2);
        jCheckBox4.setHorizontalTextPosition(11);
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("label.text.file.name"));
        jPanel7.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 6, 0, null, null, null, 5));
        this.targetPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 5));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("label.text.destination.directory"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.destinationFolderCB;
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.cbUpdatePackageDirective = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("label.text.update.package.directive"));
        jPanel7.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null, 5));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox = new NonFocusableCheckBox();
        this.cbSearchInComments = nonFocusableCheckBox;
        nonFocusableCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, DynamicBundle.getBundle((String)"messages/RefactoringBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("search.in.comments.and.strings"));
        jPanel8.add((Component)nonFocusableCheckBox, new GridConstraints(1, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.cbSearchTextOccurrences = nonFocusableCheckBox2;
        nonFocusableCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, DynamicBundle.getBundle((String)"messages/RefactoringBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("search.for.text.occurrences"));
        jPanel8.add((Component)nonFocusableCheckBox2, new GridConstraints(1, 1, 1, 1, 8, 3, 0, 0, null, null, null));
        this.cbSearchReferences = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("checkbox.text.search.references"));
        jPanel8.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.cbDeleteEmptySourceFiles = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinTopLevelDeclarationsDialog.class).getString("checkbox.text.delete.empty.source.files"));
        jPanel8.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor((Component)comboboxWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MemberInfoModelImpl
    extends AbstractMemberInfoModel<KtNamedDeclaration, KotlinMemberInfo> {
        private MemberInfoModelImpl() {
        }
    }

    private class MemberSelectionerInfoChangeListener
    implements MemberInfoChangeListener<KtNamedDeclaration, KotlinMemberInfo> {
        private final List<KotlinMemberInfo> memberInfos;

        public MemberSelectionerInfoChangeListener(List<KotlinMemberInfo> memberInfos) {
            this.memberInfos = memberInfos;
        }

        private boolean shouldUpdateFileNameField(Collection<KotlinMemberInfo> changedMembers) {
            if (!MoveKotlinTopLevelDeclarationsDialog.this.tfFileNameInPackage.isEnabled()) {
                return true;
            }
            List previousDeclarations = CollectionsKt.filterNotNull((Iterable)CollectionsKt.map(this.memberInfos, info2 -> changedMembers.contains(info2) != info2.isChecked() ? (KtNamedDeclaration)info2.getMember() : null));
            String suggestedText = previousDeclarations.isEmpty() ? "" : MoveUtilsKt.guessNewFileName(previousDeclarations);
            return MoveKotlinTopLevelDeclarationsDialog.this.tfFileNameInPackage.getText().equals(suggestedText);
        }

        public void memberInfoChanged(@NotNull MemberInfoChange<KtNamedDeclaration, KotlinMemberInfo> event) {
            if (event == null) {
                MemberSelectionerInfoChangeListener.$$$reportNull$$$3(0);
            }
            if (event == null) {
                MemberSelectionerInfoChangeListener.$$$reportNull$$$2(0);
            }
            if (event == null) {
                MemberSelectionerInfoChangeListener.$$$reportNull$$$1(0);
            }
            if (event == null) {
                MemberSelectionerInfoChangeListener.$$$reportNull$$$0(0);
            }
            MoveKotlinTopLevelDeclarationsDialog.this.updatePackageDirectiveCheckBox();
            MoveKotlinTopLevelDeclarationsDialog.this.updateFileNameInPackageField();
            if (this.shouldUpdateFileNameField(event.getChangedMembers())) {
                MoveKotlinTopLevelDeclarationsDialog.this.updateSuggestedFileName();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$MemberSelectionerInfoChangeListener", "memberInfoChanged"));
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$MemberSelectionerInfoChangeListener", "memberInfoChanged"));
        }

        private static /* synthetic */ void $$$reportNull$$$2(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$MemberSelectionerInfoChangeListener", "memberInfoChanged"));
        }

        private static /* synthetic */ void $$$reportNull$$$3(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$MemberSelectionerInfoChangeListener", "memberInfoChanged"));
        }
    }
}

