/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\r\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticParameterRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "element", "Lorg/jetbrains/kotlin/psi/KtParameter;", "newName", "", "(Lorg/jetbrains/kotlin/psi/KtParameter;Ljava/lang/String;)V", "entityName", "getDialogDescription", "Lorg/jetbrains/annotations/NotNull;", "getDialogTitle", "isSelectedByDefault", "", "processHierarchy", "", "idea"})
public final class AutomaticParameterRenamer
extends AutomaticRenamer {
    private final void processHierarchy(KtParameter element3, String newName2) {
        KtDeclarationWithBody ktDeclarationWithBody = element3.getOwnerFunction();
        if (ktDeclarationWithBody == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclarationWithBody, (String)"element.ownerFunction ?: return");
        KtDeclarationWithBody function2 = ktDeclarationWithBody;
        PsiElement psiElement2 = function2;
        SearchScope searchScope2 = function2.getUseScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"function.useScope");
        Iterator iterator2 = OverridersSearchKt.searchOverriders(new HierarchySearchRequest(psiElement2, searchScope2, false, 4, null)).iterator();
        while (iterator2.hasNext()) {
            PsiNamedElement parameter;
            PsiNamedElement psiNamedElement;
            boolean $i$f$firstOrNull;
            PsiNamedElement callable2;
            PsiMethod overrider;
            PsiMethod psiMethod = overrider = (PsiMethod)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"overrider");
            if (LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)psiMethod) == null) {
                continue;
            }
            if (!KotlinRefactoringUtilKt.canRefactor((PsiElement)callable2)) continue;
            Object object = callable2;
            if (object instanceof KtCallableDeclaration) {
                Object v6;
                block9: {
                    List<KtParameter> list2 = ((KtCallableDeclaration)callable2).getValueParameters();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callable.valueParameters");
                    Iterable $this$firstOrNull$iv = list2;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtParameter it = (KtParameter)element$iv;
                        boolean bl = false;
                        KtParameter ktParameter = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"it");
                        if (!Intrinsics.areEqual((Object)ktParameter.getName(), (Object)element3.getName())) continue;
                        v6 = element$iv;
                        break block9;
                    }
                    v6 = null;
                }
                psiNamedElement = v6;
            } else if (object instanceof PsiMethod) {
                PsiParameter psiParameter;
                block10: {
                    PsiParameter[] $this$firstOrNull$iv;
                    PsiParameterList psiParameterList = ((PsiMethod)callable2).getParameterList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"callable.parameterList");
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList.getParameters(), (String)"callable.parameterList.parameters");
                    $i$f$firstOrNull = false;
                    PsiParameter[] psiParameterArray = $this$firstOrNull$iv;
                    int n = psiParameterArray.length;
                    for (int j = 0; j < n; ++j) {
                        PsiParameter element$iv;
                        PsiParameter it = element$iv = psiParameterArray[j];
                        boolean bl = false;
                        PsiParameter psiParameter2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter2, (String)"it");
                        if (!Intrinsics.areEqual((Object)psiParameter2.getName(), (Object)element3.getName())) continue;
                        psiParameter = element$iv;
                        break block10;
                    }
                    psiParameter = null;
                }
                psiNamedElement = (PsiNamedElement)psiParameter;
            } else {
                psiNamedElement = parameter = null;
            }
            if (parameter == null) continue;
            object = this.myElements;
            boolean bl = false;
            object.add(parameter);
        }
        this.suggestAllNames(element3.getName(), KtPsiUtilKt.quoteIfNeeded(newName2));
    }

    @NotNull
    public String getDialogTitle() {
        return KotlinBundle.message("text.rename.parameters.title", new Object[0]);
    }

    @NotNull
    public String getDialogDescription() {
        String string = RefactoringBundle.message((String)"rename.parameters.hierarchy");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RefactoringBundle.messag\u2026me.parameters.hierarchy\")");
        return string;
    }

    @NotNull
    public String entityName() {
        return KotlinBundle.message("text.parameter", new Object[0]);
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    public AutomaticParameterRenamer(@NotNull KtParameter element3, @NotNull String newName2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
        this.processHierarchy(element3, newName2);
    }
}

