/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchSourceFileProcessor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0003\b\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor;", "", "()V", "process", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result;", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "Companion", "KtSourceProcessor", "Result", "idea-jvm"})
public final class KtScratchSourceFileProcessor {
    @NotNull
    public static final String GENERATED_OUTPUT_PREFIX = "##scratch##generated##";
    @NotNull
    public static final String LINES_INFO_MARKER = "end##";
    @NotNull
    public static final String END_OUTPUT_MARKER = "end##!@#%^&*";
    @NotNull
    public static final String OBJECT_NAME = "ScratchFileRunnerGenerated";
    @NotNull
    public static final String INSTANCE_NAME = "instanceScratchFileRunner";
    @NotNull
    public static final String PACKAGE_NAME = "org.jetbrains.kotlin.idea.scratch.generated";
    @NotNull
    public static final String GET_RES_FUN_NAME_PREFIX = "generated_get_instance_res";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Result process(@NotNull List<ScratchExpression> expressions2) {
        Intrinsics.checkParameterIsNotNull(expressions2, (String)"expressions");
        KtSourceProcessor sourceProcessor = new KtSourceProcessor();
        Iterable $this$forEach$iv = expressions2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScratchExpression it = (ScratchExpression)element$iv;
            boolean bl = false;
            sourceProcessor.process(it);
        }
        String codeResult2 = "\n                package org.jetbrains.kotlin.idea.scratch.generated\n\n                " + CollectionsKt.joinToString$default((Iterable)sourceProcessor.getImports(), (CharSequence)"\n", null, null, (int)0, null, (Function1)process.codeResult.1.INSTANCE, (int)30, null) + "\n\n                object ScratchFileRunnerGenerated {\n                    class ScratchFileRunnerGenerated {\n                        " + sourceProcessor.getClassBuilder() + "\n                    }\n\n                    @JvmStatic fun main(args: Array<String>) {\n                        val instanceScratchFileRunner = ScratchFileRunnerGenerated()\n                        " + sourceProcessor.getObjectBuilder() + "\n                        println(\"end##!@#%^&*\")\n                    }\n                }\n            ";
        return new Result.OK("org.jetbrains.kotlin.idea.scratch.generated.ScratchFileRunnerGenerated", codeResult2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u0013*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0018\u0010\u001e\u001a\n \u001f*\u0004\u0018\u00010\u00040\u0004*\u00060\u0004j\u0002`\u0005H\u0002J \u0010 \u001a\n \u001f*\u0004\u0018\u00010\u00040\u0004*\u00060\u0004j\u0002`\u00052\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\n \u001f*\u0004\u0018\u00010\u00040\u0004*\u00060\u0004j\u0002`\u00052\u0006\u0010!\u001a\u00020\"H\u0002R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$KtSourceProcessor;", "", "()V", "classBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getClassBuilder", "()Ljava/lang/StringBuilder;", "imports", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lkotlin/collections/ArrayList;", "getImports", "()Ljava/util/ArrayList;", "objectBuilder", "getObjectBuilder", "resCount", "", "process", "", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "processDeclaration", "e", "c", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "processExpression", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "appendLineInfo", "newLine", "kotlin.jvm.PlatformType", "println", "str", "", "printlnObj", "idea-jvm"})
    public static final class KtSourceProcessor {
        @NotNull
        private final StringBuilder classBuilder = new StringBuilder();
        @NotNull
        private final StringBuilder objectBuilder = new StringBuilder();
        @NotNull
        private final ArrayList<KtImportDirective> imports;
        private int resCount;

        @NotNull
        public final StringBuilder getClassBuilder() {
            return this.classBuilder;
        }

        @NotNull
        public final StringBuilder getObjectBuilder() {
            return this.objectBuilder;
        }

        @NotNull
        public final ArrayList<KtImportDirective> getImports() {
            return this.imports;
        }

        public final void process(@NotNull ScratchExpression expression2) {
            block1: {
                PsiElement psiElement2;
                PsiElement psiElement3;
                block4: {
                    block3: {
                        block2: {
                            block0: {
                                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                psiElement2 = psiElement3 = expression2.getElement();
                                if (!(psiElement2 instanceof KtVariableDeclaration)) break block0;
                                this.processDeclaration(expression2, (KtDeclaration)psiElement3);
                                break block1;
                            }
                            if (!(psiElement2 instanceof KtFunction)) break block2;
                            this.processDeclaration(expression2, (KtDeclaration)psiElement3);
                            break block1;
                        }
                        if (!(psiElement2 instanceof KtClassOrObject)) break block3;
                        this.processDeclaration(expression2, (KtDeclaration)psiElement3);
                        break block1;
                    }
                    if (!(psiElement2 instanceof KtImportDirective)) break block4;
                    this.imports.add((KtImportDirective)psiElement3);
                    break block1;
                }
                if (!(psiElement2 instanceof KtExpression)) break block1;
                this.processExpression(expression2, (KtExpression)psiElement3);
            }
        }

        private final void processDeclaration(ScratchExpression e, KtDeclaration c) {
            StringBuilder stringBuilder2 = this.classBuilder.append(c.getText());
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"classBuilder.append(c.text)");
            this.newLine(stringBuilder2);
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)c, null, (int)1, null);
            if (declarationDescriptor == null) {
                return;
            }
            DeclarationDescriptor descriptor2 = declarationDescriptor;
            RenderingContext context2 = RenderingContext.Companion.of(descriptor2);
            this.println(this.objectBuilder, Renderers.COMPACT.render(descriptor2, context2));
            this.appendLineInfo(this.objectBuilder, e);
        }

        private final void processExpression(ScratchExpression e, KtExpression expr2) {
            String resName = KtScratchSourceFileProcessor.GET_RES_FUN_NAME_PREFIX + this.resCount;
            StringBuilder stringBuilder2 = this.classBuilder.append("fun " + resName + "() = run { " + expr2.getText() + " }");
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"classBuilder.append(\"fun\u2026 = run { ${expr.text} }\")");
            this.newLine(stringBuilder2);
            this.printlnObj(this.objectBuilder, "instanceScratchFileRunner." + resName + "()");
            this.appendLineInfo(this.objectBuilder, e);
            ++this.resCount;
        }

        private final void appendLineInfo(@NotNull StringBuilder $this$appendLineInfo, ScratchExpression e) {
            this.println($this$appendLineInfo, KtScratchSourceFileProcessor.LINES_INFO_MARKER + e.getLineStart() + '|' + e.getLineEnd());
        }

        private final StringBuilder println(@NotNull StringBuilder $this$println, String str) {
            StringBuilder stringBuilder2 = $this$println.append("println(\"##scratch##generated##" + str + "\")");
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(\"println(\\\"$GENER\u2026ED_OUTPUT_PREFIX$str\\\")\")");
            return this.newLine(stringBuilder2);
        }

        private final StringBuilder printlnObj(@NotNull StringBuilder $this$printlnObj, String str) {
            StringBuilder stringBuilder2 = $this$printlnObj.append("println(\"##scratch##generated##${" + str + "}\")");
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(\"println(\\\"$GENER\u2026UTPUT_PREFIX\\${$str}\\\")\")");
            return this.newLine(stringBuilder2);
        }

        private final StringBuilder newLine(@NotNull StringBuilder $this$newLine) {
            return $this$newLine.append("\n");
        }

        public KtSourceProcessor() {
            KtSourceProcessor ktSourceProcessor = this;
            boolean bl = false;
            ArrayList arrayList = new ArrayList();
            ktSourceProcessor.imports = arrayList;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result;", "", "()V", "Error", "OK", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$Error;", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "idea-jvm"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$Error;", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "idea-jvm"})
        public static final class Error
        extends Result {
            @NotNull
            private final String message;

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            public Error(@NotNull String message2) {
                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                super(null);
                this.message = message2;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result;", "mainClassName", "", "code", "(Ljava/lang/String;Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "getMainClassName", "idea-jvm"})
        public static final class OK
        extends Result {
            @NotNull
            private final String mainClassName;
            @NotNull
            private final String code;

            @NotNull
            public final String getMainClassName() {
                return this.mainClassName;
            }

            @NotNull
            public final String getCode() {
                return this.code;
            }

            public OK(@NotNull String mainClassName, @NotNull String code) {
                Intrinsics.checkParameterIsNotNull((Object)mainClassName, (String)"mainClassName");
                Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
                super(null);
                this.mainClassName = mainClassName;
                this.code = code;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Companion;", "", "()V", "END_OUTPUT_MARKER", "", "GENERATED_OUTPUT_PREFIX", "GET_RES_FUN_NAME_PREFIX", "INSTANCE_NAME", "LINES_INFO_MARKER", "OBJECT_NAME", "PACKAGE_NAME", "idea-jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

