/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileLanguageProvider;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.ui.KtScratchFileEditorProviderKt;
import org.jetbrains.kotlin.idea.scratch.ui.KtScratchFileEditorWithPreview;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/KtScratchFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "idea-jvm"})
public final class KtScratchFileEditorProvider
implements FileEditorProvider,
DumbAware {
    @NotNull
    public String getEditorTypeId() {
        return "KtsScratchFileEditorProvider";
    }

    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!file2.isValid()) {
            return false;
        }
        if (!ScratchUtilsKt.isKotlinScratch(file2) && !ScratchUtilsKt.isKotlinWorksheet(file2)) {
            return false;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file2);
        if (psiFile2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"PsiManager.getInstance(p\u2026ile(file) ?: return false");
        PsiFile psiFile3 = psiFile2;
        FileType fileType = psiFile3.getFileType();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"psiFile.fileType");
        return ScratchFileLanguageProvider.Companion.get(fileType) != null;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        ScratchFile scratchFile = KtScratchFileEditorProviderKt.createScratchFile(project2, file2);
        if (scratchFile == null) {
            FileEditor fileEditor = TextEditorProvider.getInstance().createEditor(project2, file2);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor, (String)"TextEditorProvider.getIn\u2026eateEditor(project, file)");
            return fileEditor;
        }
        ScratchFile scratchFile2 = scratchFile;
        return KtScratchFileEditorWithPreview.Companion.create(scratchFile2);
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

