/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scripting.gradle;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.scripting.gradle.GradleKotlinScriptConfigurationInputs;
import org.jetbrains.kotlin.idea.scripting.gradle.TestingKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a.\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e\u001a\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0002\u001a\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0002\u001a\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0006\u0010\u001d\u001a\u00020\u0014\"\u0016\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0005j\b\u0012\u0004\u0012\u00020\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"cachedGradleProjectsRoots", "", "", "minimal_gradle_version_supported", "sections", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "computeGradleProjectRoots", "project", "Lcom/intellij/openapi/project/Project;", "getGradleProjectsRoots", "getGradleScriptInputsStamp", "Lorg/jetbrains/kotlin/idea/scripting/gradle/GradleKotlinScriptConfigurationInputs;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "givenKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "givenTimeStamp", "", "isGradleKotlinScript", "", "virtualFile", "isInAffectedGradleProjectFiles", "filePath", "kotlinDslScriptsModelImportSupported", "currentGradleVersion", "saveGradleProjectRootsAfterImport", "", "roots", "useScriptConfigurationFromImportOnly", "idea-gradle"})
public final class UtilsKt {
    private static final ArrayList<String> sections = CollectionsKt.arrayListOf((Object[])new String[]{"buildscript", "plugins", "initscript", "pluginManagement"});
    private static Set<String> cachedGradleProjectsRoots;
    @NotNull
    public static final String minimal_gradle_version_supported = "6.0";

    public static final boolean isGradleKotlinScript(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        String string = virtualFile2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"virtualFile.name");
        return StringsKt.endsWith$default((String)string, (String)".gradle.kts", (boolean)false, (int)2, null);
    }

    public static final boolean isInAffectedGradleProjectFiles(@NotNull Project project2, @NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        if (StringsKt.endsWith$default((String)filePath, (String)"/gradle.properties", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.endsWith$default((String)filePath, (String)"/gradle-wrapper.properties", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.endsWith$default((String)filePath, (String)".gradle", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)".gradle.kts", (boolean)false, (int)2, null)) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (TestingKt.isUnitTestModeWithoutAffectedGradleProjectFilesCheck(application)) {
                return true;
            }
            return UtilsKt.getGradleProjectsRoots(project2).contains(StringsKt.substringBeforeLast$default((String)filePath, (String)"/", null, (int)2, null));
        }
        return false;
    }

    private static final Set<String> getGradleProjectsRoots(Project project2) {
        Set set2;
        if (cachedGradleProjectsRoots == null) {
            cachedGradleProjectsRoots = UtilsKt.computeGradleProjectRoots(project2);
        }
        if ((set2 = cachedGradleProjectsRoots) == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    public static final void saveGradleProjectRootsAfterImport(@NotNull Set<String> roots) {
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        cachedGradleProjectsRoots = roots;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> computeGradleProjectRoots(Project project2) {
        void $this$filterIsInstanceTo$iv$iv;
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractExternalSystemSettings, (String)"ExternalSystemApiUtil.ge\u2026radleConstants.SYSTEM_ID)");
        AbstractExternalSystemSettings gradleSettings = abstractExternalSystemSettings;
        if (gradleSettings.getLinkedProjectsSettings().isEmpty()) {
            boolean bl = false;
            return SetsKt.emptySet();
        }
        Collection collection = gradleSettings.getLinkedProjectsSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"gradleSettings.getLinkedProjectsSettings()");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GradleProjectSettings)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (gradleProjectSettings == null) {
            boolean bl = false;
            return SetsKt.emptySet();
        }
        GradleProjectSettings projectSettings = gradleProjectSettings;
        Set set2 = projectSettings.getModules();
        boolean bl = false;
        boolean bl2 = false;
        Set it = set2;
        boolean bl3 = false;
        Set set3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"it");
        Collection collection2 = set3;
        boolean bl4 = false;
        Set set4 = !collection2.isEmpty() ? set2 : null;
        if (set4 == null) {
            set4 = SetsKt.setOf((Object)projectSettings.getExternalProjectPath());
        }
        return set4;
    }

    @Nullable
    public static final GradleKotlinScriptConfigurationInputs getGradleScriptInputsStamp(@NotNull Project project2, @NotNull VirtualFile file2, @Nullable KtFile givenKtFile, long givenTimeStamp) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!UtilsKt.isGradleKotlinScript(file2)) {
            return null;
        }
        return (GradleKotlinScriptConfigurationInputs)ApplicationUtilsKt.runReadAction((Function0)new Function0<GradleKotlinScriptConfigurationInputs>(givenKtFile, project2, file2, givenTimeStamp){
            final /* synthetic */ KtFile $givenKtFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ long $givenTimeStamp;

            @Nullable
            public final GradleKotlinScriptConfigurationInputs invoke() {
                GradleKotlinScriptConfigurationInputs gradleKotlinScriptConfigurationInputs;
                KtFile ktFile;
                KtFile ktFile2 = this.$givenKtFile;
                if (ktFile2 == null) {
                    PsiFile psiFile2 = PsiManager.getInstance((Project)this.$project).findFile(this.$file);
                    if (!(psiFile2 instanceof KtFile)) {
                        psiFile2 = null;
                    }
                    ktFile2 = ktFile = (KtFile)psiFile2;
                }
                if (ktFile != null) {
                    StringBuilder result2 = new StringBuilder();
                    KtScriptInitializer[] ktScriptInitializerArray = ktFile.getScript();
                    if (ktScriptInitializerArray != null && (ktScriptInitializerArray = ktScriptInitializerArray.getBlockExpression()) != null) {
                        PsiElement $this$getChildrenOfType$iv = (PsiElement)ktScriptInitializerArray;
                        boolean $i$f$getChildrenOfType = false;
                        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtScriptInitializer.class);
                        if (psiElementArray == null) {
                            psiElementArray = new KtScriptInitializer[]{};
                        }
                        if ((ktScriptInitializerArray = (KtScriptInitializer[])psiElementArray) != null) {
                            KtScriptInitializer[] $this$forEach$iv = ktScriptInitializerArray;
                            boolean $i$f$forEach = false;
                            KtScriptInitializer[] ktScriptInitializerArray2 = $this$forEach$iv;
                            int n = ktScriptInitializerArray2.length;
                            for (int j = 0; j < n; ++j) {
                                KtLambdaArgument lambda2;
                                KtCallExpression call2;
                                Object object;
                                KtScriptInitializer element$iv;
                                KtScriptInitializer it = element$iv = ktScriptInitializerArray2[j];
                                boolean bl = false;
                                Object[] objectArray = it.getChildren();
                                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"it.children");
                                Object object2 = ArraysKt.singleOrNull((Object[])objectArray);
                                if (!(object2 instanceof KtCallExpression)) {
                                    object2 = null;
                                }
                                if ((object = (call2 = (KtCallExpression)object2)) == null || (object = object.getFirstChild()) == null || (object = object.getText()) == null) {
                                    continue;
                                }
                                Object callRef = object;
                                if (!UtilsKt.access$getSections$p().contains(callRef)) continue;
                                result2.append((String)callRef);
                                List<KtLambdaArgument> list2 = call2.getLambdaArguments();
                                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"call.lambdaArguments");
                                KtLambdaArgument ktLambdaArgument = lambda2 = (KtLambdaArgument)CollectionsKt.singleOrNull(list2);
                                if (ktLambdaArgument != null) {
                                    ktLambdaArgument.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(false, result2){
                                        final /* synthetic */ StringBuilder $result$inlined;
                                        {
                                            this.$result$inlined = stringBuilder2;
                                            super($super_call_param$1);
                                        }

                                        public void visitElement(@NotNull PsiElement element3) {
                                            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                                            super.visitElement(element3);
                                            PsiElement psiElement2 = element3;
                                            if (psiElement2 instanceof PsiWhiteSpace) {
                                                String string = ((PsiWhiteSpace)element3).getText();
                                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.text");
                                                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                                                    this.$result$inlined.append("\n");
                                                }
                                            } else if (!(psiElement2 instanceof PsiComment) && psiElement2 instanceof LeafPsiElement) {
                                                this.$result$inlined.append(((LeafPsiElement)element3).getText());
                                            }
                                        }
                                    });
                                }
                                result2.append("\n");
                            }
                        }
                    }
                    String string = result2.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
                    gradleKotlinScriptConfigurationInputs = new GradleKotlinScriptConfigurationInputs(string, this.$givenTimeStamp);
                } else {
                    gradleKotlinScriptConfigurationInputs = null;
                }
                return gradleKotlinScriptConfigurationInputs;
            }
            {
                this.$givenKtFile = ktFile;
                this.$project = project2;
                this.$file = virtualFile2;
                this.$givenTimeStamp = l;
                super(0);
            }
        });
    }

    public static /* synthetic */ GradleKotlinScriptConfigurationInputs getGradleScriptInputsStamp$default(Project project2, VirtualFile virtualFile2, KtFile ktFile, long l, int n, Object object) {
        if ((n & 4) != 0) {
            ktFile = null;
        }
        if ((n & 8) != 0) {
            l = System.currentTimeMillis();
        }
        return UtilsKt.getGradleScriptInputsStamp(project2, virtualFile2, ktFile, l);
    }

    public static final boolean kotlinDslScriptsModelImportSupported(@NotNull String currentGradleVersion) {
        Intrinsics.checkParameterIsNotNull((Object)currentGradleVersion, (String)"currentGradleVersion");
        return GradleVersion.version((String)currentGradleVersion).compareTo(GradleVersion.version((String)minimal_gradle_version_supported)) >= 0;
    }

    public static final boolean useScriptConfigurationFromImportOnly() {
        return Registry.is((String)"kotlin.gradle.scripts.useIdeaProjectImport", (boolean)false);
    }

    public static final /* synthetic */ ArrayList access$getSections$p() {
        return sections;
    }
}

