/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vfilefinder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.vfilefinder.FileIndexesKt;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinClassFileIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinMetadataFileIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinMetadataFilePackageIndex;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/IDEVirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "findBuiltInsData", "Ljava/io/InputStream;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "findMetadata", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findVirtualFileWithHeader", "Lcom/intellij/openapi/vfs/VirtualFile;", "key", "Lcom/intellij/util/indexing/ID;", "Ljava/lang/Void;", "hasMetadataPackage", "", "fqName", "Companion", "idea-core"})
public final class IDEVirtualFileFinder
extends VirtualFileFinder {
    private final GlobalSearchScope scope;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        InputStream inputStream;
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        VirtualFile virtualFile2 = this.findVirtualFileWithHeader(classId, KotlinMetadataFileIndex.INSTANCE.getKEY());
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        try {
            inputStream = file2.getInputStream();
        }
        catch (FileNotFoundException e) {
            inputStream = null;
        }
        return inputStream;
    }

    @Override
    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return FileIndexesKt.hasSomethingInPackage(KotlinMetadataFilePackageIndex.INSTANCE, fqName2, this.scope);
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        return null;
    }

    @Override
    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        return this.findVirtualFileWithHeader(classId, KotlinClassFileIndex.INSTANCE.getKEY());
    }

    private final VirtualFile findVirtualFileWithHeader(ClassId classId, ID<FqName, Void> key) {
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(key, (Object)classId.asSingleFqName(), this.scope);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"FileBasedIndex.getInstan\u2026.asSingleFqName(), scope)");
        return (VirtualFile)CollectionsKt.firstOrNull((Iterable)collection);
    }

    public IDEVirtualFileFinder(@NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        this.scope = scope2;
        if (Intrinsics.areEqual((Object)this.scope, (Object)GlobalSearchScope.EMPTY_SCOPE) ^ true && this.scope.getProject() == null) {
            LOG.warn("Scope with null project " + this.scope);
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(IDEVirtualFileFinder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(IDEVi\u2026alFileFinder::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/IDEVirtualFileFinder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "idea-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

