/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u00020\u00032\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dumpValue", "value", "process", "", "srcFile", "newMap", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "sourceFile", "kotlin-build-common"})
final class InlineFunctionsMap
extends BasicStringMap<Map<String, ? extends Long>> {
    private final FileToPathConverter pathConverter;

    public final void process(@NotNull File srcFile, @NotNull Map<String, Long> newMap2, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        Intrinsics.checkParameterIsNotNull(newMap2, (String)"newMap");
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        String key = this.pathConverter.toPath(srcFile);
        Map map2 = (Map)this.getStorage().get(key);
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map oldMap2 = map2;
        Map<String, Long> map3 = newMap2;
        boolean bl = false;
        if (!map3.isEmpty()) {
            this.getStorage().set(key, newMap2);
        } else {
            this.getStorage().remove(key);
        }
        for (String fn : SetsKt.plus(oldMap2.keySet(), (Iterable)newMap2.keySet())) {
            FqName fqName2;
            List fqNameSegments = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)StringsKt.removePrefix((String)fn, (CharSequence)"<get>"), (CharSequence)"<set>"), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)FqName.fromSegments(fqNameSegments), (String)"FqName.fromSegments(fqNameSegments)");
            FqName fqName3 = fqName2.parent();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fqName.parent()");
            String string = fqName2.shortName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName.shortName().asString()");
            changesCollector.collectMemberIfValueWasChanged(fqName3, string, oldMap2.get(fn), newMap2.get(fn));
        }
    }

    public final void remove(@NotNull File sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        this.getStorage().remove(this.pathConverter.toPath(sourceFile));
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Map<String, Long> value2) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        return IncrementalJvmCacheKt.dumpMap(value2, dumpValue.1.INSTANCE);
    }

    public InlineFunctionsMap(@NotNull File storageFile, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
        Intrinsics.checkParameterIsNotNull((Object)pathConverter, (String)"pathConverter");
        super(storageFile, StringToLongMapExternalizer.INSTANCE);
        this.pathConverter = pathConverter;
    }
}

