/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/LabeledBlockToDoWhileTransformation;", "", "()V", "apply", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "labelLoopBreaksAndContinues", "loopOrSwitch", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "fakeLoops", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "label", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "js.translator"})
public final class LabeledBlockToDoWhileTransformation {
    public static final LabeledBlockToDoWhileTransformation INSTANCE;

    public final void apply(@NotNull JsNode root2) {
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        new JsVisitorWithContextImpl(){
            @NotNull
            private final Stack<JsStatement> loopOrSwitchStack;
            @NotNull
            private final HashSet<JsDoWhile> newFakeLoops;
            @NotNull
            private final HashMap<JsStatement, JsLabel> statementsLabels;
            @NotNull
            private final HashSet<JsStatement> loopsAndSwitchesToLabel;

            @NotNull
            public final Stack<JsStatement> getLoopOrSwitchStack() {
                return this.loopOrSwitchStack;
            }

            @NotNull
            public final HashSet<JsDoWhile> getNewFakeLoops() {
                return this.newFakeLoops;
            }

            @NotNull
            public final HashMap<JsStatement, JsLabel> getStatementsLabels() {
                return this.statementsLabels;
            }

            @NotNull
            public final HashSet<JsStatement> getLoopsAndSwitchesToLabel() {
                return this.loopsAndSwitchesToLabel;
            }

            public void endVisit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                if (x.getStatement() instanceof JsBlock) {
                    CollectionsKt.addIfNotNull((Collection)this.loopsAndSwitchesToLabel, kotlin.collections.CollectionsKt.lastOrNull((List)this.loopOrSwitchStack));
                    JsDoWhile fakeLoop = new JsDoWhile(new JsBooleanLiteral(false), x.getStatement());
                    this.newFakeLoops.add(fakeLoop);
                    x.setStatement(fakeLoop);
                }
                super.endVisit(x, ctx);
            }

            public boolean visit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                if (x.getStatement() instanceof JsLoop) {
                    Map map2 = this.statementsLabels;
                    JsStatement jsStatement = x.getStatement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"x.statement");
                    map2.put(jsStatement, x);
                }
                return true;
            }

            public boolean visit(@NotNull JsLoop x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                this.loopOrSwitchStack.push(x);
                return true;
            }

            public boolean visit(@NotNull JsSwitch x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                this.loopOrSwitchStack.push(x);
                return true;
            }

            public final void endVisitLoopOrSwitch(@NotNull JsStatement x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                JsStatement top = this.loopOrSwitchStack.pop();
                boolean bl = top == x;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (this.loopsAndSwitchesToLabel.contains(x)) {
                    JsLabel label2 = this.statementsLabels.get(x);
                    if (label2 == null) {
                        JsName jsName = JsScope.declareTemporaryName("loop_label");
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"JsScope.declareTemporaryName(\"loop_label\")");
                        JsName labelName2 = jsName;
                        label2 = new JsLabel(labelName2, x);
                        ((Map)this.statementsLabels).put(x, label2);
                        ctx.replaceMe((JsNode)label2);
                    }
                    Set set2 = this.newFakeLoops;
                    JsNameRef jsNameRef = label2.getName().makeRef();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"label.name.makeRef()");
                    LabeledBlockToDoWhileTransformation.access$labelLoopBreaksAndContinues(LabeledBlockToDoWhileTransformation.INSTANCE, x, set2, jsNameRef);
                }
            }

            public void endVisit(@NotNull JsSwitch x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                this.endVisitLoopOrSwitch(x, ctx);
            }

            public void endVisit(@NotNull JsLoop x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                this.endVisitLoopOrSwitch(x, ctx);
            }
            {
                this.loopOrSwitchStack = new Stack<E>();
                this.newFakeLoops = new HashSet<E>();
                this.statementsLabels = new HashMap<K, V>();
                this.loopsAndSwitchesToLabel = new HashSet<E>();
            }
        }.accept(root2);
    }

    private final void labelLoopBreaksAndContinues(JsStatement loopOrSwitch, Set<? extends JsDoWhile> fakeLoops, JsNameRef label2) {
        new JsVisitorWithContextImpl(loopOrSwitch, fakeLoops, label2){
            final /* synthetic */ JsStatement $loopOrSwitch;
            final /* synthetic */ Set $fakeLoops;
            final /* synthetic */ JsNameRef $label;

            public boolean visit(@NotNull JsLoop x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                return kotlin.collections.CollectionsKt.contains((Iterable)this.$fakeLoops, (Object)x) || x == this.$loopOrSwitch;
            }

            public boolean visit(@NotNull JsSwitch x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                return x == this.$loopOrSwitch;
            }

            public void endVisit(@NotNull JsBreak x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                if (x.getLabel() == null) {
                    ctx.replaceMe((JsNode)new JsBreak(this.$label));
                }
                super.endVisit(x, ctx);
            }

            public void endVisit(@NotNull JsContinue x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                if (x.getLabel() == null) {
                    ctx.replaceMe((JsNode)new JsContinue(this.$label));
                }
                super.endVisit(x, ctx);
            }
            {
                this.$loopOrSwitch = $captured_local_variable$0;
                this.$fakeLoops = $captured_local_variable$1;
                this.$label = $captured_local_variable$2;
            }
        }.accept((JsNode)loopOrSwitch);
    }

    private LabeledBlockToDoWhileTransformation() {
    }

    static {
        LabeledBlockToDoWhileTransformation labeledBlockToDoWhileTransformation;
        INSTANCE = labeledBlockToDoWhileTransformation = new LabeledBlockToDoWhileTransformation();
    }

    public static final /* synthetic */ void access$labelLoopBreaksAndContinues(LabeledBlockToDoWhileTransformation $this, JsStatement loopOrSwitch, Set fakeLoops, JsNameRef label2) {
        $this.labelLoopBreaksAndContinues(loopOrSwitch, fakeLoops, label2);
    }
}

