/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsQualifierChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "validateQualifier", "", "qualifier", "", "js.frontend"})
public final class JsQualifierChecker
implements AdditionalAnnotationChecker {
    public static final JsQualifierChecker INSTANCE;

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries2, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(entries2, (String)"entries");
        Intrinsics.checkParameterIsNotNull(actualTargets, (String)"actualTargets");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        BindingContext bindingContext3 = bindingContext2;
        for (KtAnnotationEntry ktAnnotationEntry : entries2) {
            String argument2;
            AnnotationDescriptor annotation2;
            if ((AnnotationDescriptor)bindingContext3.get(BindingContext.ANNOTATION, ktAnnotationEntry) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"bindingContext[BindingCo\u2026ATION, entry] ?: continue");
            if (Intrinsics.areEqual((Object)annotation2.getFqName(), (Object)AnnotationsUtils.JS_QUALIFIER_ANNOTATION) ^ true) continue;
            ConstantValue constantValue = (ConstantValue)CollectionsKt.singleOrNull((Iterable)annotation2.getAllValueArguments().values());
            Object object = constantValue != null ? constantValue.getValue() : null;
            if (!(object instanceof String)) {
                object = null;
            }
            if ((String)object == null) {
                continue;
            }
            if (this.validateQualifier(argument2)) continue;
            KtValueArgumentList ktValueArgumentList = ktAnnotationEntry.getValueArgumentList();
            if (ktValueArgumentList == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktValueArgumentList, (String)"entry.valueArgumentList!!");
            KtValueArgument argumentPsi = ktValueArgumentList.getArguments().get(0);
            trace.report(ErrorsJs.WRONG_JS_QUALIFIER.on((KtValueArgument)((PsiElement)argumentPsi)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateQualifier(String qualifier2) {
        boolean bl;
        List parts = StringsKt.split$default((CharSequence)qualifier2, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
        if (parts.isEmpty()) {
            return false;
        }
        Iterable $this$all$iv = parts;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            String part = (String)element$iv;
            boolean bl2 = false;
            CharSequence charSequence = part;
            boolean bl3 = false;
            if (charSequence.length() <= 0) return false;
            boolean bl4 = true;
            if (!bl4) return false;
            char c = part.charAt(0);
            bl3 = false;
            if (!Character.isJavaIdentifierStart(c)) return false;
            CharSequence $this$all$iv2 = StringsKt.drop((String)part, (int)1);
            boolean $i$f$all2 = false;
            CharSequence charSequence2 = $this$all$iv2;
            for (int j = 0; j < charSequence2.length(); ++j) {
                char element$iv2;
                char p1 = element$iv2 = charSequence2.charAt(j);
                boolean bl5 = false;
                char c2 = p1;
                boolean bl6 = false;
                if (Character.isJavaIdentifierPart(c2)) continue;
                return false;
            }
            boolean bl7 = true;
            if (!bl7) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private JsQualifierChecker() {
    }

    static {
        JsQualifierChecker jsQualifierChecker;
        INSTANCE = jsQualifierChecker = new JsQualifierChecker();
    }
}

