/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslatorKt;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 (2\u00020\u0001:\u0002'(B%\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J \u0010\u001a\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002J6\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u001f2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010%\u001a\u00020\u0005*\u00020\u00052\u0006\u0010&\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "isNativeFunctionCall", "", "typeToUTypeArray", "", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "prepareConcatArguments", "", "arguments", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "list", "varargElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "removeLastUndefinedArguments", "", "result", "toArray", "elements", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "translateUnresolvedArguments", "", "translateVarargArgument", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "translatedArgs", "shouldWrapVarargInArray", "wrapInUArray", "elementType", "ArgumentsInfo", "Companion", "js.translator"})
public final class CallArgumentTranslator
extends AbstractTranslator {
    private final boolean isNativeFunctionCall;
    private final Map<PrimitiveType, ClassDescriptor> typeToUTypeArray;
    private final ResolvedCall<?> resolvedCall;
    private final JsExpression receiver;
    private final TranslationContext context;
    public static final Companion Companion = new Companion(null);

    private final void removeLastUndefinedArguments(List<JsExpression> result2) {
        int i2;
        for (i2 = CollectionsKt.getLastIndex(result2); i2 >= 0 && JsAstUtils.isUndefinedExpression(result2.get(i2)); --i2) {
        }
        result2.subList(i2 + 1, result2.size()).clear();
    }

    private final ArgumentsInfo translate() {
        Object callableDescriptor;
        Object obj = this.resolvedCall.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.resultingDescriptor");
        List<ValueParameterDescriptor> list2 = obj.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedCall.resultingDescriptor.valueParameters");
        List<ValueParameterDescriptor> valueParameters2 = list2;
        boolean hasSpreadOperator = false;
        TemporaryConstVariable cachedReceiver = null;
        List result2 = new ArrayList(valueParameters2.size());
        List<ResolvedValueArgument> list3 = this.resolvedCall.getValueArgumentsByIndex();
        if (list3 == null) {
            throw (Throwable)new IllegalStateException("Failed to arrange value arguments by index: " + this.resolvedCall.getResultingDescriptor());
        }
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"resolvedCall.valueArgume\u2026Call.resultingDescriptor)");
        List<ResolvedValueArgument> valueArgumentsByIndex = list3;
        List argsBeforeVararg = null;
        List<JsExpression> concatArguments = null;
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context()");
        Map<ValueArgument, JsExpression> argsToJsExpr = this.translateUnresolvedArguments(translationContext, this.resolvedCall);
        KotlinType varargElementType = null;
        for (ValueParameterDescriptor parameterDescriptor : valueParameters2) {
            ResolvedValueArgument actualArgument = valueArgumentsByIndex.get(parameterDescriptor.getIndex());
            if (actualArgument instanceof VarargValueArgument) {
                JsExpression it;
                JsExpression jsExpression;
                boolean bl;
                List<ValueArgument> arguments2;
                Intrinsics.checkExpressionValueIsNotNull(actualArgument.getArguments(), (String)"actualArgument.getArguments()");
                if (!hasSpreadOperator) {
                    boolean bl2;
                    block26: {
                        Iterable $this$any$iv = arguments2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                ValueArgument it2 = (ValueArgument)element$iv;
                                boolean bl3 = false;
                                if (!(it2.getSpreadElement() != null)) continue;
                                bl2 = true;
                                break block26;
                            }
                            bl2 = false;
                        }
                    }
                    hasSpreadOperator = bl2;
                }
                ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameterDescriptor");
                if (valueParameterDescriptor.getOriginal().getVarargElementType() == null) {
                    Intrinsics.throwNpe();
                }
                if (hasSpreadOperator) {
                    if (this.isNativeFunctionCall) {
                        List list4;
                        argsBeforeVararg = result2;
                        boolean bl4 = false;
                        result2 = list4 = (List)new ArrayList();
                        concatArguments = this.prepareConcatArguments(arguments2, CallArgumentTranslator.Companion.translateResolvedArgument(actualArgument, argsToJsExpr), null);
                        continue;
                    }
                    if (this.translateVarargArgument(actualArgument, argsToJsExpr, ((VarargValueArgument)actualArgument).getArguments().size() > 1, varargElementType) != null) {
                        bl = false;
                        boolean bl5 = false;
                        it = jsExpression;
                        boolean bl6 = false;
                        result2.add(it);
                    }
                    continue;
                }
                if (this.isNativeFunctionCall) {
                    result2.addAll(CallArgumentTranslator.Companion.translateResolvedArgument(actualArgument, argsToJsExpr));
                    continue;
                }
                if (this.translateVarargArgument(actualArgument, argsToJsExpr, true, varargElementType) == null) continue;
                bl = false;
                boolean bl7 = false;
                it = jsExpression;
                boolean bl8 = false;
                result2.add(it);
                continue;
            }
            ResolvedValueArgument resolvedValueArgument = actualArgument;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"actualArgument");
            result2.addAll(CallArgumentTranslator.Companion.translateResolvedArgument(resolvedValueArgument, argsToJsExpr));
        }
        if (this.isNativeFunctionCall && hasSpreadOperator) {
            boolean parameterDescriptor = argsBeforeVararg != null;
            boolean bl = false;
            if (_Assertions.ENABLED && !parameterDescriptor) {
                boolean $i$a$-assert-CallArgumentTranslator$translate$62 = false;
                String $i$a$-assert-CallArgumentTranslator$translate$62 = "argsBeforeVararg should not be null";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$translate$62));
            }
            parameterDescriptor = concatArguments != null;
            bl = false;
            if (_Assertions.ENABLED && !parameterDescriptor) {
                boolean bl9 = false;
                String string = "concatArguments should not be null";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (!result2.isEmpty()) {
                List<JsExpression> list5 = concatArguments;
                if (list5 == null) {
                    Intrinsics.throwNpe();
                }
                list5.add(this.toArray(null, result2));
            }
            List list6 = argsBeforeVararg;
            if (list6 == null) {
                Intrinsics.throwNpe();
            }
            if (!list6.isEmpty()) {
                List<JsExpression> list7 = concatArguments;
                if (list7 == null) {
                    Intrinsics.throwNpe();
                }
                list7.add(0, this.toArray(null, argsBeforeVararg));
            }
            Object[] objectArray = new JsExpression[1];
            List<JsExpression> list8 = concatArguments;
            if (list8 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[0] = CallArgumentTranslator.Companion.concatArgumentsIfNeeded(list8, varargElementType, true);
            result2 = CollectionsKt.mutableListOf((Object[])objectArray);
            if (this.receiver != null) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(this.receiver);
                JsNameRef jsNameRef = cachedReceiver.reference();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"cachedReceiver.reference()");
                result2.add(0, jsNameRef);
            } else {
                Object obj2 = this.resolvedCall.getResultingDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(obj2, (String)"resolvedCall.resultingDescriptor");
                if (DescriptorUtils.isObject(obj2.getContainingDeclaration())) {
                    TranslationContext translationContext2 = this.context();
                    Object obj3 = this.resolvedCall.getResultingDescriptor();
                    Intrinsics.checkExpressionValueIsNotNull(obj3, (String)"resolvedCall.resultingDescriptor");
                    cachedReceiver = translationContext2.getOrDeclareTemporaryConstVariable(ReferenceTranslator.translateAsValueReference(obj3.getContainingDeclaration(), this.context()));
                    JsNameRef jsNameRef = cachedReceiver.reference();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"cachedReceiver.reference()");
                    result2.add(0, jsNameRef);
                } else {
                    result2.add(0, new JsNullLiteral());
                }
            }
        }
        if ((callableDescriptor = this.resolvedCall.getResultingDescriptor()) instanceof FunctionDescriptor && ((FunctionDescriptor)callableDescriptor).isSuspend()) {
            JsExpression jsExpression = TranslationUtils.translateContinuationArgument(this.context());
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"TranslationUtils.transla\u2026uationArgument(context())");
            result2.add(jsExpression);
        }
        this.removeLastUndefinedArguments(result2);
        return new ArgumentsInfo(result2, hasSpreadOperator, cachedReceiver, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ValueArgument, JsExpression> translateUnresolvedArguments(TranslationContext context2, ResolvedCall<?> resolvedCall2) {
        boolean bl;
        boolean argumentsAreOrdered;
        ValueArgument arg;
        Map $this$associateTo$iv$iv;
        Object destination$iv$iv;
        Map result2;
        Map argumentContexts;
        block26: {
            boolean bl2;
            block25: {
                Object element$iv$iv2;
                void $this$flatMapTo$iv$iv;
                Iterable $this$associateTo$iv$iv2;
                void $this$associateTo$iv$iv3;
                Object $dstr$param$arg;
                void $this$associateTo$iv$iv4;
                Collection<Object> destination$iv$iv2;
                Object $this$map$iv;
                void $this$flatMapTo$iv$iv2;
                Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(map2, (String)"resolvedCall.valueArguments");
                Map<ValueParameterDescriptor, ResolvedValueArgument> $this$flatMap$iv = map2;
                boolean $i$f$flatMap = false;
                Map<ValueParameterDescriptor, ResolvedValueArgument> map3 = $this$flatMap$iv;
                Iterable destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                void var9_17 = $this$flatMapTo$iv$iv2;
                boolean bl3 = false;
                Iterator iterator2 = var9_17.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void $this$mapTo$iv$iv;
                    ResolvedValueArgument args;
                    Map.Entry entry;
                    Map.Entry $dstr$param$args = entry = iterator2.next();
                    boolean bl4 = false;
                    Map.Entry entry2 = $dstr$param$args;
                    boolean bl5 = false;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)entry2.getKey();
                    entry2 = $dstr$param$args;
                    bl5 = false;
                    ResolvedValueArgument resolvedValueArgument = args = (ResolvedValueArgument)entry2.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"args");
                    List<ValueArgument> list2 = resolvedValueArgument.getArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"args.arguments");
                    $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        void param;
                        ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl6 = false;
                        Pair pair2 = TuplesKt.to((Object)param, (Object)it);
                        collection.add(pair2);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                Iterable $this$associate$iv = (List)destination$iv$iv3;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                destination$iv$iv3 = $this$associate$iv;
                Object destination$iv$iv4 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv3 : $this$associateTo$iv$iv4) {
                    void param;
                    Map map4 = destination$iv$iv4;
                    $dstr$param$arg = (Pair)element$iv$iv3;
                    boolean bl7 = false;
                    $this$map$iv = (ValueParameterDescriptor)$dstr$param$arg.component1();
                    ValueArgument arg2 = (ValueArgument)$dstr$param$arg.component2();
                    $dstr$param$arg = TuplesKt.to((Object)arg2, (Object)param);
                    bl7 = false;
                    map4.put($dstr$param$arg.getFirst(), $dstr$param$arg.getSecond());
                }
                Map argsToParameters = destination$iv$iv4;
                Call call2 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
                List<? extends ValueArgument> list3 = call2.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"resolvedCall.call.valueArguments");
                Iterable $this$associate$iv2 = list3;
                boolean $i$f$associate2 = false;
                int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
                destination$iv$iv4 = $this$associate$iv2;
                Object destination$iv$iv5 = new LinkedHashMap(capacity$iv2);
                boolean $i$f$associateTo2 = false;
                for (Object e : $this$associateTo$iv$iv3) {
                    $dstr$param$arg = destination$iv$iv5;
                    ValueArgument it = (ValueArgument)e;
                    boolean bl8 = false;
                    it = TuplesKt.to((Object)it, (Object)context2.innerBlock());
                    bl8 = false;
                    $dstr$param$arg.put(it.getFirst(), it.getSecond());
                }
                argumentContexts = destination$iv$iv5;
                Call call3 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)call3, (String)"resolvedCall.call");
                List<? extends ValueArgument> list4 = call3.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"resolvedCall.call.valueArguments");
                Iterable $this$associate$iv3 = list4;
                boolean $i$f$associate2232 = false;
                int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv3, (int)10)), (int)16);
                destination$iv$iv5 = $this$associate$iv3;
                Map destination$iv$iv6 = new LinkedHashMap(capacity$iv3);
                boolean $i$f$associateTo3 = false;
                for (Object element$iv$iv4 : $this$associateTo$iv$iv2) {
                    JsExpression argJs;
                    KotlinType kotlinType;
                    boolean isLambda2;
                    Map it = destination$iv$iv6;
                    ValueArgument arg232 = (ValueArgument)element$iv$iv4;
                    boolean bl9 = false;
                    Object v = argumentContexts.get(arg232);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(v, (String)"argumentContexts[arg]!!");
                    TranslationContext argumentContext = (TranslationContext)v;
                    KtExpression parenthisedArgumentExpression = arg232.getArgumentExpression();
                    Object v2 = argsToParameters.get(arg232);
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    ValueParameterDescriptor param = ((ValueParameterDescriptor)v2).getOriginal();
                    destination$iv$iv2 = resolvedCall2.getResultingDescriptor();
                    boolean $i$f$mapTo = false;
                    boolean bl6 = false;
                    Collection<Object> it2 = destination$iv$iv2;
                    boolean bl11 = false;
                    Collection<Object> collection = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"it");
                    boolean bl7 = isLambda2 = FunctionTypesKt.getFunctionalClassKind((DeclarationDescriptor)((Object)collection)) != null || it2 instanceof FunctionInvokeDescriptor;
                    if (!isLambda2) {
                        kotlinType = param.getVarargElementType();
                        if (kotlinType == null) {
                            KotlinType kotlinType2 = param.getType();
                            kotlinType = kotlinType2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"param.type");
                        }
                    } else {
                        SimpleType simpleType2 = context2.getCurrentModule().getBuiltIns().getAnyType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.currentModule.builtIns.anyType");
                        kotlinType = simpleType2;
                    }
                    KotlinType parameterType = kotlinType;
                    KtExpression ktExpression = parenthisedArgumentExpression;
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)Translation.translateAsExpression(ktExpression, argumentContext), (String)"Translation.translateAsE\u2026ssion!!, argumentContext)");
                    if (!ArgumentsUtilsKt.isVararg(param) || arg232.getSpreadElement() == null) {
                        JsExpression jsExpression = TranslationUtils.coerce(context2, argJs, parameterType);
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"TranslationUtils.coerce(\u2026xt, argJs, parameterType)");
                        argJs = jsExpression;
                    }
                    Pair pair3 = TuplesKt.to((Object)arg232, (Object)argJs);
                    boolean arg232 = false;
                    it.put(pair3.getFirst(), pair3.getSecond());
                }
                result2 = destination$iv$iv6;
                List $i$f$associate2232 = resolvedCall2.getValueArgumentsByIndex();
                capacity$iv3 = 0;
                List list5 = $i$f$associate2232;
                if (list5 == null) {
                    list5 = CollectionsKt.emptyList();
                }
                Iterable $this$flatMap$iv2 = list5;
                boolean $i$f$flatMap2 = false;
                $this$associateTo$iv$iv2 = $this$flatMap$iv2;
                Iterable destination$iv$iv7 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                    ResolvedValueArgument it = (ResolvedValueArgument)element$iv$iv2;
                    boolean bl13 = false;
                    ResolvedValueArgument resolvedValueArgument = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"it");
                    Iterable list$iv$iv = resolvedValueArgument.getArguments();
                    CollectionsKt.addAll((Collection)destination$iv$iv7, (Iterable)list$iv$iv);
                }
                Iterable $this$associate$iv4 = CollectionsKt.withIndex((Iterable)((List)destination$iv$iv7));
                boolean $i$f$associate3 = false;
                int capacity$iv4 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv4, (int)10)), (int)16);
                destination$iv$iv7 = $this$associate$iv4;
                destination$iv$iv = new LinkedHashMap(capacity$iv4);
                boolean bl8 = false;
                element$iv$iv2 = $this$associateTo$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    void index2;
                    Object element$iv$iv5 = element$iv$iv2.next();
                    Map bl13 = destination$iv$iv;
                    IndexedValue $dstr$index$arg = (IndexedValue)element$iv$iv5;
                    boolean bl14 = false;
                    int parenthisedArgumentExpression = $dstr$index$arg.component1();
                    arg = (ValueArgument)$dstr$index$arg.component2();
                    $dstr$index$arg = TuplesKt.to((Object)arg, (Object)((int)index2));
                    bl14 = false;
                    bl13.put($dstr$index$arg.getFirst(), $dstr$index$arg.getSecond());
                }
                Map resolvedOrder = destination$iv$iv;
                Call call4 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"resolvedCall.call");
                List<? extends ValueArgument> list6 = call4.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list6, (String)"resolvedCall.call.valueArguments");
                Iterable $this$none$iv = CollectionsKt.withIndex((Iterable)list6);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        void index3;
                        IndexedValue indexedValue = (IndexedValue)element$iv;
                        boolean bl15 = false;
                        int element$iv$iv5 = indexedValue.component1();
                        ValueArgument arg3 = (ValueArgument)indexedValue.component2();
                        Integer n = (Integer)resolvedOrder.get(arg3);
                        if (!(n == null || n.intValue() != index3)) continue;
                        bl2 = false;
                        break block25;
                    }
                    bl2 = true;
                }
            }
            argumentsAreOrdered = bl2;
            Iterable $this$any$iv = argumentContexts.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TranslationContext translationContext = (TranslationContext)element$iv;
                    boolean bl16 = false;
                    if (!(!translationContext.currentBlockIsEmpty())) continue;
                    bl = true;
                    break block26;
                }
                bl = false;
            }
        }
        if (bl || !argumentsAreOrdered) {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = result2;
            boolean $i$f$map = false;
            $this$associateTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean bl9 = false;
            void bl16 = $this$mapTo$iv$iv;
            boolean bl10 = false;
            Iterator iterator3 = bl16.entrySet().iterator();
            while (iterator3.hasNext()) {
                void arg4;
                void $dstr$arg$expr;
                Map.Entry item$iv$iv;
                Map.Entry bl14 = item$iv$iv = iterator3.next();
                Object object = destination$iv$iv;
                boolean bl18 = false;
                arg = $dstr$arg$expr;
                boolean bl11 = false;
                ValueArgument argJs = (ValueArgument)arg.getKey();
                arg = $dstr$arg$expr;
                bl11 = false;
                JsExpression expr2 = (JsExpression)arg.getValue();
                Object v = argumentContexts.get(arg4);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"argumentContexts[arg]!!");
                TranslationContext argumentContext = (TranslationContext)v;
                Pair pair4 = TuplesKt.to((Object)arg4, (Object)argumentContext.cacheExpressionIfNeeded(expr2));
                object.add(pair4);
            }
            result2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
        Iterable $this$forEach$iv = argumentContexts.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TranslationContext translationContext = (TranslationContext)element$iv;
            boolean bl20 = false;
            context2.moveVarsFrom(translationContext);
            context2.addStatementsToCurrentBlockFrom(translationContext);
        }
        return result2;
    }

    private final JsExpression wrapInUArray(@NotNull JsExpression $this$wrapInUArray, KotlinType elementType) {
        JsExpression jsExpression;
        PrimitiveType primitiveType = ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(elementType);
        if (primitiveType != null) {
            PrimitiveType primitiveType2 = primitiveType;
            boolean bl = false;
            boolean bl2 = false;
            PrimitiveType primitiveType3 = primitiveType2;
            boolean bl3 = false;
            ModuleDescriptor moduleDescriptor = this.context.getCurrentModule();
            FqName fqName2 = new FqNameUnsafe("kotlin").toSafe();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqNameUnsafe(\"kotlin\").toSafe()");
            MemberScope kotlinMemberScope = moduleDescriptor.getPackage(fqName2).getMemberScope();
            ClassDescriptor classDescriptor2 = this.typeToUTypeArray.computeIfAbsent(primitiveType3, new Function<PrimitiveType, ClassDescriptor>(primitiveType3, kotlinMemberScope){
                final /* synthetic */ PrimitiveType $primitiveType;
                final /* synthetic */ MemberScope $kotlinMemberScope;

                @NotNull
                public final ClassDescriptor apply(@NotNull PrimitiveType it) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    Name name2 = Name.identifier("" + 'U' + this.$primitiveType.getTypeName() + "Array");
                    Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"U${primitiveType.typeName}Array\")");
                    Name className2 = name2;
                    ClassifierDescriptor classifierDescriptor = this.$kotlinMemberScope.getContributedClassifier(className2, NoLookupLocation.FROM_BACKEND);
                    if (classifierDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    }
                    return (ClassDescriptor)classifierDescriptor;
                }
                {
                    this.$primitiveType = primitiveType;
                    this.$kotlinMemberScope = memberScope2;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"typeToUTypeArray.compute\u2026sDescriptor\n            }");
            ClassDescriptor classDescriptor3 = classDescriptor2;
            jsExpression = new JsNew(ReferenceTranslator.translateAsTypeReference(classDescriptor3, this.context), CollectionsKt.listOf((Object)$this$wrapInUArray));
        } else {
            jsExpression = $this$wrapInUArray;
        }
        return jsExpression;
    }

    private final JsExpression translateVarargArgument(ResolvedValueArgument resolvedArgument, Map<ValueArgument, ? extends JsExpression> translatedArgs, boolean shouldWrapVarargInArray, KotlinType varargElementType) {
        JsExpression jsExpression;
        List<ValueArgument> list2 = resolvedArgument.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedArgument.arguments");
        List<ValueArgument> arguments2 = list2;
        if (arguments2.isEmpty()) {
            if (shouldWrapVarargInArray) {
                KotlinType kotlinType = varargElementType;
                CallArgumentTranslator callArgumentTranslator = this;
                CallArgumentTranslator callArgumentTranslator2 = this;
                boolean bl = false;
                List list3 = CollectionsKt.emptyList();
                return callArgumentTranslator2.wrapInUArray(callArgumentTranslator.toArray(kotlinType, list3), varargElementType);
            }
            return null;
        }
        List list4 = CallArgumentTranslator.Companion.translateResolvedArgument(resolvedArgument, translatedArgs);
        CallArgumentTranslator callArgumentTranslator = this;
        if (shouldWrapVarargInArray) {
            JsExpression concatExpression;
            List<JsExpression> concatArguments = this.prepareConcatArguments(arguments2, list4, varargElementType);
            jsExpression = concatExpression = CallArgumentTranslator.Companion.concatArgumentsIfNeeded(concatArguments, varargElementType, false);
        } else {
            JsExpression jsExpression2;
            PrimitiveType primitiveType = ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType);
            if (primitiveType != null) {
                PrimitiveType primitiveType2 = primitiveType;
                CallArgumentTranslator callArgumentTranslator3 = callArgumentTranslator;
                boolean bl = false;
                boolean bl2 = false;
                PrimitiveType $noName_0 = primitiveType2;
                boolean bl3 = false;
                JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef("unbox", (JsExpression)list4.get(0)), new JsExpression[0]);
                callArgumentTranslator = callArgumentTranslator3;
                jsExpression2 = jsInvocation;
            } else {
                jsExpression2 = (JsExpression)list4.get(0);
            }
            JsExpression arg = jsExpression2;
            JsInvocation jsInvocation = JsAstUtils.invokeMethod(arg, "slice", new JsExpression[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsInvocation, (String)"JsAstUtils.invokeMethod(arg, \"slice\")");
            jsExpression = jsInvocation;
        }
        return callArgumentTranslator.wrapInUArray(jsExpression, varargElementType);
    }

    private final JsExpression toArray(KotlinType varargElementType, List<? extends JsExpression> elements2) {
        JsArrayLiteral jsArrayLiteral = new JsArrayLiteral(elements2);
        boolean bl = false;
        boolean bl2 = false;
        JsArrayLiteral $this$apply = jsArrayLiteral;
        boolean bl3 = false;
        MetadataProperties.setSideEffects($this$apply, SideEffectKind.PURE);
        JsArrayLiteral argument2 = jsArrayLiteral;
        if (varargElementType == null) {
            return argument2;
        }
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context()");
        return ArrayFIF.INSTANCE.castOrCreatePrimitiveArray(translationContext, varargElementType, argument2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsExpression> prepareConcatArguments(List<? extends ValueArgument> arguments2, List<? extends JsExpression> list2, KotlinType varargElementType) {
        Collection collection = arguments2;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32 = false;
            String $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32 = "arguments.size should not be 0";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32));
        }
        bl2 = arguments2.size() == list2.size();
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42 = false;
            String $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42 = "arguments.size: " + arguments2.size() + " != list.size: " + list2.size();
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42));
        }
        bl = false;
        List concatArguments = new ArrayList();
        boolean $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42 = false;
        List lastArrayContent = new ArrayList();
        int size = arguments2.size();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void index2;
            ValueArgument valueArgument = arguments2.get((int)index2);
            JsExpression expressionArgument = list2.get((int)index2);
            if (valueArgument.getSpreadElement() != null) {
                if (lastArrayContent.size() > 0) {
                    concatArguments.add(this.toArray(varargElementType, lastArrayContent));
                    boolean bl3 = false;
                    lastArrayContent = new ArrayList();
                }
                JsExpression e = varargElementType != null && ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType) != null ? (JsExpression)new JsInvocation((JsExpression)new JsNameRef("unbox", expressionArgument), new JsExpression[0]) : expressionArgument;
                concatArguments.add(e);
            } else {
                lastArrayContent.add(expressionArgument);
            }
            ++index2;
        }
        if (lastArrayContent.size() > 0) {
            concatArguments.add(this.toArray(varargElementType, lastArrayContent));
        }
        return concatArguments;
    }

    private CallArgumentTranslator(ResolvedCall<?> resolvedCall2, JsExpression receiver2, TranslationContext context2) {
        super(context2);
        Map map2;
        this.resolvedCall = resolvedCall2;
        this.receiver = receiver2;
        this.context = context2;
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject((DeclarationDescriptor)this.resolvedCall.getCandidateDescriptor());
        CallArgumentTranslator callArgumentTranslator = this;
        boolean bl = false;
        callArgumentTranslator.typeToUTypeArray = map2 = (Map)new LinkedHashMap();
    }

    public /* synthetic */ CallArgumentTranslator(ResolvedCall resolvedCall2, JsExpression receiver2, TranslationContext context2, DefaultConstructorMarker $constructor_marker) {
        this(resolvedCall2, receiver2, context2);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver2, @NotNull TranslationContext context2) {
        return Companion.translate(resolvedCall2, receiver2, context2);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver2, @NotNull TranslationContext context2, @NotNull JsBlock block) {
        return Companion.translate(resolvedCall2, receiver2, context2, block);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "", "valueArguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "hasSpreadOperator", "", "cachedReceiver", "Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "reifiedArguments", "(Ljava/util/List;ZLorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;Ljava/util/List;)V", "getCachedReceiver", "()Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "getHasSpreadOperator", "()Z", "getReifiedArguments", "()Ljava/util/List;", "translateArguments", "getTranslateArguments", "getValueArguments", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "js.translator"})
    public static final class ArgumentsInfo {
        @NotNull
        private final List<JsExpression> valueArguments;
        private final boolean hasSpreadOperator;
        @Nullable
        private final TemporaryConstVariable cachedReceiver;
        @NotNull
        private final List<JsExpression> reifiedArguments;

        @NotNull
        public final List<JsExpression> getTranslateArguments() {
            return CollectionsKt.plus((Collection)this.reifiedArguments, (Iterable)this.valueArguments);
        }

        @NotNull
        public final List<JsExpression> getValueArguments() {
            return this.valueArguments;
        }

        public final boolean getHasSpreadOperator() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable getCachedReceiver() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> getReifiedArguments() {
            return this.reifiedArguments;
        }

        public ArgumentsInfo(@NotNull List<? extends JsExpression> valueArguments2, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkParameterIsNotNull(valueArguments2, (String)"valueArguments");
            Intrinsics.checkParameterIsNotNull(reifiedArguments, (String)"reifiedArguments");
            this.valueArguments = valueArguments2;
            this.hasSpreadOperator = hasSpreadOperator;
            this.cachedReceiver = cachedReceiver;
            this.reifiedArguments = reifiedArguments;
        }

        public /* synthetic */ ArgumentsInfo(List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                boolean bl2 = false;
                list3 = CollectionsKt.emptyList();
            }
            this(list2, bl, temporaryConstVariable, list3);
        }

        @NotNull
        public final List<JsExpression> component1() {
            return this.valueArguments;
        }

        public final boolean component2() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable component3() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> component4() {
            return this.reifiedArguments;
        }

        @NotNull
        public final ArgumentsInfo copy(@NotNull List<? extends JsExpression> valueArguments2, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkParameterIsNotNull(valueArguments2, (String)"valueArguments");
            Intrinsics.checkParameterIsNotNull(reifiedArguments, (String)"reifiedArguments");
            return new ArgumentsInfo(valueArguments2, hasSpreadOperator, cachedReceiver, reifiedArguments);
        }

        public static /* synthetic */ ArgumentsInfo copy$default(ArgumentsInfo argumentsInfo, List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = argumentsInfo.valueArguments;
            }
            if ((n & 2) != 0) {
                bl = argumentsInfo.hasSpreadOperator;
            }
            if ((n & 4) != 0) {
                temporaryConstVariable = argumentsInfo.cachedReceiver;
            }
            if ((n & 8) != 0) {
                list3 = argumentsInfo.reifiedArguments;
            }
            return argumentsInfo.copy(list2, bl, temporaryConstVariable, list3);
        }

        @NotNull
        public String toString() {
            return "ArgumentsInfo(valueArguments=" + this.valueArguments + ", hasSpreadOperator=" + this.hasSpreadOperator + ", cachedReceiver=" + this.cachedReceiver + ", reifiedArguments=" + this.reifiedArguments + ")";
        }

        public int hashCode() {
            List<JsExpression> list2 = this.valueArguments;
            int n = (list2 != null ? ((Object)list2).hashCode() : 0) * 31;
            int n2 = this.hasSpreadOperator ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            TemporaryConstVariable temporaryConstVariable = this.cachedReceiver;
            List<JsExpression> list3 = this.reifiedArguments;
            return ((n + n2) * 31 + (temporaryConstVariable != null ? temporaryConstVariable.hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ArgumentsInfo)) break block3;
                    ArgumentsInfo argumentsInfo = (ArgumentsInfo)object;
                    if (!Intrinsics.areEqual(this.valueArguments, argumentsInfo.valueArguments) || this.hasSpreadOperator != argumentsInfo.hasSpreadOperator || !Intrinsics.areEqual((Object)this.cachedReceiver, (Object)argumentsInfo.cachedReceiver) || !Intrinsics.areEqual(this.reifiedArguments, argumentsInfo.reifiedArguments)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J.\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$Companion;", "", "()V", "concatArgumentsIfNeeded", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "concatArguments", "", "varargElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isMixed", "", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "block", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "translateResolvedArgument", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "translatedArgs", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "js.translator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver2, @NotNull TranslationContext context2) {
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            JsBlock jsBlock = context2.dynamicContext().jsBlock();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"context.dynamicContext().jsBlock()");
            return this.translate(resolvedCall2, receiver2, context2, jsBlock);
        }

        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver2, @NotNull TranslationContext context2, @NotNull JsBlock block) {
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            TranslationContext translationContext = context2.innerBlock(block);
            Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context.innerBlock(block)");
            TranslationContext innerContext = translationContext;
            CallArgumentTranslator argumentTranslator = new CallArgumentTranslator(resolvedCall2, receiver2, innerContext, null);
            ArgumentsInfo result2 = argumentTranslator.translate();
            context2.moveVarsFrom(innerContext);
            Object callDescriptor2 = resolvedCall2.getCandidateDescriptor();
            if (CallExpressionTranslator.shouldBeInlined(callDescriptor2)) {
                Map<TypeParameterDescriptor, KotlinType> map2 = resolvedCall2.getTypeArguments();
                Intrinsics.checkExpressionValueIsNotNull(map2, (String)"resolvedCall.typeArguments");
                Map<TypeParameterDescriptor, KotlinType> typeArgs = map2;
                return ArgumentsInfo.copy$default(result2, null, false, null, CallArgumentTranslatorKt.buildReifiedTypeArgs(typeArgs, context2), 7, null);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<JsExpression> translateResolvedArgument(ResolvedValueArgument resolvedArgument, Map<ValueArgument, ? extends JsExpression> translatedArgs) {
            void $this$mapTo$iv$iv;
            if (resolvedArgument instanceof DefaultValueArgument) {
                return CollectionsKt.listOf((Object)Namer.getUndefinedExpression());
            }
            List<ValueArgument> list2 = resolvedArgument.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedArgument.arguments");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsExpression jsExpression;
                void it;
                ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (translatedArgs.get(it) == null) {
                    Intrinsics.throwNpe();
                }
                collection.add(jsExpression);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final JsExpression concatArgumentsIfNeeded(List<? extends JsExpression> concatArguments, KotlinType varargElementType, boolean isMixed) {
            JsExpression jsExpression;
            Collection collection = concatArguments;
            boolean bl = false;
            boolean bl2 = !collection.isEmpty();
            bl = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-CallArgumentTranslator$Companion$concatArgumentsIfNeeded$22 = false;
                String $i$a$-assert-CallArgumentTranslator$Companion$concatArgumentsIfNeeded$22 = "concatArguments.size should not be 0";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$Companion$concatArgumentsIfNeeded$22));
            }
            if (concatArguments.size() > 1) {
                JsInvocation jsInvocation;
                if (varargElementType != null && (TypeUtilsKt.isPrimitiveNumberType(varargElementType) || ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType) != null)) {
                    void $this$toTypedArray$iv;
                    String method = isMixed ? "arrayConcat" : "primitiveArrayConcat";
                    SpreadBuilder spreadBuilder2 = new SpreadBuilder(2);
                    spreadBuilder2.add((Object)concatArguments.get(0));
                    Collection collection2 = concatArguments.subList(1, concatArguments.size());
                    SpreadBuilder spreadBuilder3 = spreadBuilder2;
                    SpreadBuilder spreadBuilder4 = spreadBuilder2;
                    String string = method;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    JsExpression[] jsExpressionArray = thisCollection$iv.toArray(new JsExpression[0]);
                    if (jsExpressionArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    JsExpression[] jsExpressionArray2 = jsExpressionArray;
                    SpreadBuilder spreadBuilder5 = spreadBuilder4;
                    spreadBuilder3.addSpread((Object)jsExpressionArray2);
                    jsInvocation = JsAstUtils.invokeKotlinFunction(string, (JsExpression[])spreadBuilder5.toArray((Object[])new JsExpression[spreadBuilder5.size()]));
                } else {
                    jsInvocation = new JsInvocation((JsExpression)new JsNameRef("concat", concatArguments.get(0)), concatArguments.subList(1, concatArguments.size()));
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)jsInvocation, (String)"if (varargElementType !=\u2026.size))\n                }");
                jsExpression = jsInvocation;
            } else {
                jsExpression = concatArguments.get(0);
            }
            return jsExpression;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

