/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.protobuf.LiteralByteString;
import org.jetbrains.kotlin.protobuf.Utf8;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Internal {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(EMPTY_BYTE_ARRAY);

    public static String stringDefaultValue(String bytes2) {
        try {
            return new String(bytes2.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support a standard character set.", e);
        }
    }

    public static ByteString bytesDefaultValue(String bytes2) {
        try {
            return ByteString.copyFrom(bytes2.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support a standard character set.", e);
        }
    }

    public static byte[] byteArrayDefaultValue(String bytes2) {
        try {
            return bytes2.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java VM does not support a standard character set.", e);
        }
    }

    public static ByteBuffer byteBufferDefaultValue(String bytes2) {
        return ByteBuffer.wrap(Internal.byteArrayDefaultValue(bytes2));
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer source) {
        ByteBuffer temp = source.duplicate();
        temp.clear();
        ByteBuffer result2 = ByteBuffer.allocate(temp.capacity());
        result2.put(temp);
        result2.clear();
        return result2;
    }

    public static boolean isValidUtf8(ByteString byteString) {
        return byteString.isValidUtf8();
    }

    public static boolean isValidUtf8(byte[] byteArray) {
        return Utf8.isValidUtf8(byteArray);
    }

    public static byte[] toByteArray(String value2) {
        try {
            return value2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    public static String toStringUtf8(byte[] bytes2) {
        try {
            return new String(bytes2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    public static int hashLong(long n) {
        return (int)(n ^ n >>> 32);
    }

    public static int hashBoolean(boolean b) {
        return b ? 1231 : 1237;
    }

    public static int hashEnum(EnumLite e) {
        return e.getNumber();
    }

    public static int hashEnumList(List<? extends EnumLite> list2) {
        int hash = 1;
        for (EnumLite enumLite : list2) {
            hash = 31 * hash + Internal.hashEnum(enumLite);
        }
        return hash;
    }

    public static boolean equals(List<byte[]> a, List<byte[]> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i2 = 0; i2 < a.size(); ++i2) {
            if (Arrays.equals(a.get(i2), b.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(List<byte[]> list2) {
        int hash = 1;
        for (byte[] bytes2 : list2) {
            hash = 31 * hash + Internal.hashCode(bytes2);
        }
        return hash;
    }

    public static int hashCode(byte[] bytes2) {
        return LiteralByteString.hashCode(bytes2);
    }

    public static boolean equalsByteBuffer(ByteBuffer a, ByteBuffer b) {
        if (a.capacity() != b.capacity()) {
            return false;
        }
        return a.duplicate().clear().equals(b.duplicate().clear());
    }

    public static boolean equalsByteBuffer(List<ByteBuffer> a, List<ByteBuffer> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i2 = 0; i2 < a.size(); ++i2) {
            if (Internal.equalsByteBuffer(a.get(i2), b.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static int hashCodeByteBuffer(List<ByteBuffer> list2) {
        int hash = 1;
        for (ByteBuffer bytes2 : list2) {
            hash = 31 * hash + Internal.hashCodeByteBuffer(bytes2);
        }
        return hash;
    }

    public static int hashCodeByteBuffer(ByteBuffer bytes2) {
        if (bytes2.hasArray()) {
            int h = LiteralByteString.hashCode(bytes2.capacity(), bytes2.array(), bytes2.arrayOffset(), bytes2.capacity());
            return h == 0 ? 1 : h;
        }
        int bufferSize = bytes2.capacity() > 4096 ? 4096 : bytes2.capacity();
        byte[] buffer = new byte[bufferSize];
        ByteBuffer duplicated = bytes2.duplicate();
        duplicated.clear();
        int h = bytes2.capacity();
        while (duplicated.remaining() > 0) {
            int length = duplicated.remaining() <= bufferSize ? duplicated.remaining() : bufferSize;
            duplicated.get(buffer, 0, length);
            h = LiteralByteString.hashCode(h, buffer, 0, length);
        }
        return h == 0 ? 1 : h;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EnumLiteMap<T extends EnumLite> {
        public T findValueByNumber(int var1);
    }

    public static interface EnumLite {
        public int getNumber();
    }
}

