/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.PsiElementPlaceholderArgumentType;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/psi/PsiChildRangeArgumentType;", "Lorg/jetbrains/kotlin/psi/PsiElementPlaceholderArgumentType;", "Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;", "Lorg/jetbrains/kotlin/psi/KtElement;", "()V", "replacePlaceholderElement", "placeholder", "argument", "reformat", "", "psi"})
final class PsiChildRangeArgumentType
extends PsiElementPlaceholderArgumentType<PsiChildRange, KtElement> {
    public static final PsiChildRangeArgumentType INSTANCE;

    @Override
    @NotNull
    public PsiChildRange replacePlaceholderElement(@NotNull KtElement placeholder, @NotNull PsiChildRange argument2, boolean reformat) {
        PsiChildRange psiChildRange;
        Intrinsics.checkParameterIsNotNull((Object)placeholder, (String)"placeholder");
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        Project project2 = placeholder.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"placeholder.project");
        Project project3 = project2;
        if (!argument2.isEmpty()) {
            PsiElement psiElement2 = placeholder.getParent();
            PsiElement psiElement3 = argument2.getFirst();
            if (psiElement3 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement4 = argument2.getLast();
            if (psiElement4 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement first2 = psiElement2.addRangeBefore(psiElement3, psiElement4, (PsiElement)placeholder);
            PsiElement last = placeholder.getPrevSibling();
            placeholder.delete();
            if (reformat) {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project3);
                PsiElement psiElement5 = first2;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"first");
                ASTNode aSTNode = psiElement5.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"first.node");
                codeStyleManager.reformatNewlyAddedElement(aSTNode.getTreeParent(), first2.getNode());
                if (Intrinsics.areEqual((Object)last, (Object)first2) ^ true) {
                    PsiElement psiElement6 = last;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"last");
                    ASTNode aSTNode2 = psiElement6.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"last.node");
                    codeStyleManager.reformatNewlyAddedElement(aSTNode2.getTreeParent(), last.getNode());
                }
            }
            psiChildRange = new PsiChildRange(first2, last);
        } else {
            placeholder.delete();
            psiChildRange = PsiChildRange.Companion.getEMPTY();
        }
        return psiChildRange;
    }

    private PsiChildRangeArgumentType() {
        super(PsiChildRange.class, KtElement.class);
    }

    static {
        PsiChildRangeArgumentType psiChildRangeArgumentType;
        INSTANCE = psiChildRangeArgumentType = new PsiChildRangeArgumentType();
    }
}

