/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ContractNotAllowedCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ContractNotAllowedCallChecker
implements CallChecker {
    public static final ContractNotAllowedCallChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean inFunctionBodyBlock;
        FunctionDescriptor functionDescriptor2;
        Function1<String, Unit> $fun$contractNotAllowed$1;
        void hasErrors;
        KtElement callElement2;
        block20: {
            LexicalScope scope2;
            block19: {
                Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
                Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
                Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                if (!(reportOn instanceof KtElement)) {
                    return;
                }
                Object obj = resolvedCall2.getResultingDescriptor();
                if (!(obj instanceof FunctionDescriptor)) {
                    obj = null;
                }
                FunctionDescriptor functionDescriptor3 = (FunctionDescriptor)obj;
                if (functionDescriptor3 == null) {
                    return;
                }
                FunctionDescriptor descriptor2 = functionDescriptor3;
                if (!PsiContractsUtilsKt.isContractCallDescriptor(descriptor2)) {
                    return;
                }
                Call call2 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
                KtElement ktElement = call2.getCallElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"resolvedCall.call.callElement");
                callElement2 = ktElement;
                Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                booleanRef.element = false;
                $fun$contractNotAllowed$1 = new Function1<String, Unit>((Ref.BooleanRef)hasErrors, context2, reportOn){
                    final /* synthetic */ Ref.BooleanRef $hasErrors;
                    final /* synthetic */ CallCheckerContext $context;
                    final /* synthetic */ PsiElement $reportOn;

                    public final void invoke(@NotNull String message2) {
                        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                        this.$hasErrors.element = true;
                        this.$context.getTrace().report(Errors.CONTRACT_NOT_ALLOWED.on((KtElement)this.$reportOn, message2));
                    }
                    {
                        this.$hasErrors = booleanRef;
                        this.$context = callCheckerContext;
                        this.$reportOn = psiElement2;
                        super(1);
                    }
                };
                scope2 = context2.getScope();
                DeclarationDescriptor declarationDescriptor = scope2.getOwnerDescriptor();
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    declarationDescriptor = null;
                }
                if ((functionDescriptor2 = (FunctionDescriptor)declarationDescriptor) == null || functionDescriptor2 instanceof PropertyAccessorDescriptor) {
                    $fun$contractNotAllowed$1.invoke("Contracts are allowed only for functions");
                }
                inFunctionBodyBlock = true;
                if (!(scope2.getOwnerDescriptor().getContainingDeclaration() instanceof PackageFragmentDescriptor) || scope2.getKind() != LexicalScopeKind.CODE_BLOCK) break block19;
                HierarchicalScope hierarchicalScope = scope2.getParent();
                if (!(hierarchicalScope instanceof LexicalScope)) {
                    hierarchicalScope = null;
                }
                LexicalScope lexicalScope = (LexicalScope)hierarchicalScope;
                if ((lexicalScope != null ? lexicalScope.getKind() : null) == LexicalScopeKind.FUNCTION_INNER_SCOPE) break block20;
            }
            if (scope2.getKind() == LexicalScopeKind.FUNCTION_INNER_SCOPE) {
                $fun$contractNotAllowed$1.invoke("Contracts are allowed only in function body block");
                inFunctionBodyBlock = false;
            } else {
                $fun$contractNotAllowed$1.invoke("Contracts are allowed only for top-level functions");
            }
        }
        FunctionDescriptor functionDescriptor4 = functionDescriptor2;
        if (functionDescriptor4 != null) {
            if (functionDescriptor4.isOperator()) {
                $fun$contractNotAllowed$1.invoke("Contracts are not allowed for operator functions");
            }
        }
        FunctionDescriptor functionDescriptor5 = functionDescriptor2;
        if (functionDescriptor5 != null) {
            if (ModalityKt.isOverridable(functionDescriptor5)) {
                $fun$contractNotAllowed$1.invoke("Contracts are not allowed for open functions");
            }
        }
        if (!KtPsiUtilKt.isFirstStatement(callElement2) && inFunctionBodyBlock) {
            $fun$contractNotAllowed$1.invoke("Contract should be the first statement");
        }
        if (hasErrors.element) {
            context2.getTrace().record(BindingContext.CONTRACT_NOT_ALLOWED, callElement2, true);
        }
    }

    private ContractNotAllowedCallChecker() {
    }

    static {
        ContractNotAllowedCallChecker contractNotAllowedCallChecker;
        INSTANCE = contractNotAllowedCallChecker = new ContractNotAllowedCallChecker();
    }
}

