/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.capture.org.objectweb.asm.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import org.jetbrains.capture.org.objectweb.asm.ClassReader;
import org.jetbrains.capture.org.objectweb.asm.ClassVisitor;
import org.jetbrains.capture.org.objectweb.asm.ClassWriter;
import org.jetbrains.capture.org.objectweb.asm.Handle;
import org.jetbrains.capture.org.objectweb.asm.MethodVisitor;
import org.jetbrains.capture.org.objectweb.asm.Type;

public class Retrofitter {
    static final HashSet<String> API = new HashSet();
    static final HashMap<String, String> HIERARCHY = new HashMap();

    public static void main(String[] args) throws IOException {
        String line;
        File api = new File(args[0]);
        GZIPInputStream inputStream = new GZIPInputStream(new FileInputStream(api));
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(inputStream));
        while ((line = ((BufferedReader)reader).readLine()) != null) {
            if (line.startsWith("class")) {
                String className = line.substring(6, line.lastIndexOf(32));
                String superClassName = line.substring(line.lastIndexOf(32) + 1);
                HIERARCHY.put(className, superClassName);
                continue;
            }
            API.add(line);
        }
        File src = new File(args[1]);
        File dst = new File(args[2]);
        if (!Retrofitter.retrofit(src, dst)) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean retrofit(File src, File dst) throws IOException {
        if (src.isDirectory()) {
            boolean result = true;
            File[] files = src.listFiles();
            if (files == null) {
                throw new IOException("unable to read files of " + src);
            }
            for (int i = 0; i < files.length; ++i) {
                result &= Retrofitter.retrofit(files[i], new File(dst, files[i].getName()));
            }
            return result;
        }
        if (src.getName().endsWith(".class")) {
            if (!dst.exists() || dst.lastModified() < src.lastModified()) {
                ClassReader classReader = new ClassReader(new FileInputStream(src));
                ClassWriter classWriter = new ClassWriter(0);
                ClassVerifier classVerifier = new ClassVerifier(classWriter);
                classReader.accept(classVerifier, 0);
                if (!classVerifier.ok) {
                    return false;
                }
                if (!dst.getParentFile().exists() && !dst.getParentFile().mkdirs()) {
                    throw new IOException("Cannot create directory " + dst.getParentFile());
                }
                FileOutputStream os = new FileOutputStream(dst);
                try {
                    ((OutputStream)os).write(classWriter.toByteArray());
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            return true;
        }
        return true;
    }

    static class ClassVerifier
    extends ClassVisitor {
        String className;
        String currentMethodName;
        boolean ok = true;

        public ClassVerifier(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if ((version & 0xFFFF) > 49) {
                System.err.println("ERROR: " + name + " version is newer than 1.5");
                this.ok = false;
            }
            this.className = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.currentMethodName = name + desc;
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            return new MethodVisitor(262144, mv){

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    ClassVerifier.this.check(owner, name);
                    super.visitFieldInsn(opcode, owner, name, desc);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    ClassVerifier.this.check(owner, name + desc);
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }

                public void visitLdcInsn(Object cst) {
                    if (cst instanceof Type) {
                        int sort = ((Type)cst).getSort();
                        if (sort == 11) {
                            System.err.println("ERROR: ldc with a MethodType called in " + ClassVerifier.this.className + ' ' + ClassVerifier.this.currentMethodName + " is not available in JDK 1.5");
                            ClassVerifier.this.ok = false;
                        }
                    } else if (cst instanceof Handle) {
                        System.err.println("ERROR: ldc with a MethodHandle called in " + ClassVerifier.this.className + ' ' + ClassVerifier.this.currentMethodName + " is not available in JDK 1.5");
                        ClassVerifier.this.ok = false;
                    }
                    super.visitLdcInsn(cst);
                }

                public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
                    System.err.println("ERROR: invokedynamic called in " + ClassVerifier.this.className + ' ' + ClassVerifier.this.currentMethodName + " is not available in JDK 1.5");
                    ClassVerifier.this.ok = false;
                    super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
                }
            };
        }

        void check(String owner, String member) {
            if (owner.startsWith("java/")) {
                String o = owner;
                while (o != null) {
                    if (API.contains(o + ' ' + member)) {
                        return;
                    }
                    o = HIERARCHY.get(o);
                }
                System.err.println("ERROR: " + owner + ' ' + member + " called in " + this.className + ' ' + this.currentMethodName + " is not defined in the JDK 1.5 API");
                this.ok = false;
            }
        }
    }
}

