/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.substitutions;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a$\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"getCallableSubstitution", "", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeProjection;", "baseCallable", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "derivedCallable", "getCallableSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "getTypeSubstitution", "Ljava/util/LinkedHashMap;", "baseType", "Lorg/jetbrains/kotlin/types/KotlinType;", "derivedType", "getTypeSubstitutor", "ide-common"})
public final class SubstitutionUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final LinkedHashMap<TypeConstructor, TypeProjection> getTypeSubstitution(@NotNull KotlinType baseType, @NotNull KotlinType derivedType) {
        Intrinsics.checkParameterIsNotNull((Object)baseType, (String)"baseType");
        Intrinsics.checkParameterIsNotNull((Object)derivedType, (String)"derivedType");
        KotlinType kotlinType = TypeCheckingProcedure.findCorrespondingSupertype((KotlinType)derivedType, (KotlinType)baseType);
        if (kotlinType == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"TypeCheckingProcedure.fi\u2026 baseType) ?: return null");
        KotlinType substitutedType = kotlinType;
        LinkedHashMap<TypeConstructor, TypeProjection> substitution = new LinkedHashMap<TypeConstructor, TypeProjection>(substitutedType.getArguments().size());
        List list = baseType.getConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"baseType.constructor.parameters");
        for (Pair pair : CollectionsKt.zip((Iterable)list, (Iterable)substitutedType.getArguments())) {
            void param;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)pair.component1();
            TypeProjection arg = (TypeProjection)pair.component2();
            Map map = substitution;
            void v3 = param;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"param");
            TypeConstructor typeConstructor = v3.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor, (String)"param.typeConstructor");
            map.put(typeConstructor, arg);
        }
        return substitution;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Map<TypeConstructor, TypeProjection> getCallableSubstitution(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        Intrinsics.checkParameterIsNotNull((Object)baseCallable, (String)"baseCallable");
        Intrinsics.checkParameterIsNotNull((Object)derivedCallable, (String)"derivedCallable");
        DeclarationDescriptor declarationDescriptor = baseCallable.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor baseClass = classDescriptor;
        DeclarationDescriptor declarationDescriptor2 = derivedCallable.getContainingDeclaration();
        if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
            declarationDescriptor2 = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor2;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor derivedClass = classDescriptor2;
        SimpleType simpleType = baseClass.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType, (String)"baseClass.defaultType");
        KotlinType kotlinType = (KotlinType)simpleType;
        SimpleType simpleType2 = derivedClass.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"derivedClass.defaultType");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = SubstitutionUtilsKt.getTypeSubstitution(kotlinType, (KotlinType)simpleType2);
        if (linkedHashMap == null) {
            return null;
        }
        LinkedHashMap<TypeConstructor, TypeProjection> substitution = linkedHashMap;
        List list = baseCallable.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"baseCallable.typeParameters");
        Iterable iterable = list;
        List list2 = derivedCallable.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"derivedCallable.typeParameters");
        for (Pair pair : CollectionsKt.zip((Iterable)iterable, (Iterable)list2)) {
            void baseParam;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)pair.component1();
            TypeParameterDescriptor derivedParam = (TypeParameterDescriptor)pair.component2();
            Map map = substitution;
            void v12 = baseParam;
            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"baseParam");
            TypeConstructor typeConstructor = v12.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor, (String)"baseParam.typeConstructor");
            TypeParameterDescriptor typeParameterDescriptor2 = derivedParam;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor2, (String)"derivedParam");
            map.put(typeConstructor, new TypeProjectionImpl((KotlinType)typeParameterDescriptor2.getDefaultType()));
        }
        return substitution;
    }

    @Nullable
    public static final TypeSubstitutor getCallableSubstitutor(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        TypeSubstitutor typeSubstitutor;
        Intrinsics.checkParameterIsNotNull((Object)baseCallable, (String)"baseCallable");
        Intrinsics.checkParameterIsNotNull((Object)derivedCallable, (String)"derivedCallable");
        Map<TypeConstructor, TypeProjection> map = SubstitutionUtilsKt.getCallableSubstitution(baseCallable, derivedCallable);
        if (map != null) {
            Map<TypeConstructor, TypeProjection> map2 = map;
            boolean bl = false;
            boolean bl2 = false;
            Map<TypeConstructor, TypeProjection> it = map2;
            boolean bl3 = false;
            typeSubstitutor = TypeSubstitutor.create(it);
        } else {
            typeSubstitutor = null;
        }
        return typeSubstitutor;
    }

    @Nullable
    public static final TypeSubstitutor getTypeSubstitutor(@NotNull KotlinType baseType, @NotNull KotlinType derivedType) {
        TypeSubstitutor typeSubstitutor;
        Intrinsics.checkParameterIsNotNull((Object)baseType, (String)"baseType");
        Intrinsics.checkParameterIsNotNull((Object)derivedType, (String)"derivedType");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = SubstitutionUtilsKt.getTypeSubstitution(baseType, derivedType);
        if (linkedHashMap != null) {
            LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap2 = linkedHashMap;
            boolean bl = false;
            boolean bl2 = false;
            LinkedHashMap<TypeConstructor, TypeProjection> it = linkedHashMap2;
            boolean bl3 = false;
            typeSubstitutor = TypeSubstitutor.create((Map)it);
        } else {
            typeSubstitutor = null;
        }
        return typeSubstitutor;
    }
}

