/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.internal.GoodCodeRedVisitor;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrAccessibilityChecker;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyStaticTypeCheckVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyGoodCodeRedVisitor
implements GoodCodeRedVisitor {
    @Override
    @NotNull
    public PsiElementVisitor createVisitor(final ProblemsHolder holder) {
        if (!Registry.is((String)"groovy.good.code.is.red", (boolean)false)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                GroovyGoodCodeRedVisitor.$$$reportNull$$$0(0);
            }
            return psiElementVisitor;
        }
        GroovyFileBase file = (GroovyFileBase)holder.getFile();
        Project project = holder.getProject();
        final GrAccessibilityChecker accessibilityChecker = new GrAccessibilityChecker(file, project);
        final GroovyStaticTypeCheckVisitor typeCheckVisitor = new GroovyStaticTypeCheckVisitor(){

            protected void registerError(@NotNull PsiElement location, @NotNull String description2, LocalQuickFix @Nullable [] fixes, ProblemHighlightType highlightType) {
                if (location == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (description2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (highlightType == ProblemHighlightType.GENERIC_ERROR) {
                    holder.registerProblem(location, description2, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "location";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "description";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/devkit/inspections/internal/GroovyGoodCodeRedVisitor$1";
                objectArray[2] = "registerError";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            public void visitElement(@NotNull GroovyPsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                element.accept((GroovyElementVisitor)typeCheckVisitor);
            }

            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.visitReferenceExpression(referenceExpression);
                HighlightInfo info = accessibilityChecker.checkReferenceExpression(referenceExpression);
                if (info != null) {
                    this.registerProblem(holder, info, (PsiElement)referenceExpression);
                }
            }

            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
                if (refElement == null) {
                    2.$$$reportNull$$$0(2);
                }
                super.visitCodeReferenceElement(refElement);
                HighlightInfo info = accessibilityChecker.checkCodeReferenceElement(refElement);
                if (info != null) {
                    this.registerProblem(holder, info, (PsiElement)refElement);
                }
            }

            private void registerProblem(ProblemsHolder holder2, HighlightInfo info, PsiElement e) {
                if (info.getSeverity() == HighlightSeverity.ERROR) {
                    holder2.registerProblem(e, info.getDescription(), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refElement";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/GroovyGoodCodeRedVisitor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCodeReferenceElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/GroovyGoodCodeRedVisitor", "createVisitor"));
    }
}

