/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;

public class SerializableCtorInspection
extends DevKitInspectionBase {
    @Override
    protected PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SerializableCtorInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                PsiMethod[] constructors;
                if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.io.Serializable")) {
                    return;
                }
                if (aClass.findFieldByName("serialVersionUID", false) == null) {
                    return;
                }
                for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                    String fqn = "com.intellij.serialization.PropertyMapping";
                    if (constructor.getNameIdentifier() == null || constructor.getAnnotation(fqn) != null) continue;
                    StringBuilder builder = new StringBuilder("@PropertyMapping({");
                    JvmParameter[] parameters = constructor.getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        String name;
                        if (i > 0) {
                            builder.append(',');
                        }
                        if (aClass.findFieldByName(name = Objects.requireNonNull(parameters[i].getName()), false) == null) {
                            name = "my" + StringUtil.capitalize((String)name);
                        }
                        if (aClass.findFieldByName(name, false) == null) {
                            name = "??" + name;
                        }
                        builder.append('\"').append(name).append('\"');
                    }
                    PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createAnnotationFromText(builder.append("})").toString(), (PsiElement)aClass);
                    holder.registerProblem((PsiElement)constructor.getNameIdentifier(), "Non-default ctor should be annotated with @PropertyMapping", new LocalQuickFix[]{new AddAnnotationPsiFix(fqn, (PsiModifierListOwner)constructor, annotation.getParameterList().getAttributes(), new String[0])});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/SerializableCtorInspection", "buildInternalVisitor"));
    }
}

