/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;

public class UseCoupleQuickFix
extends LocalQuickFixBase {
    private static final String COUPLE_FQN = "com.intellij.openapi.util.Couple";

    public UseCoupleQuickFix(String text) {
        super(text, "Replace 'Pair' with 'Couple'");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement newElement;
        if (project == null) {
            UseCoupleQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            UseCoupleQuickFix.$$$reportNull$$$0(1);
        }
        PsiElement element = descriptor.getPsiElement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        if (element instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiClassType type1 = (PsiClassType)typeElement.getType();
            PsiType[] parameters = type1.getParameters();
            if (parameters.length != 2) {
                return;
            }
            PsiTypeElement newType = factory.createTypeElementFromText("com.intellij.openapi.util.Couple<" + parameters[0].getCanonicalText() + ">", element.getContext());
            newElement = element.replace((PsiElement)newType);
        } else {
            PsiElement parent = element.getParent().getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            String text = "com.intellij.openapi.util.Couple.of" + methodCallExpression.getArgumentList().getText();
            PsiExpression expression = factory.createExpressionFromText(text, element.getContext());
            newElement = parent.replace((PsiElement)expression);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/quickfix/UseCoupleQuickFix";
        objectArray[2] = "applyFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

