/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.projectRoots;

import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaDependentSdkType;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.THashSet;
import icons.DevkitIcons;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdkConfigurable;
import org.jetbrains.idea.devkit.projectRoots.IntelliJPlatformProduct;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsNamedElement;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;

public class IdeaJdk
extends JavaDependentSdkType
implements JavaSdkType {
    private static final Logger LOG = Logger.getInstance(IdeaJdk.class);
    @NonNls
    private static final String LIB_DIR_NAME = "lib";
    @NonNls
    private static final String SRC_DIR_NAME = "src";
    @NonNls
    private static final String PLUGINS_DIR = "plugins";

    public IdeaJdk() {
        super("IDEA JDK");
    }

    public Icon getIcon() {
        return DevkitIcons.Sdk_closed;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.project.structure.sdk.idea";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = DevkitIcons.Add_sdk;
        if (icon == null) {
            IdeaJdk.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public String suggestHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        File home;
        if (homePath == null) {
            IdeaJdk.$$$reportNull$$$0(1);
        }
        if (SystemInfo.isMac && (home = new File(homePath, "Contents")).exists()) {
            String string = home.getPath();
            if (string == null) {
                IdeaJdk.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = super.adjustSelectedSdkHome(homePath);
        if (string == null) {
            IdeaJdk.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isValidSdkHome(String path) {
        if (PsiUtil.isPathToIntelliJIdeaSources(path)) {
            return true;
        }
        File home = new File(path);
        return home.exists() && IdeaJdk.getBuildNumber(path) != null && IdeaJdk.getPlatformApiJar(path) != null;
    }

    @Nullable
    private static File getPlatformApiJar(String home) {
        File libDir = new File(home, LIB_DIR_NAME);
        File f = new File(libDir, "platform-api.jar");
        if (f.exists()) {
            return f;
        }
        f = new File(libDir, "openapi.jar");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    @Nullable
    public final String getVersionString(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(4);
        }
        return (internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk)) != null ? internalJavaSdk.getVersionString() : null;
    }

    @Nullable
    private static Sdk getInternalJavaSdk(Sdk sdk) {
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        if (data instanceof Sandbox) {
            return ((Sandbox)data).getJavaSdk();
        }
        return null;
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, String sdkHome) {
        if (PsiUtil.isPathToIntelliJIdeaSources(sdkHome)) {
            String string = "Local IDEA [" + sdkHome + "]";
            if (string == null) {
                IdeaJdk.$$$reportNull$$$0(5);
            }
            return string;
        }
        String buildNumber = IdeaJdk.getBuildNumber(sdkHome);
        String string = IntelliJPlatformProduct.fromBuildNumber(buildNumber).getName() + " " + (buildNumber != null ? buildNumber : "");
        if (string == null) {
            IdeaJdk.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static String getBuildNumber(String ideaHome) {
        try {
            String buildTxt = SystemInfo.isMac ? "Resources/build.txt" : "build.txt";
            File file = new File(ideaHome, buildTxt);
            if (SystemInfo.isMac && !file.exists()) {
                file = new File(ideaHome, "build.txt");
            }
            return FileUtil.loadFile((File)file).trim();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static VirtualFile[] getIdeaLibrary(String home) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        IdeaJdk.appendIdeaLibrary(home, result, "junit.jar");
        String plugins = home + File.separator + PLUGINS_DIR + File.separator;
        IdeaJdk.appendIdeaLibrary(plugins + "java", result, new String[0]);
        IdeaJdk.appendIdeaLibrary(plugins + "JavaEE", result, "javaee-impl.jar", "jpa-console.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "PersistenceSupport", result, "persistence-impl.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "DatabaseTools", result, "database-impl.jar", "jdbc-console.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "css", result, "css.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "uml", result, "uml-support.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "Spring", result, "spring.jar", "spring-el.jar", "spring-jsf.jar", "spring-persistence-integration.jar");
        return VfsUtilCore.toVirtualFileArray(result);
    }

    private static void appendIdeaLibrary(@NotNull String libDirPath, @NotNull List<VirtualFile> result, String ... forbidden) {
        File[] jars;
        if (libDirPath == null) {
            IdeaJdk.$$$reportNull$$$0(7);
        }
        if (result == null) {
            IdeaJdk.$$$reportNull$$$0(8);
        }
        if (forbidden == null) {
            IdeaJdk.$$$reportNull$$$0(9);
        }
        Arrays.sort(forbidden);
        String path = libDirPath + File.separator + LIB_DIR_NAME;
        JarFileSystem jfs = JarFileSystem.getInstance();
        File lib = new File(path);
        if (lib.isDirectory() && (jars = lib.listFiles()) != null) {
            for (File jar : jars) {
                String name = jar.getName();
                if (!jar.isFile() || Arrays.binarySearch(forbidden, name) >= 0 || !name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                VirtualFile file = jfs.findFileByPath(jar.getPath() + "!/");
                LOG.assertTrue(file != null, (Object)(jar.getPath() + " not found"));
                result.add(file);
            }
        }
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        SdkModificator sdkModificator;
        boolean result;
        Sandbox additionalData;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(10);
        }
        if (sdkModel == null) {
            IdeaJdk.$$$reportNull$$$0(11);
        }
        if ((additionalData = (Sandbox)sdk.getSdkAdditionalData()) != null) {
            additionalData.cleanupWatchedRoots();
        }
        if ((result = IdeaJdk.setupSdkPaths(sdk, sdkModificator = sdk.getSdkModificator(), sdkModel)) && sdkModificator.getSdkAdditionalData() == null) {
            Sdk[] sdks;
            ArrayList<String> javaSdks = new ArrayList<String>();
            for (Sdk jdk : sdks = sdkModel.getSdks()) {
                if (!IdeaJdk.isValidInternalJdk(sdk, jdk)) continue;
                javaSdks.add(jdk.getName());
            }
            if (javaSdks.isEmpty()) {
                JavaSdkVersion requiredVersion = IdeaJdk.getRequiredJdkVersion(sdk);
                if (requiredVersion != null) {
                    Messages.showErrorDialog((String)DevKitBundle.message("no.java.sdk.for.idea.sdk.found", requiredVersion), (String)"No Java SDK Found");
                } else {
                    Messages.showErrorDialog((String)DevKitBundle.message("no.idea.sdk.version.found", new Object[0]), (String)"No Java SDK Found");
                }
                return false;
            }
            int choice = Messages.showChooseDialog((String)("Select Java SDK to be used for " + DevKitBundle.message("sdk.title", new Object[0])), (String)"Select Internal Java Platform", (String[])ArrayUtilRt.toStringArray(javaSdks), (String)((String)javaSdks.get(0)), (Icon)Messages.getQuestionIcon());
            if (choice != -1) {
                String name = (String)javaSdks.get(choice);
                Sdk internalJava = Objects.requireNonNull(sdkModel.findSdk(name));
                IdeaJdk.setInternalJdk(sdk, sdkModificator, internalJava);
            } else {
                result = false;
            }
        }
        sdkModificator.commitChanges();
        return result;
    }

    private static void setInternalJdk(@NotNull Sdk sdk, @NotNull SdkModificator sdkModificator, @NotNull Sdk internalJava) {
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(12);
        }
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(13);
        }
        if (internalJava == null) {
            IdeaJdk.$$$reportNull$$$0(14);
        }
        IdeaJdk.addClasses(sdkModificator, internalJava);
        IdeaJdk.addDocs(sdkModificator, internalJava);
        IdeaJdk.addSources(sdkModificator, internalJava);
        sdkModificator.setSdkAdditionalData((SdkAdditionalData)new Sandbox(IdeaJdk.getDefaultSandbox(), internalJava, sdk));
        sdkModificator.setVersionString(internalJava.getVersionString());
    }

    static boolean isValidInternalJdk(@NotNull Sdk ideaSdk, @NotNull Sdk sdk) {
        SdkTypeId sdkType;
        if (ideaSdk == null) {
            IdeaJdk.$$$reportNull$$$0(15);
        }
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(16);
        }
        if ((sdkType = sdk.getSdkType()) instanceof JavaSdk) {
            JavaSdkVersion version = JavaSdk.getInstance().getVersion(sdk);
            JavaSdkVersion requiredVersion = IdeaJdk.getRequiredJdkVersion(ideaSdk);
            if (version != null && requiredVersion != null) {
                return version.isAtLeast(requiredVersion);
            }
        }
        return false;
    }

    @Nullable
    private static JavaSdkVersion getRequiredJdkVersion(Sdk ideaSdk) {
        if (PsiUtil.isPathToIntelliJIdeaSources(ideaSdk.getHomePath())) {
            return JavaSdkVersion.JDK_1_8;
        }
        File apiJar = IdeaJdk.getPlatformApiJar(ideaSdk.getHomePath());
        return apiJar != null ? ClsParsingUtil.getJdkVersionByBytecode((int)IdeaJdk.getIdeaClassFileVersion(apiJar)) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getIdeaClassFileVersion(File apiJar) {
        try (ZipFile zipFile = new ZipFile(apiJar);){
            ZipEntry entry = zipFile.getEntry(ApplicationStarter.class.getName().replace('.', '/') + ".class");
            if (entry == null) return -1;
            try (DataInputStream stream = new DataInputStream(zipFile.getInputStream(entry));){
                if (stream.skip(6L) != 6L) return -1;
                int n = stream.readUnsignedShort();
                return n;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return -1;
    }

    private static boolean setupSdkPaths(Sdk sdk, SdkModificator sdkModificator, SdkModel sdkModel) {
        String sdkHome = Objects.requireNonNull(sdk.getHomePath());
        if (PsiUtil.isPathToIntelliJIdeaSources(sdkHome)) {
            try {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    IdeaJdk.setupSdkPathsFromIDEAProject(sdk, sdkModificator, sdkModel);
                    return null;
                }, "Scanning for Roots", true, null);
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                Messages.showErrorDialog((String)e.toString(), (String)DevKitBundle.message("sdk.title", new Object[0]));
                return false;
            }
        } else {
            VirtualFile[] ideaLib;
            for (VirtualFile aIdeaLib : ideaLib = IdeaJdk.getIdeaLibrary(sdkHome)) {
                sdkModificator.addRoot(aIdeaLib, OrderRootType.CLASSES);
            }
            IdeaJdk.addSources(new File(sdkHome), sdkModificator);
        }
        return true;
    }

    private static void setupSdkPathsFromIDEAProject(Sdk sdk, SdkModificator sdkModificator, SdkModel sdkModel) throws IOException {
        Sdk internalJava;
        ProgressIndicator indicator = Objects.requireNonNull(ProgressManager.getInstance().getProgressIndicator());
        String sdkHome = Objects.requireNonNull(sdk.getHomePath());
        JpsModel model = JpsSerializationManager.getInstance().loadModel(sdkHome, PathManager.getOptionsPath());
        JpsSdkReference sdkRef = model.getProject().getSdkReferencesTable().getSdkReference((JpsSdkType)JpsJavaSdkType.INSTANCE);
        Sdk sdk2 = internalJava = sdkRef == null ? null : sdkModel.findSdk(sdkRef.getSdkName());
        if (internalJava != null && IdeaJdk.isValidInternalJdk(sdk, internalJava)) {
            IdeaJdk.setInternalJdk(sdk, sdkModificator, internalJava);
        }
        Map moduleByName = model.getProject().getModules().stream().collect(Collectors.toMap(JpsNamedElement::getName, Function.identity()));
        Object[] mainModuleCandidates = new String[]{"intellij.idea.ultimate.main", "intellij.idea.community.main", "main", "community-main"};
        JpsModule mainModule = Arrays.stream(mainModuleCandidates).map(moduleByName::get).filter(Objects::nonNull).findFirst().orElse(null);
        if (mainModule == null) {
            LOG.error("Cannot find main module (" + Arrays.toString(mainModuleCandidates) + ") in IntelliJ IDEA sources at " + sdkHome);
            return;
        }
        LinkedHashSet modules = new LinkedHashSet();
        JpsJavaExtensionService.dependencies((JpsModule)mainModule).recursively().processModules(modules::add);
        indicator.setIndeterminate(false);
        double delta = 1.0 / (2.0 * Math.max(0.5, (double)modules.size()));
        JpsJavaExtensionService javaService = JpsJavaExtensionService.getInstance();
        VirtualFileManager vfsManager = VirtualFileManager.getInstance();
        THashSet addedRoots = new THashSet();
        for (JpsModule o : modules) {
            indicator.setFraction(indicator.getFraction() + delta);
            for (JpsDependencyElement dep : o.getDependenciesList().getDependencies()) {
                VirtualFile root;
                ProgressManager.checkCanceled();
                JpsLibrary library = dep instanceof JpsLibraryDependency ? ((JpsLibraryDependency)dep).getLibrary() : null;
                if (library == null || library.getName().equals("jps-build-script-dependencies-bootstrap")) continue;
                for (JpsLibraryRoot jps : library.getRoots(JpsOrderRootType.COMPILED)) {
                    root = vfsManager.findFileByUrl(jps.getUrl());
                    if (root == null || !addedRoots.add(root)) continue;
                    sdkModificator.addRoot(root, OrderRootType.CLASSES);
                }
                for (JpsLibraryRoot jps : library.getRoots(JpsOrderRootType.SOURCES)) {
                    root = vfsManager.findFileByUrl(jps.getUrl());
                    if (root == null || !addedRoots.add(root)) continue;
                    sdkModificator.addRoot(root, OrderRootType.SOURCES);
                }
            }
        }
        for (JpsModule o : modules) {
            VirtualFile outputRoot;
            indicator.setFraction(indicator.getFraction() + delta);
            String outputUrl = javaService.getOutputUrl(o, false);
            VirtualFile virtualFile = outputRoot = outputUrl == null ? null : vfsManager.findFileByUrl(outputUrl);
            if (outputRoot == null) continue;
            sdkModificator.addRoot(outputRoot, OrderRootType.CLASSES);
            for (JpsModuleSourceRoot jps : o.getSourceRoots()) {
                ProgressManager.checkCanceled();
                VirtualFile root = vfsManager.findFileByUrl(jps.getUrl());
                if (root == null || !addedRoots.add(root)) continue;
                sdkModificator.addRoot(root, OrderRootType.SOURCES);
            }
        }
        indicator.setFraction(1.0);
    }

    static String getDefaultSandbox() {
        String defaultSandbox = "";
        try {
            defaultSandbox = new File(PathManager.getSystemPath()).getCanonicalPath() + File.separator + "plugins-sandbox";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return defaultSandbox;
    }

    private static void addSources(File file, SdkModificator sdkModificator) {
        File src = new File(new File(file, LIB_DIR_NAME), SRC_DIR_NAME);
        if (!src.exists()) {
            return;
        }
        File[] srcs = src.listFiles(pathname -> {
            String path = pathname.getPath();
            if (path.contains("generics")) {
                return false;
            }
            return path.endsWith(".jar") || path.endsWith(".zip");
        });
        for (int i = 0; srcs != null && i < srcs.length; ++i) {
            File jarFile = srcs[i];
            if (!jarFile.exists()) continue;
            JarFileSystem jarFileSystem = JarFileSystem.getInstance();
            String path = jarFile.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
            jarFileSystem.setNoCopyJarForPath(path);
            VirtualFile vFile = jarFileSystem.findFileByPath(path);
            sdkModificator.addRoot(vFile, OrderRootType.SOURCES);
        }
    }

    private static void addClasses(@NotNull SdkModificator sdkModificator, @NotNull Sdk javaSdk) {
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(17);
        }
        if (javaSdk == null) {
            IdeaJdk.$$$reportNull$$$0(18);
        }
        IdeaJdk.addOrderEntries(OrderRootType.CLASSES, javaSdk, sdkModificator);
    }

    private static void addDocs(@NotNull SdkModificator sdkModificator, @NotNull Sdk javaSdk) {
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(19);
        }
        if (javaSdk == null) {
            IdeaJdk.$$$reportNull$$$0(20);
        }
        if (!IdeaJdk.addOrderEntries(JavadocOrderRootType.getInstance(), javaSdk, sdkModificator) && SystemInfo.isMac) {
            Sdk[] jdks;
            for (Sdk jdk : jdks = ProjectJdkTable.getInstance().getAllJdks()) {
                if (!(jdk.getSdkType() instanceof JavaSdk)) continue;
                IdeaJdk.addOrderEntries(JavadocOrderRootType.getInstance(), jdk, sdkModificator);
                break;
            }
        }
    }

    private static void addSources(SdkModificator sdkModificator, Sdk javaSdk) {
        if (javaSdk != null && !IdeaJdk.addOrderEntries(OrderRootType.SOURCES, javaSdk, sdkModificator)) {
            if (SystemInfo.isMac) {
                Sdk[] jdks;
                for (Sdk jdk : jdks = ProjectJdkTable.getInstance().getAllJdks()) {
                    if (!(jdk.getSdkType() instanceof JavaSdk)) continue;
                    IdeaJdk.addOrderEntries(OrderRootType.SOURCES, jdk, sdkModificator);
                    break;
                }
            } else {
                String homePath = javaSdk.getHomePath();
                if (homePath == null) {
                    return;
                }
                File jdkHome = new File(homePath).getParentFile();
                String srcZip = "src.zip";
                File jarFile = new File(jdkHome, "src.zip");
                if (jarFile.exists()) {
                    JarFileSystem jarFileSystem = JarFileSystem.getInstance();
                    String path = jarFile.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
                    jarFileSystem.setNoCopyJarForPath(path);
                    sdkModificator.addRoot(jarFileSystem.findFileByPath(path), OrderRootType.SOURCES);
                }
            }
        }
    }

    private static boolean addOrderEntries(@NotNull OrderRootType orderRootType, @NotNull Sdk sdk, @NotNull SdkModificator toModificator) {
        String[] entries;
        if (orderRootType == null) {
            IdeaJdk.$$$reportNull$$$0(21);
        }
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(22);
        }
        if (toModificator == null) {
            IdeaJdk.$$$reportNull$$$0(23);
        }
        boolean wasSmthAdded = false;
        for (String entry : entries = sdk.getRootProvider().getUrls(orderRootType)) {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(entry);
            if (virtualFile == null) continue;
            toModificator.addRoot(virtualFile, orderRootType);
            wasSmthAdded = true;
        }
        return wasSmthAdded;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            IdeaJdk.$$$reportNull$$$0(24);
        }
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(25);
        }
        return new IdeaJdkConfigurable(sdkModel, sdkModificator);
    }

    @Nullable
    public String getBinPath(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(26);
        }
        return (internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk)) == null ? null : JavaSdk.getInstance().getBinPath(internalJavaSdk);
    }

    @Nullable
    public String getToolsPath(@NotNull Sdk sdk) {
        Sdk jdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(27);
        }
        if ((jdk = IdeaJdk.getInternalJavaSdk(sdk)) != null && jdk.getVersionString() != null) {
            return JavaSdk.getInstance().getToolsPath(jdk);
        }
        return null;
    }

    @Nullable
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(28);
        }
        return (internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk)) == null ? null : JavaSdk.getInstance().getVMExecutablePath(internalJavaSdk);
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            IdeaJdk.$$$reportNull$$$0(29);
        }
        if (additional == null) {
            IdeaJdk.$$$reportNull$$$0(30);
        }
        if (additionalData instanceof Sandbox) {
            try {
                ((Sandbox)additionalData).writeExternal(additional);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk sdk, @NotNull Element additional) {
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(31);
        }
        if (additional == null) {
            IdeaJdk.$$$reportNull$$$0(32);
        }
        Sandbox sandbox = new Sandbox(sdk);
        try {
            sandbox.readExternal(additional);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        return sandbox;
    }

    @NotNull
    public String getPresentableName() {
        String string = DevKitBundle.message("sdk.title", new Object[0]);
        if (string == null) {
            IdeaJdk.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Nullable
    public static Sdk findIdeaJdk(@Nullable Sdk jdk) {
        if (jdk == null) {
            return null;
        }
        if (jdk.getSdkType() instanceof IdeaJdk) {
            return jdk;
        }
        return null;
    }

    public static SdkType getInstance() {
        return SdkType.findInstance(IdeaJdk.class);
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            IdeaJdk.$$$reportNull$$$0(34);
        }
        return type == OrderRootType.CLASSES || type == OrderRootType.SOURCES || type == JavadocOrderRootType.getInstance() || type == AnnotationOrderRootType.getInstance();
    }

    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(35);
        }
        return JavaSdk.getInstance().getDefaultDocumentationUrl(sdk);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/projectRoots/IdeaJdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 16: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forbidden";
                break;
            }
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalJava";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaSdk";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSdk";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRootType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toModificator";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/projectRoots/IdeaJdk";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectedSdkHome";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectedSdkHome";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendIdeaLibrary";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setInternalJdk";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValidInternalJdk";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addClasses";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addDocs";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addOrderEntries";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getToolsPath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getVMExecutablePath";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocumentationUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

