/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references.extensions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class ExtensionPointDocumentationProvider
implements DocumentationProvider {
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(element);
        if (extensionPoint == null) {
            return null;
        }
        XmlFile epDeclarationFile = DomUtil.getFile((DomElement)extensionPoint);
        StringBuilder epClassesText = new StringBuilder();
        if (DomUtil.hasXml(extensionPoint.getBeanClass())) {
            ExtensionPointDocumentationProvider.generateClassLink(epClassesText, (PsiClass)extensionPoint.getBeanClass().getValue());
            epClassesText.append("<br/>");
        }
        PsiClass extensionPointClass = extensionPoint.getExtensionPointClass();
        ExtensionPointDocumentationProvider.generateClassLink(epClassesText, extensionPointClass);
        Module epModule = ModuleUtilCore.findModuleForFile((VirtualFile)epDeclarationFile.getVirtualFile(), (Project)element.getProject());
        String moduleName = epModule == null ? "" : "[" + epModule.getName() + "]<br/>";
        return moduleName + "<b>" + extensionPoint.getEffectiveQualifiedName() + "</b> (" + epDeclarationFile.getName() + ")<br/>" + epClassesText.toString();
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        List<With> withElements;
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(element);
        if (extensionPoint == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<div class='definition'><pre>");
        sb.append("<b>").append(extensionPoint.getEffectiveQualifiedName()).append("</b>");
        sb.append("<br>").append(DomUtil.getFile((DomElement)extensionPoint).getName());
        if (DomUtil.hasXml(extensionPoint.getBeanClass())) {
            ExtensionPointDocumentationProvider.generateClassDoc(sb, (PsiElement)extensionPoint.getBeanClass().getValue());
        }
        if (!(withElements = extensionPoint.getWithElements()).isEmpty()) {
            sb.append("<table class='sections'>");
            for (With withElement : withElements) {
                String name = StringUtil.notNullize((String)(DomUtil.hasXml(withElement.getAttribute()) ? withElement.getAttribute().getStringValue() : "<" + withElement.getTag().getStringValue() + ">"));
                StringBuilder classLinkSb = new StringBuilder();
                ExtensionPointDocumentationProvider.generateClassLink(classLinkSb, (PsiClass)withElement.getImplements().getValue());
                ExtensionPointDocumentationProvider.appendSection(sb, XmlUtil.escape((String)name), classLinkSb.toString());
            }
            sb.append("</table>");
        }
        sb.append("</pre></div>");
        PsiClass extensionPointClass = extensionPoint.getExtensionPointClass();
        if (extensionPointClass != null) {
            sb.append("<div class='content'>");
            sb.append("<h2>Extension Point Implementation</h2>");
            ExtensionPointDocumentationProvider.generateClassDoc(sb, (PsiElement)extensionPointClass);
            sb.append("</div>");
        }
        return sb.toString();
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
    }

    private static void generateClassLink(StringBuilder epClassText, @Nullable PsiClass epClass) {
        if (epClass == null) {
            return;
        }
        DocumentationManagerUtil.createHyperlink((StringBuilder)epClassText, (PsiElement)epClass, (String)epClass.getQualifiedName(), (String)epClass.getName(), (boolean)false);
    }

    private static void generateClassDoc(StringBuilder sb, @Nullable PsiElement element) {
        if (element == null) {
            sb.append("??? not found ???");
            return;
        }
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)element);
        sb.append(documentationProvider.generateDoc(element, null));
    }

    private static void appendSection(StringBuilder sb, String sectionName, String sectionContent) {
        sb.append("<tr><td valign='top' class='section'><p>").append(sectionName).append(":").append("</td><td valign='top'>");
        sb.append(sectionContent);
        sb.append("</td>");
    }

    @Nullable
    private static ExtensionPoint findExtensionPoint(PsiElement element) {
        DomElement domElement;
        if (element instanceof PomTargetPsiElement && DescriptorUtil.isPluginXml(element.getContainingFile())) {
            DomElement domElement2;
            PomTarget pomTarget = ((PomTargetPsiElement)element).getTarget();
            if (pomTarget instanceof DomTarget && (domElement2 = ((DomTarget)pomTarget).getDomElement()) instanceof ExtensionPoint) {
                return (ExtensionPoint)domElement2;
            }
        } else if (element instanceof XmlTag && DescriptorUtil.isPluginXml(element.getContainingFile()) && (domElement = DomUtil.getDomElement((PsiElement)element)) instanceof ExtensionPoint) {
            return (ExtensionPoint)domElement;
        }
        return null;
    }
}

