/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.openapi.externalSystem.util.BooleanBiFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class IteratorUtils {
    public static <T> boolean match(@NotNull Iterator<T> iterator1, @NotNull Iterator<T> iterator2, @NotNull BooleanBiFunction<? super T, ? super T> condition) {
        if (iterator1 == null) {
            IteratorUtils.$$$reportNull$$$0(0);
        }
        if (iterator2 == null) {
            IteratorUtils.$$$reportNull$$$0(1);
        }
        if (condition == null) {
            IteratorUtils.$$$reportNull$$$0(2);
        }
        while (iterator2.hasNext()) {
            if (iterator1.hasNext() && ((Boolean)condition.fun(iterator1.next(), iterator2.next())).booleanValue()) continue;
            return false;
        }
        return !iterator1.hasNext();
    }

    public static <T> boolean match(@NotNull AbstractObjectGraphIterator<T> iterator1, @NotNull AbstractObjectGraphIterator<T> iterator2, @NotNull BooleanBiFunction<? super T, ? super T> condition) {
        if (iterator1 == null) {
            IteratorUtils.$$$reportNull$$$0(3);
        }
        if (iterator2 == null) {
            IteratorUtils.$$$reportNull$$$0(4);
        }
        if (condition == null) {
            IteratorUtils.$$$reportNull$$$0(5);
        }
        while (iterator2.hasNext()) {
            if (iterator1.hasNext() && ((AbstractObjectGraphIterator)iterator1).myProcessedStructure.equals(((AbstractObjectGraphIterator)iterator2).myProcessedStructure) && ((Boolean)condition.fun(iterator1.next(), iterator2.next())).booleanValue()) continue;
            return false;
        }
        return !iterator1.hasNext();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "iterator1";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "iterator2";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "condition";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/externalSystem/util/IteratorUtils";
        objectArray[2] = "match";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Experimental
    public static abstract class AbstractObjectGraphIterator<T>
    implements Iterator<T> {
        private final Set<T> mySeenObjects;
        private final LinkedList<T> myToProcess;
        private final LinkedList<Integer> myProcessedStructure;

        public AbstractObjectGraphIterator(@NotNull Collection<T> dependencies) {
            if (dependencies == null) {
                AbstractObjectGraphIterator.$$$reportNull$$$0(0);
            }
            this.mySeenObjects = Collections.newSetFromMap(new IdentityHashMap());
            this.myToProcess = new LinkedList<T>(dependencies);
            this.myProcessedStructure = new LinkedList();
        }

        public abstract Collection<? extends T> getChildren(T var1);

        @Override
        public boolean hasNext() {
            T dependency = this.myToProcess.peekFirst();
            if (dependency == null) {
                return false;
            }
            if (this.mySeenObjects.contains(dependency)) {
                this.myToProcess.removeFirst();
                return this.hasNext();
            }
            return !this.myToProcess.isEmpty();
        }

        @Override
        public T next() {
            T dependency = this.myToProcess.removeFirst();
            if (this.mySeenObjects.add(dependency)) {
                Collection<T> children = this.getChildren(dependency);
                this.myToProcess.addAll(children);
                this.myProcessedStructure.add(children.size());
                return dependency;
            }
            return this.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/openapi/externalSystem/util/IteratorUtils$AbstractObjectGraphIterator", "<init>"));
        }
    }
}

