/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.util.Comparing;
import icons.XpathIcons;
import org.intellij.lang.xpath.completion.AbstractLookup;
import org.intellij.lang.xpath.context.functions.Function;

public class FunctionLookup
extends AbstractLookup {
    private final String type;
    private final boolean hasParameters;

    FunctionLookup(String name, String _presentation) {
        this(name, _presentation, null, false);
    }

    FunctionLookup(String name, String _presentation, String type, boolean hasParams) {
        super(name, _presentation);
        this.type = type;
        this.hasParameters = hasParams;
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        presentation.setTypeText(this.type);
        presentation.setIcon(XpathIcons.Function);
        presentation.setItemTextBold(this.type == null);
    }

    boolean hasParameters() {
        return this.hasParameters;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionLookup that = (FunctionLookup)((Object)o);
        return Comparing.equal((String)this.myPresentation, (String)that.myPresentation);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static LookupElement newFunctionLookup(String name, Function functionDecl) {
        String presentation = functionDecl.buildSignature();
        String returnType = functionDecl.getReturnType().getName();
        boolean hasParams = functionDecl.getParameters().length > 0;
        return new FunctionLookup(name, presentation, returnType, hasParams);
    }
}

