/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.context;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.psi.PsiElement;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.validation.inspections.XPathInspection;
import org.intellij.lang.xpath.validation.inspections.quickfix.MakeTypeExplicitFix;
import org.intellij.lang.xpath.validation.inspections.quickfix.RemoveExplicitConversionFix;
import org.intellij.lang.xpath.validation.inspections.quickfix.RemoveRedundantConversionFix;
import org.intellij.lang.xpath.validation.inspections.quickfix.XPathQuickFixFactory;
import org.jetbrains.annotations.NotNull;

public class XPathQuickFixFactoryImpl
implements XPathQuickFixFactory {
    public static final XPathQuickFixFactory INSTANCE = new XPathQuickFixFactoryImpl();

    private XPathQuickFixFactoryImpl() {
    }

    @Override
    public XPathQuickFixFactory.Fix<XPathExpression>[] createImplicitTypeConversionFixes(XPathExpression expression, XPathType type, boolean explicit) {
        XPathQuickFixFactory.Fix[] fixArray;
        if (explicit) {
            XPathQuickFixFactory.Fix[] fixArray2 = new XPathQuickFixFactory.Fix[2];
            fixArray2[0] = new RemoveExplicitConversionFix(expression);
            fixArray = fixArray2;
            fixArray2[1] = new MakeTypeExplicitFix(expression, type);
        } else {
            XPathQuickFixFactory.Fix[] fixArray3 = new XPathQuickFixFactory.Fix[1];
            fixArray = fixArray3;
            fixArray3[0] = new MakeTypeExplicitFix(expression, type);
        }
        return fixArray;
    }

    @Override
    public XPathQuickFixFactory.Fix<XPathExpression>[] createRedundantTypeConversionFixes(XPathExpression expression) {
        return new XPathQuickFixFactory.Fix[]{new RemoveRedundantConversionFix(expression)};
    }

    @Override
    public XPathQuickFixFactory.Fix<XPathNodeTest>[] createUnknownNodeTestFixes(XPathNodeTest test) {
        return new XPathQuickFixFactory.Fix[0];
    }

    @Override
    public SuppressIntentionAction @NotNull [] getSuppressActions(XPathInspection inspection) {
        if (SuppressIntentionAction.EMPTY_ARRAY == null) {
            XPathQuickFixFactoryImpl.$$$reportNull$$$0(0);
        }
        return SuppressIntentionAction.EMPTY_ARRAY;
    }

    @Override
    public boolean isSuppressedFor(PsiElement element, XPathInspection inspection) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/context/XPathQuickFixFactoryImpl", "getSuppressActions"));
    }
}

