/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import java.text.MessageFormat;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.validation.inspections.XPathInspection;
import org.intellij.lang.xpath.validation.inspections.quickfix.XPathQuickFixFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckNodeTest
extends XPathInspection {
    @NonNls
    private static final String SHORT_NAME = "CheckNodeTest";

    @Override
    protected XPathInspection.Visitor createVisitor(InspectionManager manager, boolean isOnTheFly) {
        return new MyVisitor(manager, isOnTheFly);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected boolean acceptsLanguage(Language language) {
        return language == XPathFileType.XPATH.getLanguage() || language == XPathFileType.XPATH2.getLanguage();
    }

    static final class MyVisitor
    extends XPathInspection.Visitor {
        MyVisitor(InspectionManager manager, boolean isOnTheFly) {
            super(manager, isOnTheFly);
        }

        @Override
        protected void checkNodeTest(XPathNodeTest nodeTest) {
            ContextProvider contextProvider = ContextProvider.getContextProvider(nodeTest.getContainingFile());
            XmlElement contextNode = contextProvider.getContextElement();
            NamespaceContext namespaceContext = contextProvider.getNamespaceContext();
            if (namespaceContext == null) {
                return;
            }
            if (nodeTest.isNameTest() && contextNode != null) {
                PrefixedName prefixedName = nodeTest.getQName();
                assert (prefixedName != null);
                if (!"*".equals(prefixedName.getLocalName()) && !"*".equals(prefixedName.getPrefix())) {
                    Set<QName> attributeNames;
                    if (nodeTest.getPrincipalType() == XPathNodeTest.PrincipalType.ELEMENT) {
                        Set<QName> elementNames = contextProvider.getElements(true);
                        if (elementNames != null) {
                            boolean found = false;
                            for (QName pair : elementNames) {
                                if (!MyVisitor.matches(nodeTest.getQName(), pair, namespaceContext, contextNode, true)) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                this.registerProblem(contextProvider, prefixedName, nodeTest, "element");
                            }
                        }
                    } else if (nodeTest.getPrincipalType() == XPathNodeTest.PrincipalType.ATTRIBUTE && (attributeNames = contextProvider.getAttributes(true)) != null) {
                        boolean found = false;
                        for (QName pair : attributeNames) {
                            if (!MyVisitor.matches(nodeTest.getQName(), pair, namespaceContext, contextNode, false)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.registerProblem(contextProvider, prefixedName, nodeTest, "attribute");
                        }
                    }
                }
            }
        }

        private void registerProblem(ContextProvider contextProvider, PrefixedName prefixedName, XPathNodeTest nodeTest, String type) {
            String name;
            QName qName = contextProvider.getQName(prefixedName, nodeTest);
            if (qName != null) {
                String pattern = !"".equals(qName.getNamespaceURI()) ? "''<b>{0}</b>'' (<i>{1}</i>)" : "''<b>{0}</b>''";
                name = MessageFormat.format(pattern, qName.getLocalPart(), qName.getNamespaceURI());
            } else {
                name = MessageFormat.format("''<b>{0}</b>''", prefixedName.getLocalName());
            }
            XPathQuickFixFactory.Fix<XPathNodeTest>[] fixes = contextProvider.getQuickFixFactory().createUnknownNodeTestFixes(nodeTest);
            this.addProblem(this.myManager.createProblemDescriptor((PsiElement)nodeTest, "<html>Unknown " + type + " name " + name + "</html>", this.myOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }

        private static boolean matches(@Nullable PrefixedName prefixedName, QName element, NamespaceContext namespaceContext, XmlElement context, boolean allowDefaultNamespace) {
            if (prefixedName == null) {
                return false;
            }
            boolean b = prefixedName.getLocalName().equals(element.getLocalPart()) || "*".equals(element.getLocalPart());
            String prefix = prefixedName.getPrefix();
            if (prefix != null) {
                if (!"*".equals(prefix)) {
                    String namespaceURI = namespaceContext.getNamespaceURI(prefix, context);
                    b = b && element.getNamespaceURI().equals(namespaceURI);
                }
            } else if (allowDefaultNamespace) {
                String namespaceURI = namespaceContext.getDefaultNamespace(context);
                b = b && (element.getNamespaceURI().equals(namespaceURI) || element.getNamespaceURI().length() == 0 && namespaceURI == null);
            } else {
                b = b && element.getNamespaceURI().length() == 0;
            }
            return b;
        }
    }
}

