/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathBinaryExpression;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.validation.ExpectedTypeUtil;
import org.intellij.lang.xpath.validation.inspections.quickfix.ReplaceElementFix;
import org.jetbrains.annotations.NotNull;

public class RemoveExplicitConversionFix
extends ReplaceElementFix<XPathExpression> {
    public RemoveExplicitConversionFix(XPathExpression expression) {
        super(ExpectedTypeUtil.unparenthesize(expression));
    }

    @NotNull
    public String getText() {
        return "Remove Explicit Type Conversion";
    }

    @NotNull
    public String getFamilyName() {
        return "ImplicitTypeConversion";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            RemoveExplicitConversionFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RemoveExplicitConversionFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            RemoveExplicitConversionFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            RemoveExplicitConversionFix.$$$reportNull$$$0(3);
        }
        return super.isAvailable(project, file, startElement, endElement) && ((XPathFunctionCall)startElement).getArgumentList().length == 1;
    }

    @Override
    public void invokeImpl(Project project, PsiFile file) throws IncorrectOperationException {
        PsiElement myElement = this.getStartElement();
        XPathExpression arg0 = ((XPathFunctionCall)myElement).getArgumentList()[0];
        XPathExpression outer = (XPathExpression)PsiTreeUtil.getParentOfType((PsiElement)myElement, XPathExpression.class);
        if (arg0 instanceof XPathBinaryExpression && outer instanceof XPathBinaryExpression) {
            this.replace("(" + arg0.getText() + ")");
        } else {
            this.replace(arg0.getText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "startElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "endElement";
                break;
            }
        }
        objectArray[1] = "org/intellij/lang/xpath/validation/inspections/quickfix/RemoveExplicitConversionFix";
        objectArray[2] = "isAvailable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

