/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.intellij.lang.xpath.xslt.validation.inspections.SuppressInspectionAction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InspectionUtil {
    static final Pattern SUPPRESSION_PATTERN = Pattern.compile("[ \t]*(?:noinspection|suppress)[ \t]+(\\w+(,[ \t]*\\w+)*)[ \t]*");
    @NonNls
    private static final String ALL_ID = "ALL";

    private InspectionUtil() {
    }

    public static boolean isSuppressed(LocalInspectionTool tool, PsiElement element) {
        XmlTag sheet;
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)element, XmlTag.class, (boolean)true);
        if (InspectionUtil.isSuppressedAt((PsiElement)tag, tool)) {
            return true;
        }
        XmlTag tmpl = XsltCodeInsightUtil.getTemplateTag(element, true);
        if (InspectionUtil.isSuppressedAt((PsiElement)tmpl, tool)) {
            return true;
        }
        XmlDocument document = (XmlDocument)PsiTreeUtil.getContextOfType((PsiElement)element, XmlDocument.class, (boolean)true);
        return document != null && InspectionUtil.isSuppressedAt((PsiElement)(sheet = document.getRootTag()), tool);
    }

    private static boolean isSuppressedAt(PsiElement anchor, LocalInspectionTool tool) {
        XmlComment comment;
        String text;
        Matcher matcher;
        PsiElement prevSibling;
        if (anchor == null) {
            return false;
        }
        if (!(anchor instanceof XmlComment)) {
            prevSibling = anchor.getPrevSibling();
            while (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof XmlText) {
                prevSibling = prevSibling.getPrevSibling();
            }
        } else {
            prevSibling = anchor;
        }
        if (prevSibling instanceof XmlProlog) {
            if (prevSibling.getTextLength() > 0 && !"\n".equals(prevSibling.getText())) {
                return InspectionUtil.isSuppressedAt(prevSibling.getLastChild(), tool);
            }
            return InspectionUtil.isSuppressedAt(prevSibling, tool);
        }
        if (prevSibling instanceof XmlComment && (matcher = SUPPRESSION_PATTERN.matcher(text = (comment = (XmlComment)prevSibling).getCommentText())).matches()) {
            String[] strings = matcher.group(1).split(",");
            String toolId = tool.getID();
            for (String s : strings) {
                if (!s.trim().equals(toolId) && !ALL_ID.equals(s.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<SuppressIntentionAction> getSuppressActions(LocalInspectionTool inspection, final boolean isXPath) {
        ArrayList<SuppressIntentionAction> actions = new ArrayList<SuppressIntentionAction>(4);
        actions.add(new SuppressInspectionAction(inspection.getID(), "Suppress for Instruction"){

            @Override
            protected XmlTag getAnchor(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)element, XmlTag.class, (boolean)isXPath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/validation/inspections/InspectionUtil$1", "getAnchor"));
            }
        });
        actions.add(new SuppressInspectionAction(inspection.getID(), "Suppress for Template"){

            @Override
            protected XmlTag getAnchor(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                return XsltCodeInsightUtil.getTemplateTag(element, isXPath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/validation/inspections/InspectionUtil$2", "getAnchor"));
            }
        });
        actions.add(new SuppressInspectionAction(inspection.getID(), "Suppress for Stylesheet"){

            @Override
            protected XmlTag getAnchor(@NotNull PsiElement element) {
                XmlDocument document;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (document = (XmlDocument)PsiTreeUtil.getContextOfType((PsiElement)element, XmlDocument.class, (boolean)isXPath)) != null ? document.getRootTag() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/validation/inspections/InspectionUtil$3", "getAnchor"));
            }
        });
        actions.add(new SuppressInspectionAction(ALL_ID, "Suppress all for Stylesheet"){

            @Override
            protected XmlTag getAnchor(@NotNull PsiElement element) {
                XmlDocument document;
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                return (document = (XmlDocument)PsiTreeUtil.getContextOfType((PsiElement)element, XmlDocument.class, (boolean)isXPath)) != null ? document.getRootTag() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/validation/inspections/InspectionUtil$4", "getAnchor"));
            }
        });
        return actions;
    }
}

