/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.config.ConfigFileSearcher;
import com.intellij.xml.config.ConfigFilesTreeBuilder;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapExternalResourceDialog
extends DialogWrapper {
    private static final FileChooserDescriptor FILE_CHOOSER_DESCRIPTOR = new FileChooserDescriptor(true, false, false, false, true, false).withTitle(XmlBundle.message((String)"choose.schema.file", (Object[])new Object[0]));
    private JTextField myUri;
    private JPanel myMainPanel;
    private JTree mySchemasTree;
    private JPanel mySchemasPanel;
    private TextFieldWithBrowseButton myFileTextField;
    private boolean mySchemaFound;

    public MapExternalResourceDialog(String uri, @Nullable Project project, @Nullable PsiFile file, @Nullable String location) {
        super(project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(XmlBundle.message((String)"map.external.resource", (Object[])objectArray));
        this.myUri.setText(uri);
        this.myUri.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                MapExternalResourceDialog.this.validateInput();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/MapExternalResourceDialog$1", "textChanged"));
            }
        });
        if (project != null) {
            String path = project.getBasePath();
            if (path != null) {
                this.myFileTextField.setText(FileUtil.toSystemDependentName((String)path));
            }
            this.setupSchemasTree(uri, project, file, location);
        } else {
            this.mySchemasPanel.setVisible(false);
        }
        this.myFileTextField.addBrowseFolderListener(new TextBrowseFolderListener(FILE_CHOOSER_DESCRIPTOR, project));
        this.init();
    }

    private void setupSchemasTree(String uri, @NotNull Project project, @Nullable PsiFile file, @Nullable String location) {
        VirtualFile virtualFile;
        if (project == null) {
            MapExternalResourceDialog.$$$reportNull$$$0(0);
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.mySchemasTree.setModel(new DefaultTreeModel(root));
        ConfigFileSearcher searcher = new ConfigFileSearcher(file == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)file), project){

            @Override
            public Set<PsiFile> search(@Nullable Module module, @NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = XmlNamespaceIndex.getAllResources(module, project);
                HashSet<PsiFile> files = new HashSet<PsiFile>();
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                for (IndexedRelevantResource<String, XsdNamespaceBuilder> resource : resources) {
                    VirtualFile file = resource.getFile();
                    PsiFile psiFile = psiManager.findFile(file);
                    ContainerUtil.addIfNotNull(files, (Object)psiFile);
                }
                return files;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/MapExternalResourceDialog$2", "search"));
            }
        };
        searcher.search();
        new ConfigFilesTreeBuilder(this.mySchemasTree).buildTree(root, searcher);
        TreeUtil.expandAll((JTree)this.mySchemasTree);
        this.mySchemasTree.setRootVisible(false);
        this.mySchemasTree.setShowsRootHandles(true);
        ColoredTreeCellRenderer renderer = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    3.$$$reportNull$$$0(0);
                }
                ConfigFilesTreeBuilder.renderNode(value, expanded, this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javaee/MapExternalResourceDialog$3", "customizeCellRenderer"));
            }
        };
        renderer.setFont(EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN));
        this.mySchemasTree.setCellRenderer((TreeCellRenderer)renderer);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1 && MapExternalResourceDialog.this.isOKActionEnabled()) {
                    MapExternalResourceDialog.this.doOKAction();
                }
            }
        };
        this.mySchemasTree.addMouseListener(mouseAdapter);
        this.mySchemasTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MapExternalResourceDialog.this.validateInput();
            }
        });
        this.mySchemasTree.setSelectionRow(0);
        XmlFile schema = null;
        if (file != null) {
            schema = XmlUtil.findNamespaceByLocation(file, uri);
        } else if (location != null && (virtualFile = VfsUtilCore.findRelativeFile((String)location, null)) != null) {
            schema = PsiManager.getInstance((Project)project).findFile(virtualFile);
        }
        if (schema != null) {
            DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)schema);
            if (node != null) {
                this.mySchemaFound = true;
                TreeUtil.selectNode((JTree)this.mySchemasTree, (TreeNode)node);
            }
            this.myFileTextField.setText(schema.getVirtualFile().getCanonicalPath());
        }
    }

    private void validateInput() {
        this.setOKActionEnabled(!StringUtil.isEmpty((String)this.myUri.getText()) && this.getResourceLocation() != null);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return StringUtil.isEmpty((String)this.myUri.getText()) ? this.myUri : (this.mySchemaFound ? this.mySchemasTree : this.myFileTextField.getTextField());
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getUri() {
        return this.myUri.getText();
    }

    @Nullable
    public String getResourceLocation() {
        if (this.mySchemasTree.hasFocus()) {
            TreePath path = this.mySchemasTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            Object object = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (!(object instanceof PsiFile)) {
                return null;
            }
            return FileUtil.toSystemIndependentName((String)((PsiFile)object).getVirtualFile().getPath());
        }
        return this.myFileTextField.getText();
    }

    @Nullable
    protected String getHelpId() {
        return "Map External Resource dialog";
    }

    private void createUIComponents() {
        FileTextField field = FileChooserFactory.getInstance().createFileTextField(FILE_CHOOSER_DESCRIPTOR, this.getDisposable());
        this.myFileTextField = new TextFieldWithBrowseButton(field.getField());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "");
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("URI:");
        jBLabel.setDisplayedMnemonic('U');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myUri = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySchemasPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.putClientProperty("html.disable", Boolean.FALSE);
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Project &Schemas", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Tree tree = new Tree();
        this.mySchemasTree = tree;
        jBScrollPane.setViewportView((Component)tree);
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myFileTextField;
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("File:");
        jBLabel2.setDisplayedMnemonic('F');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jTextField);
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/MapExternalResourceDialog", "setupSchemasTree"));
    }
}

