/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.NotNull;

public class EscapeEntitiesAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler {
    private static String escape(XmlFile file, TIntObjectHashMap<String> map, String text, int start) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String escape;
            char c = text.charAt(i);
            PsiElement element = file.findElementAt(start + i);
            if (element != null && EscapeEntitiesAction.isCharacterElement(element) && (c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'' || c > '\u007f') && (escape = (String)map.get((int)c)) != null) {
                result.append("&").append(escape).append(";");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @NotNull
    private static TIntObjectHashMap<String> computeMap(XmlFile xmlFile) {
        XmlFile file = XmlUtil.findXmlFile((PsiFile)xmlFile, Html5SchemaProvider.getCharsDtdLocation());
        assert (file != null);
        TIntObjectHashMap result = new TIntObjectHashMap();
        XmlUtil.processXmlElements((XmlElement)file, element -> {
            String value;
            int key;
            if (element instanceof XmlEntityDecl && !result.containsKey(key = Integer.parseInt((value = ((XmlEntityDecl)element).getValueElement().getValue()).substring(2, value.length() - 1)))) {
                result.put(key, (Object)((XmlEntityDecl)element).getName());
            }
            return true;
        }, true);
        TIntObjectHashMap tIntObjectHashMap = result;
        if (tIntObjectHashMap == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(0);
        }
        return tIntObjectHashMap;
    }

    private static boolean isCharacterElement(PsiElement element) {
        IElementType type = element.getNode().getElementType();
        if (type == XmlTokenType.XML_DATA_CHARACTERS) {
            return true;
        }
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && element.getParent().getParent() instanceof XmlAttribute) {
            return true;
        }
        if (type == XmlTokenType.XML_BAD_CHARACTER) {
            return true;
        }
        if (type == XmlTokenType.XML_START_TAG_START) {
            if (element.getNextSibling() instanceof PsiErrorElement) {
                return true;
            }
            if (element.getParent() instanceof PsiErrorElement) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(2);
        }
        if (file == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(3);
        }
        return file instanceof XmlFile;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        EscapeEntitiesAction escapeEntitiesAction = this;
        if (escapeEntitiesAction == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(4);
        }
        return escapeEntitiesAction;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(7);
        }
        int[] starts = editor.getSelectionModel().getBlockSelectionStarts();
        int[] ends = editor.getSelectionModel().getBlockSelectionEnds();
        Document document = editor.getDocument();
        XmlFile xmlFile = (XmlFile)file;
        TIntObjectHashMap<String> map = EscapeEntitiesAction.computeMap(xmlFile);
        for (int i = starts.length - 1; i >= 0; --i) {
            String newText;
            int start = starts[i];
            int end = ends[i];
            String oldText = document.getText(new TextRange(start, end));
            if (oldText.equals(newText = EscapeEntitiesAction.escape(xmlFile, map, oldText, start))) continue;
            document.replaceString(start, end, (CharSequence)newText);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/actions/EscapeEntitiesAction";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/actions/EscapeEntitiesAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

