/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en.repeat;

import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.language.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatRule;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J#\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J7\u0010\u0011\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\f\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0013J+\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/languagetool/rules/en/repeat/EnglishWordRepeatRule;", "Lorg/languagetool/rules/WordRepeatRule;", "messages", "Ljava/util/ResourceBundle;", "language", "Lorg/languagetool/language/Language;", "(Ljava/util/ResourceBundle;Lorg/languagetool/language/Language;)V", "getId", "", "ignore", "", "tokens", "", "Lorg/languagetool/analysis/AnalyzedTokenReadings;", "position", "", "([Lorg/languagetool/analysis/AnalyzedTokenReadings;I)Z", "posIsIn", "posTags", "([Lorg/languagetool/analysis/AnalyzedTokenReadings;I[Ljava/lang/String;)Z", "wordRepetitionOf", "word", "(Ljava/lang/String;[Lorg/languagetool/analysis/AnalyzedTokenReadings;I)Z", "en"})
public final class EnglishWordRepeatRule
extends WordRepeatRule {
    @NotNull
    public String getId() {
        return "ENGLISH_WORD_REPEAT_RULE";
    }

    public boolean ignore(@NotNull AnalyzedTokenReadings[] tokens, int position) {
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        if (position == 0) {
            return false;
        }
        if (this.wordRepetitionOf("had", tokens, position) && this.posIsIn(tokens, position - 2, "PRP", "NN")) {
            return true;
        }
        if (this.wordRepetitionOf("that", tokens, position) && this.posIsIn(tokens, position + 1, "NN", "PRP$", "JJ", "VBZ", "VBD")) {
            return true;
        }
        if (this.wordRepetitionOf("can", tokens, position) && this.posIsIn(tokens, position - 1, "NN")) {
            return true;
        }
        if (this.wordRepetitionOf("blah", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("yadda", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("Pago", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("Wagga", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("Duran", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("sapiens", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("tse", tokens, position)) {
            return true;
        }
        if (this.wordRepetitionOf("Li", tokens, position)) {
            return true;
        }
        if (StringsKt.endsWith$default((String)tokens[position].getToken(), (String)"ay", (boolean)false, (int)2, null)) {
            if (Intrinsics.areEqual((Object)tokens[position - 1].getToken(), (Object)"may") && Intrinsics.areEqual((Object)tokens[position].getToken(), (Object)"May")) {
                return true;
            }
            if (Intrinsics.areEqual((Object)tokens[position - 1].getToken(), (Object)"May") && Intrinsics.areEqual((Object)tokens[position].getToken(), (Object)"may")) {
                return true;
            }
            if (Intrinsics.areEqual((Object)tokens[1].getToken(), (Object)"May") && Intrinsics.areEqual((Object)tokens[2].getToken(), (Object)"May")) {
                return true;
            }
        }
        return StringsKt.endsWith$default((String)tokens[position].getToken(), (String)"ill", (boolean)false, (int)2, null) ? position > 0 && Intrinsics.areEqual((Object)tokens[position - 1].getToken(), (Object)"will") && Intrinsics.areEqual((Object)tokens[position].getToken(), (Object)"Will") || Intrinsics.areEqual((Object)tokens[position - 1].getToken(), (Object)"Will") && Intrinsics.areEqual((Object)tokens[position].getToken(), (Object)"will") || Intrinsics.areEqual((Object)tokens[1].getToken(), (Object)"Will") && Intrinsics.areEqual((Object)tokens[2].getToken(), (Object)"Will") : false;
    }

    private final boolean posIsIn(AnalyzedTokenReadings[] tokens, int position, String ... posTags) {
        if (position >= 0 && position < tokens.length) {
            for (String posTag : posTags) {
                if (!tokens[position].hasPartialPosTag(posTag)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean wordRepetitionOf(String word, AnalyzedTokenReadings[] tokens, int position) {
        return Intrinsics.areEqual((Object)tokens[position - 1].getToken(), (Object)word) && Intrinsics.areEqual((Object)tokens[position].getToken(), (Object)word);
    }

    public EnglishWordRepeatRule(@NotNull ResourceBundle messages, @NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        super(messages, language);
        this.addExamplePair(Example.wrong((String)"This <marker>is is</marker> just an example sentence."), Example.fixed((String)"This <marker>is</marker> just an example sentence."));
    }
}

