/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en.replace;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.languagetool.language.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\u001a\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000f0\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/languagetool/rules/en/replace/ContractionSpellingRule;", "Lorg/languagetool/rules/AbstractSimpleReplaceRule;", "messages", "Ljava/util/ResourceBundle;", "language", "Lorg/languagetool/language/Language;", "(Ljava/util/ResourceBundle;Lorg/languagetool/language/Language;)V", "getDescription", "", "getId", "getLocale", "Ljava/util/Locale;", "getMessage", "tokenStr", "replacements", "", "getShort", "getWrongWords", "", "isCaseSensitive", "", "Companion", "en"})
public final class ContractionSpellingRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords;
    private static final Locale EN_LOCALE;
    public static final Companion Companion;

    @NotNull
    protected Map<String, List<String>> getWrongWords() {
        Map<String, List<String>> map = wrongWords;
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"ContractionSpellingRule.wrongWords");
        return map;
    }

    @NotNull
    public String getId() {
        return "EN_CONTRACTION_SPELLING";
    }

    @NotNull
    public String getDescription() {
        return "Spelling of English contractions";
    }

    @NotNull
    public String getShort() {
        return "Spelling mistake";
    }

    @NotNull
    public String getMessage(@NotNull String tokenStr, @NotNull List<String> replacements) {
        Intrinsics.checkParameterIsNotNull((Object)tokenStr, (String)"tokenStr");
        Intrinsics.checkParameterIsNotNull(replacements, (String)"replacements");
        return "Possible spelling mistake found";
    }

    public boolean isCaseSensitive() {
        return true;
    }

    @NotNull
    public Locale getLocale() {
        return EN_LOCALE;
    }

    public ContractionSpellingRule(@NotNull ResourceBundle messages, @NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages, language));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"We <marker>havent</marker> earned anything."), Example.fixed((String)"We <marker>haven't</marker> earned anything."));
    }

    static {
        Companion = new Companion(null);
        wrongWords = ContractionSpellingRule.access$loadFromPath$s837799580("/en/contractions.txt");
        EN_LOCALE = new Locale("en");
    }

    public static final /* synthetic */ Map access$loadFromPath$s837799580(String p0) {
        return AbstractSimpleReplaceRule.loadFromPath((String)p0);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0086\u0001\u0010\u0005\u001az\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012(\u0012&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\n0\t \b*<\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012(\u0012&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\n0\t\u0018\u00010\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/languagetool/rules/en/replace/ContractionSpellingRule$Companion;", "", "()V", "EN_LOCALE", "Ljava/util/Locale;", "wrongWords", "", "", "kotlin.jvm.PlatformType", "", "", "", "en"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

