/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.NativeCredentialStoreWrapper;
import com.intellij.credentialStore.NativeCredentialStoreWrapperKt;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0096\u0002J\u001b\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0096\u0002RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000e\u001a.\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0011\u00a2\u0006\u0002\b\u00100\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/credentialStore/NativeCredentialStoreWrapper;", "Lcom/intellij/credentialStore/CredentialStore;", "Ljava/io/Closeable;", "store", "(Lcom/intellij/credentialStore/CredentialStore;)V", "deniedItems", "Lcom/google/common/cache/Cache;", "Lcom/intellij/credentialStore/CredentialAttributes;", "kotlin.jvm.PlatformType", "", "fallbackStore", "Lkotlin/Lazy;", "Lcom/intellij/credentialStore/keePass/InMemoryCredentialStore;", "postponedCredentials", "postponedRemovedCredentials", "", "Lorg/jetbrains/annotations/NotNull;", "", "queueProcessor", "Lcom/intellij/util/concurrency/QueueProcessor;", "Lkotlin/Function0;", "", "close", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "set", "credentials", "intellij.platform.credentialStore"})
final class NativeCredentialStoreWrapper
implements CredentialStore,
Closeable {
    private final Lazy<InMemoryCredentialStore> fallbackStore;
    private final QueueProcessor<Function0<Unit>> queueProcessor;
    private final InMemoryCredentialStore postponedCredentials;
    private final Set<CredentialAttributes> postponedRemovedCredentials;
    private final Cache<CredentialAttributes, Boolean> deniedItems;
    private final CredentialStore store;

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        if (this.postponedRemovedCredentials.contains(attributes)) {
            return null;
        }
        Credentials credentials2 = this.postponedCredentials.get(attributes);
        if (credentials2 != null) {
            Credentials credentials3 = credentials2;
            boolean bl = false;
            boolean bl2 = false;
            Credentials it = credentials3;
            boolean bl3 = false;
            return it;
        }
        if (attributes.getCacheDeniedItems() && this.deniedItems.getIfPresent((Object)attributes) != null) {
            CredentialStoreKt.getLOG().warn("User denied access to " + attributes);
            return CredentialStoreKt.getACCESS_TO_KEY_CHAIN_DENIED();
        }
        CredentialStore store = this.fallbackStore.isInitialized() ? (CredentialStore)this.fallbackStore.getValue() : this.store;
        try {
            Credentials value = store.get(attributes);
            if (attributes.getCacheDeniedItems() && value == CredentialStoreKt.getACCESS_TO_KEY_CHAIN_DENIED()) {
                this.deniedItems.put((Object)attributes, (Object)true);
            }
            return value;
        }
        catch (UnsatisfiedLinkError e) {
            store = (CredentialStore)this.fallbackStore.getValue();
            NativeCredentialStoreWrapperKt.access$notifyUnsatisfiedLinkError(e);
            return store.get(attributes);
        }
        catch (Throwable e) {
            CredentialStoreKt.getLOG().error(e);
            return null;
        }
    }

    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials2) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        if (this.fallbackStore.isInitialized()) {
            ((InMemoryCredentialStore)this.fallbackStore.getValue()).set(attributes, credentials2);
            return;
        }
        if (credentials2 == null) {
            this.postponedRemovedCredentials.add(attributes);
        } else {
            this.postponedCredentials.set(attributes, credentials2);
        }
        this.queueProcessor.add((Object)new Function0<Unit>(this, attributes, credentials2){
            final /* synthetic */ NativeCredentialStoreWrapper this$0;
            final /* synthetic */ CredentialAttributes $attributes;
            final /* synthetic */ Credentials $credentials;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    CredentialStore store = NativeCredentialStoreWrapper.access$getFallbackStore$p(this.this$0).isInitialized() ? (CredentialStore)NativeCredentialStoreWrapper.access$getFallbackStore$p(this.this$0).getValue() : NativeCredentialStoreWrapper.access$getStore$p(this.this$0);
                    try {
                        store.set(this.$attributes, this.$credentials);
                    }
                    catch (UnsatisfiedLinkError e) {
                        store = (CredentialStore)NativeCredentialStoreWrapper.access$getFallbackStore$p(this.this$0).getValue();
                        NativeCredentialStoreWrapperKt.access$notifyUnsatisfiedLinkError(e);
                        store.set(this.$attributes, this.$credentials);
                    }
                    catch (Throwable e) {
                        CredentialStoreKt.getLOG().error(e);
                    }
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                finally {
                    if (!NativeCredentialStoreWrapper.access$getPostponedRemovedCredentials$p(this.this$0).remove(this.$attributes)) {
                        NativeCredentialStoreWrapper.access$getPostponedCredentials$p(this.this$0).set(this.$attributes, null);
                    }
                }
            }
            {
                this.this$0 = nativeCredentialStoreWrapper;
                this.$attributes = credentialAttributes;
                this.$credentials = credentials2;
                super(0);
            }
        });
    }

    @Override
    public void close() {
        if (this.store instanceof Closeable) {
            this.queueProcessor.waitFor();
            ((Closeable)this.store).close();
        }
    }

    public NativeCredentialStoreWrapper(@NotNull CredentialStore store) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        this.store = store;
        this.fallbackStore = LazyKt.lazy((Function0)fallbackStore.1.INSTANCE);
        this.queueProcessor = new QueueProcessor((Consumer)queueProcessor.1.INSTANCE);
        this.postponedCredentials = new InMemoryCredentialStore();
        Set set2 = ContainerUtil.newConcurrentSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"ContainerUtil.newConcurr\u2026t<CredentialAttributes>()");
        this.postponedRemovedCredentials = set2;
        this.deniedItems = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    public static final /* synthetic */ Lazy access$getFallbackStore$p(NativeCredentialStoreWrapper $this) {
        return $this.fallbackStore;
    }

    public static final /* synthetic */ CredentialStore access$getStore$p(NativeCredentialStoreWrapper $this) {
        return $this.store;
    }

    public static final /* synthetic */ Set access$getPostponedRemovedCredentials$p(NativeCredentialStoreWrapper $this) {
        return $this.postponedRemovedCredentials;
    }

    public static final /* synthetic */ InMemoryCredentialStore access$getPostponedCredentials$p(NativeCredentialStoreWrapper $this) {
        return $this.postponedCredentials;
    }
}

