/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.OneTimeStringKt;
import com.intellij.credentialStore.kdbx.SecureString;
import com.intellij.util.io.IoKt;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/credentialStore/kdbx/StringProtectedByStreamCipher;", "Lcom/intellij/credentialStore/kdbx/SecureString;", "value", "", "cipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "(Ljava/lang/CharSequence;Lorg/bouncycastle/crypto/SkippingStreamCipher;)V", "", "([BLorg/bouncycastle/crypto/SkippingStreamCipher;)V", "data", "position", "", "get", "Lcom/intellij/credentialStore/OneTimeString;", "clearable", "", "getAsByteArray", "intellij.platform.credentialStore"})
public final class StringProtectedByStreamCipher
implements SecureString {
    private final long position;
    private final byte[] data;
    private final SkippingStreamCipher cipher;

    @Override
    @NotNull
    public OneTimeString get(boolean clearable) {
        return OneTimeStringKt.OneTimeString$default((byte[])this.getAsByteArray(), (int)0, (int)0, (boolean)clearable, (int)6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] getAsByteArray() {
        byte[] value = new byte[this.data.length];
        SkippingStreamCipher skippingStreamCipher = this.cipher;
        boolean bl = false;
        int n = 0;
        synchronized (skippingStreamCipher) {
            boolean bl2 = false;
            this.cipher.seekTo(this.position);
            n = this.cipher.processBytes(this.data, 0, this.data.length, value, 0);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringProtectedByStreamCipher(@NotNull byte[] value, @NotNull SkippingStreamCipher cipher) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)cipher, (String)"cipher");
        this.cipher = cipher;
        Ref.LongRef longRef = new Ref.LongRef();
        this.data = new byte[value.length];
        SkippingStreamCipher skippingStreamCipher = this.cipher;
        boolean bl = false;
        int n = 0;
        synchronized (skippingStreamCipher) {
            boolean bl2 = false;
            longRef.element = this.cipher.getPosition();
            n = this.cipher.processBytes(value, 0, value.length, this.data, 0);
        }
        this.position = longRef.element;
    }

    public StringProtectedByStreamCipher(@NotNull CharSequence value, @NotNull SkippingStreamCipher cipher) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)cipher, (String)"cipher");
        ByteBuffer byteBuffer = Charsets.UTF_8.encode(CharBuffer.wrap(value));
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"Charsets.UTF_8.encode(CharBuffer.wrap(value))");
        this(IoKt.toByteArray$default((ByteBuffer)byteBuffer, (boolean)false, (int)1, null), cipher);
    }
}

