/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.DomModelCache;
import com.intellij.util.xml.model.MultipleDomModelFactory;
import com.intellij.util.xml.model.impl.CachedDomModelFactory;
import com.intellij.util.xml.model.impl.DomModelFactoryHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedMultipleDomModelFactory<Scope extends UserDataHolder, T extends DomElement, M extends DomModel<T>, C extends PsiElement>
extends DomModelFactoryHelper<T>
implements CachedDomModelFactory<T, M, Scope>,
MultipleDomModelFactory<Scope, T, M> {
    private final DomModelCache<M, Scope> myCombinedModelCache;
    private final DomModelCache<List<M>, Scope> myAllModelsCache;

    protected CachedMultipleDomModelFactory(@NotNull Class<T> aClass, @NotNull ModelMerger modelMerger, Project project, @NonNls String name) {
        if (aClass == null) {
            CachedMultipleDomModelFactory.$$$reportNull$$$0(0);
        }
        if (modelMerger == null) {
            CachedMultipleDomModelFactory.$$$reportNull$$$0(1);
        }
        super(aClass, modelMerger);
        this.myCombinedModelCache = new DomModelCache<M, Scope>(project, name + " combined model"){

            @Override
            @NotNull
            protected CachedValueProvider.Result<M> computeValue(@NotNull Scope scope) {
                if (scope == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object combinedModel = CachedMultipleDomModelFactory.this.computeCombinedModel(scope);
                return new CachedValueProvider.Result(combinedModel, CachedMultipleDomModelFactory.this.computeDependencies(combinedModel, scope));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/xml/model/impl/CachedMultipleDomModelFactory$1", "computeValue"));
            }
        };
        this.myAllModelsCache = new DomModelCache<List<M>, Scope>(project, name + " models list"){

            @Override
            @NotNull
            protected CachedValueProvider.Result<List<M>> computeValue(@NotNull Scope scope) {
                if (scope == null) {
                    2.$$$reportNull$$$0(0);
                }
                List models = CachedMultipleDomModelFactory.this.computeAllModels(scope);
                return new CachedValueProvider.Result(models, CachedMultipleDomModelFactory.this.computeDependencies(null, scope));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/xml/model/impl/CachedMultipleDomModelFactory$2", "computeValue"));
            }
        };
    }

    @Nullable
    public abstract M getModel(@NotNull C var1);

    @Override
    @NotNull
    public List<M> getAllModels(@NotNull Scope scope) {
        List<M> models;
        if (scope == null) {
            CachedMultipleDomModelFactory.$$$reportNull$$$0(2);
        }
        if ((models = this.myAllModelsCache.getCachedValue(scope)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                CachedMultipleDomModelFactory.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<M> list = models;
        if (list == null) {
            CachedMultipleDomModelFactory.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    protected abstract List<M> computeAllModels(@NotNull Scope var1);

    @Override
    @Nullable
    public M getCombinedModel(@Nullable Scope scope) {
        if (scope == null) {
            return null;
        }
        return (M)((DomModel)this.myCombinedModelCache.getCachedValue(scope));
    }

    @Nullable
    protected M computeCombinedModel(@NotNull Scope scope) {
        if (scope == null) {
            CachedMultipleDomModelFactory.$$$reportNull$$$0(5);
        }
        List<M> models = this.getAllModels(scope);
        switch (models.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (M)((DomModel)models.get(0));
            }
        }
        LinkedHashSet<XmlFile> configFiles = new LinkedHashSet<XmlFile>();
        LinkedHashSet list = new LinkedHashSet(models.size());
        for (DomModel model : models) {
            Set<XmlFile> files = model.getConfigFiles();
            for (XmlFile file : files) {
                ContainerUtil.addIfNotNull(list, this.getDomRoot(file));
            }
            configFiles.addAll(files);
        }
        DomFileElement mergedModel = this.getModelMerger().mergeModels(DomFileElement.class, list);
        DomModel firstModel = (DomModel)models.get(0);
        return (M)this.createCombinedModel(configFiles, mergedModel, firstModel, scope);
    }

    protected abstract M createCombinedModel(Set<XmlFile> var1, DomFileElement<T> var2, M var3, Scope var4);

    @NotNull
    public Set<XmlFile> getConfigFiles(@Nullable C context) {
        if (context == null) {
            Set<XmlFile> set = Collections.emptySet();
            if (set == null) {
                CachedMultipleDomModelFactory.$$$reportNull$$$0(6);
            }
            return set;
        }
        M model = this.getModel(context);
        if (model == null) {
            Set<XmlFile> set = Collections.emptySet();
            if (set == null) {
                CachedMultipleDomModelFactory.$$$reportNull$$$0(7);
            }
            return set;
        }
        Set<XmlFile> set = model.getConfigFiles();
        if (set == null) {
            CachedMultipleDomModelFactory.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<XmlFile> getAllConfigFiles(@NotNull Scope scope) {
        if (scope == null) {
            CachedMultipleDomModelFactory.$$$reportNull$$$0(9);
        }
        HashSet<XmlFile> xmlFiles = new HashSet<XmlFile>();
        for (DomModel model : this.getAllModels(scope)) {
            xmlFiles.addAll(model.getConfigFiles());
        }
        HashSet<XmlFile> hashSet = xmlFiles;
        if (hashSet == null) {
            CachedMultipleDomModelFactory.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    public List<DomFileElement<T>> getFileElements(M model) {
        ArrayList<DomFileElement<T>> list = new ArrayList<DomFileElement<T>>(model.getConfigFiles().size());
        for (XmlFile configFile : model.getConfigFiles()) {
            DomFileElement element = DomManager.getDomManager(configFile.getProject()).getFileElement(configFile, this.myClass);
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelMerger";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/model/impl/CachedMultipleDomModelFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/model/impl/CachedMultipleDomModelFactory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModels";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllModels";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeCombinedModel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllConfigFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

