/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.vcsUtil.VcsImplUtil;
import git4idea.repo.GitRemote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.pullrequest.GHPRAccountsComponent;
import org.jetbrains.plugins.github.pullrequest.GHPRToolWindowsTabsContentManager;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\bJ\u0015\u0010\u0017\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t*\u00020\u000b2\r\u0010\u0007\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRToolWindowsTabsContentManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "viewContentManager", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentI;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentI;)V", "value", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "Lorg/jetbrains/annotations/Nullable;", "remoteUrl", "Lcom/intellij/ui/content/Content;", "getRemoteUrl", "(Lcom/intellij/ui/content/Content;)Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "setRemoteUrl", "(Lcom/intellij/ui/content/Content;Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;)V", "addTab", "", "onDispose", "Lcom/intellij/openapi/Disposable;", "addTab$intellij_vcs_github", "createContent", "focusTab", "removeTab", "removeTab$intellij_vcs_github", "updateTabNames", "Companion", "intellij.vcs.github"})
public final class GHPRToolWindowsTabsContentManager {
    private final Project project;
    private final ChangesViewContentI viewContentManager;
    @Nls
    private static final String GROUP_PREFIX = "Pull Requests";
    private static final Key<GitRemoteUrlCoordinates> REMOTE_URL;
    public static final Companion Companion;

    public final void addTab$intellij_vcs_github(@NotNull GitRemoteUrlCoordinates remoteUrl, @NotNull Disposable onDispose) {
        Intrinsics.checkParameterIsNotNull((Object)remoteUrl, (String)"remoteUrl");
        Intrinsics.checkParameterIsNotNull((Object)onDispose, (String)"onDispose");
        this.viewContentManager.addContent(this.createContent(remoteUrl, onDispose));
        this.updateTabNames();
    }

    public final void removeTab$intellij_vcs_github(@NotNull GitRemoteUrlCoordinates remoteUrl) {
        Intrinsics.checkParameterIsNotNull((Object)remoteUrl, (String)"remoteUrl");
        List list2 = this.viewContentManager.findContents((Predicate)new Predicate<Content>(this, remoteUrl){
            final /* synthetic */ GHPRToolWindowsTabsContentManager this$0;
            final /* synthetic */ GitRemoteUrlCoordinates $remoteUrl;

            public final boolean test(Content it) {
                Content content2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"it");
                return Intrinsics.areEqual((Object)GHPRToolWindowsTabsContentManager.access$getRemoteUrl$p(this.this$0, content2), (Object)this.$remoteUrl);
            }
            {
                this.this$0 = gHPRToolWindowsTabsContentManager;
                this.$remoteUrl = gitRemoteUrlCoordinates;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"viewContentManager.findC\u2026.remoteUrl == remoteUrl }");
        Content content2 = (Content)CollectionsKt.firstOrNull((List)list2);
        if (content2 == null) {
            return;
        }
        Content content3 = content2;
        this.viewContentManager.removeContent(content3);
    }

    public final void focusTab(@NotNull GitRemoteUrlCoordinates remoteUrl) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)remoteUrl, (String)"remoteUrl");
            List list2 = this.viewContentManager.findContents((Predicate)new Predicate<Content>(this, remoteUrl){
                final /* synthetic */ GHPRToolWindowsTabsContentManager this$0;
                final /* synthetic */ GitRemoteUrlCoordinates $remoteUrl;

                public final boolean test(Content it) {
                    Content content2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"it");
                    return Intrinsics.areEqual((Object)GHPRToolWindowsTabsContentManager.access$getRemoteUrl$p(this.this$0, content2), (Object)this.$remoteUrl);
                }
                {
                    this.this$0 = gHPRToolWindowsTabsContentManager;
                    this.$remoteUrl = gitRemoteUrlCoordinates;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"viewContentManager.findC\u2026.remoteUrl == remoteUrl }");
            Content content2 = (Content)CollectionsKt.firstOrNull((List)list2);
            if (content2 == null) {
                return;
            }
            Content content3 = content2;
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
            if (toolWindow == null) break block1;
            toolWindow.show(new Runnable(this, content3){
                final /* synthetic */ GHPRToolWindowsTabsContentManager this$0;
                final /* synthetic */ Content $content;

                public final void run() {
                    GHPRToolWindowsTabsContentManager.access$getViewContentManager$p(this.this$0).setSelectedContent(this.$content, true);
                }
                {
                    this.this$0 = gHPRToolWindowsTabsContentManager;
                    this.$content = content2;
                }
            });
        }
    }

    private final Content createContent(GitRemoteUrlCoordinates remoteUrl, Disposable onDispose) {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
        Disposable disposable2 = disposable;
        Disposer.register((Disposable)disposable2, (Disposable)new Disposable(this){
            final /* synthetic */ GHPRToolWindowsTabsContentManager this$0;

            public final void dispose() {
                GHPRToolWindowsTabsContentManager.access$updateTabNames(this.this$0);
            }
            {
                this.this$0 = gHPRToolWindowsTabsContentManager;
            }
        });
        Disposer.register((Disposable)disposable2, (Disposable)onDispose);
        Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)new JPanel(null), GROUP_PREFIX, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"ContentFactory.SERVICE.g\u2026ll), GROUP_PREFIX, false)");
        Content content3 = content2;
        content3.setCloseable(true);
        content3.setDisposer(disposable2);
        content3.setDescription(remoteUrl.getUrl());
        this.setRemoteUrl(content3, remoteUrl);
        content3.putUserData(ChangesViewContentManager.ORDER_WEIGHT_KEY, (Object)ChangesViewContentManager.TabOrderWeight.LAST.getWeight());
        content3.putUserData(ChangesViewContentManager.CONTENT_PROVIDER_SUPPLIER_KEY, (Object)new Function0<createContent.1>(this, remoteUrl, disposable2){
            final /* synthetic */ GHPRToolWindowsTabsContentManager this$0;
            final /* synthetic */ GitRemoteUrlCoordinates $remoteUrl;
            final /* synthetic */ Disposable $disposable;

            @NotNull
            public final createContent.1 invoke() {
                return new ChangesViewContentProvider(this){
                    final /* synthetic */ createContent.2 this$0;

                    @NotNull
                    public GHPRAccountsComponent initContent() {
                        return new GHPRAccountsComponent(GithubAuthenticationManager.Companion.getInstance(), GHPRToolWindowsTabsContentManager.access$getProject$p(this.this$0.this$0), this.this$0.$remoteUrl, this.this$0.$disposable);
                    }

                    public void disposeContent() {
                        Disposer.dispose((Disposable)this.this$0.$disposable);
                    }
                    {
                        this.this$0 = $outer;
                    }
                };
            }
            {
                this.this$0 = gHPRToolWindowsTabsContentManager;
                this.$remoteUrl = gitRemoteUrlCoordinates;
                this.$disposable = disposable;
                super(0);
            }
        });
        return content3;
    }

    private final void updateTabNames() {
        List list2 = this.viewContentManager.findContents((Predicate)new Predicate<Content>(this){
            final /* synthetic */ GHPRToolWindowsTabsContentManager this$0;

            public final boolean test(Content it) {
                Content content2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"it");
                return GHPRToolWindowsTabsContentManager.access$getRemoteUrl$p(this.this$0, content2) != null;
            }
            {
                this.this$0 = gHPRToolWindowsTabsContentManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"viewContentManager.findC\u2026 { it.remoteUrl != null }");
        List contents2 = list2;
        if (contents2.size() == 1) {
            Object object = CollectionsKt.single((List)contents2);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"contents.single()");
            ((Content)object).setDisplayName(GROUP_PREFIX);
        } else {
            boolean bl;
            block13: {
                Iterator $this$groupByTo$iv$iv;
                GitRemote it;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = contents2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Content content2 = (Content)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    GitRemoteUrlCoordinates gitRemoteUrlCoordinates = this.getRemoteUrl((Content)v2);
                    if (gitRemoteUrlCoordinates == null) {
                        Intrinsics.throwNpe();
                    }
                    GitRemote gitRemote = gitRemoteUrlCoordinates.getRemote();
                    collection.add(gitRemote);
                }
                Iterable $this$groupBy$iv = (List)destination$iv$iv;
                boolean $i$f$groupBy = false;
                $this$mapTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                Iterator iterator = $this$groupByTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object element$iv$iv = iterator.next();
                    it = (GitRemote)element$iv$iv;
                    boolean bl3 = false;
                    String key$iv$iv = it.getName();
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl4 = false;
                        ArrayList answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Iterable $this$any$iv = destination$iv$iv.values();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        List it2 = (List)element$iv;
                        boolean bl5 = false;
                        if (!(it2.size() > 1)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            boolean prefixRoot = bl;
            Iterator iterator = contents2.iterator();
            while (iterator.hasNext()) {
                GitRemoteUrlCoordinates remoteUrl;
                Content content3;
                Content content4 = content3 = (Content)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)content4, (String)"content");
                if (this.getRemoteUrl(content4) == null) {
                    Intrinsics.throwNpe();
                }
                if (prefixRoot) {
                    String shortRootName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)VcsImplUtil.getShortVcsRootName((Project)this.project, (VirtualFile)remoteUrl.getRepository().getRoot()), (String)"VcsImplUtil.getShortVcsR\u2026emoteUrl.repository.root)");
                    content3.setDisplayName("Pull Requests: " + shortRootName + '/' + remoteUrl.getRemote().getName());
                    continue;
                }
                content3.setDisplayName("Pull Requests: " + remoteUrl.getRemote().getName());
            }
        }
    }

    private final GitRemoteUrlCoordinates getRemoteUrl(@NotNull Content $this$remoteUrl) {
        return (GitRemoteUrlCoordinates)$this$remoteUrl.getUserData(REMOTE_URL);
    }

    private final void setRemoteUrl(@NotNull Content $this$remoteUrl, GitRemoteUrlCoordinates value) {
        $this$remoteUrl.putUserData(REMOTE_URL, (Object)value);
    }

    public GHPRToolWindowsTabsContentManager(@NotNull Project project, @NotNull ChangesViewContentI viewContentManager) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)viewContentManager, (String)"viewContentManager");
        this.project = project;
        this.viewContentManager = viewContentManager;
    }

    static {
        Companion = new Companion(null);
        REMOTE_URL = new Key("GHPR_REMOTE_URL");
    }

    public static final /* synthetic */ GitRemoteUrlCoordinates access$getRemoteUrl$p(GHPRToolWindowsTabsContentManager $this, Content $this$access_u24remoteUrl_u24p) {
        return $this.getRemoteUrl($this$access_u24remoteUrl_u24p);
    }

    public static final /* synthetic */ void access$setRemoteUrl$p(GHPRToolWindowsTabsContentManager $this, Content $this$access_u24remoteUrl_u24p, GitRemoteUrlCoordinates gitRemoteUrlCoordinates) {
        $this.setRemoteUrl($this$access_u24remoteUrl_u24p, gitRemoteUrlCoordinates);
    }

    public static final /* synthetic */ ChangesViewContentI access$getViewContentManager$p(GHPRToolWindowsTabsContentManager $this) {
        return $this.viewContentManager;
    }

    public static final /* synthetic */ void access$updateTabNames(GHPRToolWindowsTabsContentManager $this) {
        $this.updateTabNames();
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRToolWindowsTabsContentManager $this) {
        return $this.project;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRToolWindowsTabsContentManager$Companion;", "", "()V", "GROUP_PREFIX", "", "REMOTE_URL", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

