/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMergeabilityState;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRStatusChecksComponent$Controller$WhenMappings;
import org.jetbrains.plugins.github.ui.util.SingleValueModel;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatusChecksComponent;", "", "()V", "create", "Ljavax/swing/JComponent;", "model", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "createLink", "Lcom/intellij/ui/HyperlinkLabel;", "url", "", "getChecksResultsText", "failedChecks", "", "pendingChecks", "successfulChecks", "Controller", "intellij.vcs.github"})
public final class GHPRStatusChecksComponent {
    public static final GHPRStatusChecksComponent INSTANCE;

    @NotNull
    public final JComponent create(@NotNull SingleValueModel<GHPRMergeabilityState> model2) {
        Intrinsics.checkParameterIsNotNull(model2, (String)"model");
        JPanel panel2 = new JPanel(new FlowLayout(3, 0, 0));
        new Controller(model2, panel2);
        return panel2;
    }

    private final String getChecksResultsText(int failedChecks, int pendingChecks, int successfulChecks) {
        boolean bl = false;
        List results = new ArrayList();
        Object object = failedChecks;
        boolean bl2 = false;
        boolean bl3 = false;
        int it = ((Number)object).intValue();
        boolean bl4 = false;
        Object object2 = it > 0 ? object : null;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl3 = false;
            it = ((Number)object).intValue();
            boolean bl5 = false;
            object2 = it + " failing";
            if (object2 != null) {
                object = object2;
                bl2 = false;
                bl3 = false;
                Object it2 = object;
                boolean bl6 = false;
                results.add(it2);
            }
        }
        object = pendingChecks;
        bl2 = false;
        bl3 = false;
        int it3 = ((Number)object).intValue();
        boolean bl7 = false;
        Object object3 = it3 > 0 ? object : null;
        if (object3 != null) {
            object = object3;
            bl2 = false;
            bl3 = false;
            it3 = ((Number)object).intValue();
            boolean bl8 = false;
            object3 = it3 + " pending";
            if (object3 != null) {
                object = object3;
                bl2 = false;
                bl3 = false;
                Object it4 = object;
                boolean bl9 = false;
                results.add(it4);
            }
        }
        object = successfulChecks;
        bl2 = false;
        bl3 = false;
        int it5 = ((Number)object).intValue();
        boolean bl10 = false;
        Object object4 = it5 > 0 ? object : null;
        if (object4 != null) {
            object = object4;
            bl2 = false;
            bl3 = false;
            it5 = ((Number)object).intValue();
            boolean bl11 = false;
            object4 = it5 + " successful";
            if (object4 != null) {
                object = object4;
                bl2 = false;
                bl3 = false;
                Object it6 = object;
                boolean bl12 = false;
                results.add(it6);
            }
        }
        String checksText = failedChecks + pendingChecks + successfulChecks == 1 ? " check" : " checks";
        return StringUtil.join((Collection)results, (String)", ") + checksText;
    }

    private final HyperlinkLabel createLink(String url) {
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel("Open in browser");
        boolean bl = false;
        boolean bl2 = false;
        HyperlinkLabel $this$apply = hyperlinkLabel;
        boolean bl3 = false;
        $this$apply.setHyperlinkTarget(url);
        return hyperlinkLabel;
    }

    private GHPRStatusChecksComponent() {
    }

    static {
        GHPRStatusChecksComponent gHPRStatusChecksComponent;
        INSTANCE = gHPRStatusChecksComponent = new GHPRStatusChecksComponent();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatusChecksComponent$Controller;", "", "model", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "panel", "Ljavax/swing/JPanel;", "(Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Ljavax/swing/JPanel;)V", "update", "", "intellij.vcs.github"})
    private static final class Controller {
        private final SingleValueModel<GHPRMergeabilityState> model;
        private final JPanel panel;

        private final void update() {
            String string;
            Icon icon;
            this.panel.removeAll();
            GHPRMergeabilityState mergeability = this.model.getValue();
            GHPRMergeabilityState.ChecksState checksState = mergeability.getChecksState();
            if (checksState == GHPRMergeabilityState.ChecksState.NONE) {
                this.panel.setVisible(false);
                return;
            }
            JComponent jComponent = new JLabel();
            boolean bl = false;
            boolean bl2 = false;
            JLabel $this$apply = jComponent;
            boolean bl3 = false;
            switch (GHPRStatusChecksComponent$Controller$WhenMappings.$EnumSwitchMapping$0[checksState.ordinal()]) {
                case 1: 
                case 2: {
                    icon = AllIcons.RunConfigurations.TestError;
                    break;
                }
                case 3: {
                    icon = AllIcons.RunConfigurations.TestFailed;
                    break;
                }
                case 4: {
                    icon = AllIcons.RunConfigurations.TestNotRan;
                    break;
                }
                case 5: {
                    icon = AllIcons.RunConfigurations.TestPassed;
                    break;
                }
                default: {
                    icon = EmptyIcon.ICON_16;
                }
            }
            $this$apply.setIcon(icon);
            switch (GHPRStatusChecksComponent$Controller$WhenMappings.$EnumSwitchMapping$1[checksState.ordinal()]) {
                case 1: {
                    string = "Pull request branch is out of sync with the base branch";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = INSTANCE.getChecksResultsText(mergeability.getFailedChecks(), mergeability.getPendingChecks(), mergeability.getSuccessfulChecks());
                    break;
                }
                default: {
                    string = "";
                }
            }
            $this$apply.setText(string);
            JLabel label = jComponent;
            jComponent = this.panel;
            bl = false;
            bl2 = false;
            JComponent $this$with = jComponent;
            boolean bl4 = false;
            $this$with.add(label);
            $this$with.add((Component)INSTANCE.createLink(mergeability.getHtmlUrl()));
            $this$with.validate();
            $this$with.repaint();
            $this$with.setVisible(true);
        }

        public Controller(@NotNull SingleValueModel<GHPRMergeabilityState> model2, @NotNull JPanel panel2) {
            Intrinsics.checkParameterIsNotNull(model2, (String)"model");
            Intrinsics.checkParameterIsNotNull((Object)panel2, (String)"panel");
            this.model = model2;
            this.panel = panel2;
            this.update();
            this.model.addValueChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.update();
                }
            }));
        }
    }
}

