/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ImageLoader;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.ImageUtil;
import java.awt.Image;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.util.GithubImageResizer;
import org.jetbrains.plugins.github.util.NonReusableEmptyProgressIndicator;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "Lcom/intellij/openapi/Disposable;", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "progressIndicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "dispose", "", "requestImageResize", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/Image;", "image", "size", "", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "Companion", "intellij.vcs.github"})
public final class GithubImageResizer
implements Disposable {
    private final ExecutorService executor;
    private final EmptyProgressIndicator progressIndicator;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CompletableFuture<Image> requestImageResize(@NotNull Image image, int size, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)scaleContext, (String)"scaleContext");
        EmptyProgressIndicator indicator = this.progressIndicator;
        CompletableFuture<Image> completableFuture = CompletableFuture.supplyAsync((Supplier)new Supplier<Image>(indicator, image, scaleContext, size){
            final /* synthetic */ EmptyProgressIndicator $indicator;
            final /* synthetic */ Image $image;
            final /* synthetic */ ScaleContext $scaleContext;
            final /* synthetic */ int $size;

            @NotNull
            public final Image get() {
                return (Image)ProgressManager.getInstance().runProcess((Computable)new Computable<Image>(this){
                    final /* synthetic */ requestImageResize.1 this$0;

                    @NotNull
                    public final Image compute() {
                        this.this$0.$indicator.checkCanceled();
                        Image hidpiImage = ImageUtil.ensureHiDPI((Image)this.this$0.$image, (ScaleContext)this.this$0.$scaleContext);
                        this.this$0.$indicator.checkCanceled();
                        return ImageLoader.scaleImage((Image)hidpiImage, (int)this.this$0.$size);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, (ProgressIndicator)this.$indicator);
            }
            {
                this.$indicator = emptyProgressIndicator;
                this.$image = image;
                this.$scaleContext = scaleContext;
                this.$size = n;
            }
        }, this.executor);
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.supply\u2026dicator)\n    }, executor)");
        return completableFuture;
    }

    public void dispose() {
        this.progressIndicator.cancel();
        this.executor.shutdownNow();
    }

    public GithubImageResizer() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"GitHub Image Resizer", (Executor)ProcessIOExecutorService.INSTANCE, (int)GithubImageResizer.Companion.getThreadPoolSize());
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"AppExecutorUtil.createBo\u2026     getThreadPoolSize())");
        this.executor = executorService;
        this.progressIndicator = new NonReusableEmptyProgressIndicator();
    }

    @JvmStatic
    @NotNull
    public static final GithubImageResizer getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/util/GithubImageResizer$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "getThreadPoolSize", "", "intellij.vcs.github"})
    public static final class Companion {
        private final int getThreadPoolSize() {
            int n = Runtime.getRuntime().availableProcessors() / 2;
            int n2 = 1;
            boolean bl = false;
            return Math.max(n, n2);
        }

        @JvmStatic
        @NotNull
        public final GithubImageResizer getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(GithubImageResizer.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (GithubImageResizer)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

