/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

public class BooleanArrayAssert
extends ArrayAssert<BooleanArrayAssert, boolean[]> {
    protected BooleanArrayAssert(boolean ... actual) {
        super(BooleanArrayAssert.class, actual);
    }

    @Nonnull
    public BooleanArrayAssert contains(boolean ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public BooleanArrayAssert containsOnly(boolean ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    @Nonnull
    public BooleanArrayAssert excludes(boolean ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    @Nonnull
    public BooleanArrayAssert isEqualTo(@Nullable boolean[] expected) {
        if (Arrays.equals((boolean[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    @Nonnull
    public BooleanArrayAssert isNotEqualTo(@Nullable boolean[] array) {
        if (!Arrays.equals((boolean[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

